/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.lance;

import com.google.common.base.Preconditions;
import com.lancedb.lance.Dataset;
import com.lancedb.lance.WriteParams;
import com.lancedb.lance.index.DistanceType;
import com.lancedb.lance.index.IndexParams;
import com.lancedb.lance.index.IndexType;
import com.lancedb.lance.index.vector.VectorIndexParams;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.catalog.ManagedSchemaOperations;
import org.apache.gravitino.catalog.ManagedTableOperations;
import org.apache.gravitino.connector.SupportsSchemas;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.lance.common.ops.gravitino.LanceDataTypeConverter;
import org.apache.gravitino.lance.common.utils.LancePropertiesUtils;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.indexes.Indexes;
import org.apache.gravitino.storage.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanceTableOperations
extends ManagedTableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(LanceTableOperations.class);
    private final EntityStore store;
    private final ManagedSchemaOperations schemaOps;
    private final IdGenerator idGenerator;

    public LanceTableOperations(EntityStore store, ManagedSchemaOperations schemaOps, IdGenerator idGenerator) {
        this.store = store;
        this.schemaOps = schemaOps;
        this.idGenerator = idGenerator;
    }

    protected EntityStore store() {
        return this.store;
    }

    protected SupportsSchemas schemas() {
        return this.schemaOps;
    }

    protected IdGenerator idGenerator() {
        return this.idGenerator;
    }

    public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        String location = properties.get("location");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)location), (Object)"Table location must be specified");
        CreationMode mode = Optional.ofNullable(properties.get("lance.creation-mode")).map(CreationMode::valueOf).orElse(CreationMode.CREATE);
        boolean register = Optional.ofNullable(properties.get("lance.register")).map(Boolean::parseBoolean).orElse(false);
        if (mode == CreationMode.EXIST_OK) {
            Preconditions.checkArgument((!register ? 1 : 0) != 0, (Object)"EXIST_OK mode is not supported for register operation");
            try {
                return super.loadTable(ident);
            }
            catch (NoSuchTableException noSuchTableException) {
                // empty catch block
            }
        }
        if (mode == CreationMode.OVERWRITE) {
            if (register) {
                this.dropTable(ident);
            } else {
                this.purgeTable(ident);
            }
        }
        return this.createTableInternal(ident, columns, comment, properties, partitions, distribution, sortOrders, indexes, register, location);
    }

    public Table alterTable(NameIdentifier ident, TableChange ... changes) throws NoSuchSchemaException, TableAlreadyExistsException {
        boolean onlyAddIndex = Arrays.stream(changes).allMatch(change -> change instanceof TableChange.AddIndex);
        Preconditions.checkArgument((boolean)onlyAddIndex, (Object)"Only adding indexes is supported for Lance tables");
        List<Index> addedIndexes = Arrays.stream(changes).filter(change -> change instanceof TableChange.AddIndex).map(change -> {
            TableChange.AddIndex addIndexChange = (TableChange.AddIndex)change;
            return Indexes.IndexImpl.builder().withIndexType(addIndexChange.getType()).withName(addIndexChange.getName()).withFieldNames(addIndexChange.getFieldNames()).build();
        }).collect(Collectors.toList());
        Table loadedTable = super.loadTable(ident);
        this.addLanceIndex(loadedTable, addedIndexes);
        return super.alterTable(ident, changes);
    }

    public boolean purgeTable(NameIdentifier ident) {
        try {
            Table table = this.loadTable(ident);
            String location = (String)table.properties().get("location");
            boolean purged = super.purgeTable(ident);
            if (purged) {
                Dataset.drop((String)location, (Map)LancePropertiesUtils.getLanceStorageOptions((Map)table.properties()));
                LOG.info("Deleted Lance dataset at location {}", (Object)location);
            }
            return purged;
        }
        catch (NoSuchTableException e) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to purge Lance dataset for table " + String.valueOf(ident), e);
        }
    }

    public boolean dropTable(NameIdentifier ident) {
        try {
            Table table = this.loadTable(ident);
            boolean external = Optional.ofNullable((String)table.properties().get("external")).map(Boolean::parseBoolean).orElse(false);
            boolean dropped = super.dropTable(ident);
            if (external) {
                return dropped;
            }
            if (dropped) {
                String location = (String)table.properties().get("location");
                Dataset.drop((String)location, (Map)LancePropertiesUtils.getLanceStorageOptions((Map)table.properties()));
                LOG.info("Deleted Lance dataset at location {}", (Object)location);
            }
            return dropped;
        }
        catch (NoSuchTableException e) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to drop Lance dataset for table " + String.valueOf(ident), e);
        }
    }

    Table createTableInternal(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions, Distribution distribution, SortOrder[] sortOrders, Index[] indexes, boolean register, String location) throws NoSuchSchemaException, TableAlreadyExistsException {
        Table table;
        block13: {
            if (register) {
                return super.createTable(ident, columns, comment, properties, partitions, distribution, sortOrders, indexes);
            }
            Map storageProps = LancePropertiesUtils.getLanceStorageOptions(properties);
            Dataset ignored = Dataset.create((BufferAllocator)new RootAllocator(), (String)location, (Schema)this.convertColumnsToArrowSchema(columns), (WriteParams)new WriteParams.Builder().withStorageOptions(storageProps).build());
            try {
                table = super.createTable(ident, columns, comment, properties, partitions, distribution, sortOrders, indexes);
                if (ignored == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchSchemaException e) {
                    throw e;
                }
                catch (TableAlreadyExistsException e) {
                    Dataset.drop((String)location, (Map)LancePropertiesUtils.getLanceStorageOptions(properties));
                    throw e;
                }
                catch (IllegalArgumentException e) {
                    if (e.getMessage().contains("Dataset already exists")) {
                        throw new TableAlreadyExistsException((Throwable)e, "Lance dataset already exists at location %s", new Object[]{location});
                    }
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create Lance dataset at location " + location, e);
                }
            }
            ignored.close();
        }
        return table;
    }

    private Schema convertColumnsToArrowSchema(Column[] columns) {
        List fields = Arrays.stream(columns).map(col -> LanceDataTypeConverter.CONVERTER.toArrowField(col.name(), col.dataType(), col.nullable())).collect(Collectors.toList());
        return new Schema(fields);
    }

    private void addLanceIndex(Table table, List<Index> addedIndexes) {
        String location = (String)table.properties().get("location");
        try (Dataset dataset = Dataset.open((String)location, (BufferAllocator)new RootAllocator());){
            for (Index index : addedIndexes) {
                IndexType indexType = IndexType.valueOf((String)index.type().name());
                IndexParams indexParams = this.getIndexParamsByIndexType(indexType);
                dataset.createIndex(Arrays.stream(index.fieldNames()).map(field -> String.join((CharSequence)".", field)).collect(Collectors.toList()), indexType, Optional.of(index.name()), indexParams, true);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add indexes to Lance dataset at location " + location, e);
        }
    }

    private IndexParams getIndexParamsByIndexType(IndexType indexType) {
        switch (indexType) {
            case SCALAR: {
                return IndexParams.builder().build();
            }
            case VECTOR: {
                int numberOfDimensions = 3;
                return IndexParams.builder().setVectorIndexParams(VectorIndexParams.ivfPq((int)2, (int)8, (int)numberOfDimensions, (DistanceType)DistanceType.L2, (int)2)).build();
            }
        }
        throw new IllegalArgumentException("Unsupported index type: " + String.valueOf(indexType));
    }

    public static enum CreationMode {
        CREATE,
        EXIST_OK,
        OVERWRITE;

    }
}

