/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.paimon.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.gravitino.catalog.lakehouse.paimon.utils.TypeUtils;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.types.DataType;

public class TableOpsUtils {
    public static final Joiner DOT = Joiner.on((String)".");

    public static void checkColumnCapability(String fieldName, Expression defaultValue, boolean autoIncrement) {
        TableOpsUtils.checkColumnDefaultValue(fieldName, defaultValue);
        TableOpsUtils.checkColumnAutoIncrement(fieldName, autoIncrement);
    }

    public static List<SchemaChange> buildSchemaChanges(TableChange ... tableChanges) throws UnsupportedOperationException {
        ArrayList<SchemaChange> schemaChanges = new ArrayList<SchemaChange>();
        for (TableChange tableChange : tableChanges) {
            schemaChanges.add(TableOpsUtils.buildSchemaChange(tableChange));
        }
        return schemaChanges;
    }

    public static SchemaChange buildSchemaChange(TableChange tableChange) throws UnsupportedOperationException {
        if (tableChange instanceof TableChange.ColumnChange) {
            if (tableChange instanceof TableChange.AddColumn) {
                TableChange.AddColumn addColumn = (TableChange.AddColumn)tableChange;
                String fieldName = TableOpsUtils.getFieldName((TableChange.ColumnChange)addColumn);
                TableOpsUtils.checkColumnCapability(fieldName, addColumn.getDefaultValue(), addColumn.isAutoIncrement());
                return SchemaChange.addColumn((String)fieldName, (DataType)TypeUtils.toPaimonType(addColumn.getDataType()).copy(addColumn.isNullable()), (String)addColumn.getComment(), (SchemaChange.Move)TableOpsUtils.move(fieldName, addColumn.getPosition()));
            }
            if (tableChange instanceof TableChange.DeleteColumn) {
                return SchemaChange.dropColumn((String)TableOpsUtils.getFieldName((TableChange.ColumnChange)((TableChange.DeleteColumn)tableChange)));
            }
            if (tableChange instanceof TableChange.RenameColumn) {
                TableChange.RenameColumn renameColumn = (TableChange.RenameColumn)tableChange;
                return SchemaChange.renameColumn((String)TableOpsUtils.getFieldName((TableChange.ColumnChange)renameColumn), (String)renameColumn.getNewName());
            }
            if (tableChange instanceof TableChange.UpdateColumnComment) {
                TableChange.UpdateColumnComment updateColumnComment = (TableChange.UpdateColumnComment)tableChange;
                return SchemaChange.updateColumnComment((String)TableOpsUtils.getFieldName((TableChange.ColumnChange)updateColumnComment), (String)updateColumnComment.getNewComment());
            }
            if (tableChange instanceof TableChange.UpdateColumnNullability) {
                TableChange.UpdateColumnNullability updateColumnNullability = (TableChange.UpdateColumnNullability)tableChange;
                return SchemaChange.updateColumnNullability((String)TableOpsUtils.getFieldName((TableChange.ColumnChange)updateColumnNullability), (boolean)updateColumnNullability.nullable());
            }
            if (tableChange instanceof TableChange.UpdateColumnPosition) {
                TableChange.UpdateColumnPosition updateColumnPosition = (TableChange.UpdateColumnPosition)tableChange;
                Preconditions.checkArgument((!(updateColumnPosition.getPosition() instanceof TableChange.Default) ? 1 : 0) != 0, (Object)"Default position is not supported for Paimon update column position.");
                return SchemaChange.updateColumnPosition((SchemaChange.Move)TableOpsUtils.move(TableOpsUtils.getFieldName((TableChange.ColumnChange)updateColumnPosition), updateColumnPosition.getPosition()));
            }
            if (tableChange instanceof TableChange.UpdateColumnType) {
                TableChange.UpdateColumnType updateColumnType = (TableChange.UpdateColumnType)tableChange;
                return SchemaChange.updateColumnType((String)TableOpsUtils.getFieldName((TableChange.ColumnChange)updateColumnType), (DataType)TypeUtils.toPaimonType(updateColumnType.getNewDataType()));
            }
        } else {
            if (tableChange instanceof TableChange.UpdateComment) {
                return SchemaChange.updateComment((String)((TableChange.UpdateComment)tableChange).getNewComment());
            }
            if (tableChange instanceof TableChange.SetProperty) {
                TableChange.SetProperty setProperty = (TableChange.SetProperty)tableChange;
                return SchemaChange.setOption((String)setProperty.getProperty(), (String)setProperty.getValue());
            }
            if (tableChange instanceof TableChange.RemoveProperty) {
                TableChange.RemoveProperty removeProperty = (TableChange.RemoveProperty)tableChange;
                return SchemaChange.removeOption((String)removeProperty.getProperty());
            }
        }
        throw new UnsupportedOperationException(String.format("Paimon does not support %s table change.", tableChange.getClass().getSimpleName()));
    }

    private static void checkColumnDefaultValue(String fieldName, Expression defaultValue) {
        Preconditions.checkArgument((boolean)defaultValue.equals(Column.DEFAULT_VALUE_NOT_SET), (Object)String.format("Paimon set column default value through table properties instead of column info. Illegal column: %s.", fieldName));
    }

    private static void checkColumnAutoIncrement(String fieldName, boolean autoIncrement) {
        Preconditions.checkArgument((!autoIncrement ? 1 : 0) != 0, (Object)String.format("Paimon does not support auto increment column. Illegal column: %s.", fieldName));
    }

    private static void checkNestedColumn(String[] fieldNames) {
        Preconditions.checkArgument((fieldNames.length == 1 ? 1 : 0) != 0, (Object)String.format("Paimon does not support update nested column. Illegal column: %s.", TableOpsUtils.getFieldName(fieldNames)));
    }

    public static String[] getFieldName(String fieldName) {
        return new String[]{fieldName};
    }

    public static String getFieldName(String[] fieldName) {
        return DOT.join((Object[])fieldName);
    }

    private static String getFieldName(TableChange.ColumnChange columnChange) {
        return TableOpsUtils.getFieldName(columnChange.fieldName());
    }

    private static SchemaChange.Move move(String fieldName, TableChange.ColumnPosition columnPosition) throws UnsupportedOperationException {
        if (columnPosition instanceof TableChange.After) {
            return SchemaChange.Move.after((String)fieldName, (String)((TableChange.After)columnPosition).getColumn());
        }
        if (columnPosition instanceof TableChange.Default) {
            return null;
        }
        if (columnPosition instanceof TableChange.First) {
            return SchemaChange.Move.first((String)fieldName);
        }
        throw new UnsupportedOperationException(String.format("Paimon does not support %s column position.", columnPosition.getClass().getSimpleName()));
    }
}

