/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.tag;

import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.operation.TagDeletion;
import org.apache.paimon.table.sink.TagCallback;
import org.apache.paimon.tag.Tag;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagTimeExpire {
    private static final Logger LOG = LoggerFactory.getLogger(TagTimeExpire.class);
    private final SnapshotManager snapshotManager;
    private final TagManager tagManager;
    private final TagDeletion tagDeletion;
    private final List<TagCallback> callbacks;
    private LocalDateTime olderThanTime;

    private TagTimeExpire(SnapshotManager snapshotManager, TagManager tagManager, TagDeletion tagDeletion, List<TagCallback> callbacks) {
        this.snapshotManager = snapshotManager;
        this.tagManager = tagManager;
        this.tagDeletion = tagDeletion;
        this.callbacks = callbacks;
    }

    public List<String> expire() {
        List<Pair<Tag, String>> tags = this.tagManager.tagObjects();
        ArrayList<String> expired = new ArrayList<String>();
        for (Pair<Tag, String> pair : tags) {
            boolean isOlderThan;
            Tag tag = (Tag)((Object)pair.getLeft());
            String tagName = (String)pair.getRight();
            LocalDateTime createTime = tag.getTagCreateTime();
            Duration timeRetained = tag.getTagTimeRetained();
            if (createTime == null || timeRetained == null) {
                FileStatus tagFileStatus;
                if (this.olderThanTime == null) continue;
                try {
                    tagFileStatus = this.snapshotManager.fileIO().getFileStatus(this.tagManager.tagPath(tagName));
                }
                catch (IOException e) {
                    LOG.warn("Tag path {} not exist, skip expire it.", (Object)this.tagManager.tagPath(tagName));
                    continue;
                }
                createTime = DateTimeUtils.toLocalDateTime((long)tagFileStatus.getModificationTime());
            }
            boolean isReachTimeRetained = timeRetained != null && LocalDateTime.now().isAfter(createTime.plus(timeRetained));
            boolean bl = isOlderThan = this.olderThanTime != null && this.olderThanTime.isAfter(createTime);
            if (!isReachTimeRetained && !isOlderThan) continue;
            LOG.info("Delete tag {}, because its existence time has reached its timeRetained of {} or its createTime {} is olderThan olderThanTime {}.", new Object[]{tagName, timeRetained, createTime, this.olderThanTime});
            this.tagManager.deleteTag(tagName, this.tagDeletion, this.snapshotManager, this.callbacks);
            expired.add(tagName);
        }
        return expired;
    }

    public TagTimeExpire withOlderThanTime(LocalDateTime olderThanTime) {
        this.olderThanTime = olderThanTime;
        return this;
    }

    public static TagTimeExpire create(SnapshotManager snapshotManager, TagManager tagManager, TagDeletion tagDeletion, List<TagCallback> callbacks) {
        return new TagTimeExpire(snapshotManager, tagManager, tagDeletion, callbacks);
    }
}

