/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.FileStore;
import org.apache.paimon.Snapshot;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.ManifestCacheFilter;
import org.apache.paimon.operation.LocalOrphanFilesClean;
import org.apache.paimon.options.ExpireConfig;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.BucketSpec;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.query.LocalTableQuery;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.table.sink.RowKeyExtractor;
import org.apache.paimon.table.sink.TableCommitImpl;
import org.apache.paimon.table.sink.TableWriteImpl;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.ChangelogManager;
import org.apache.paimon.utils.SegmentsCache;
import org.apache.paimon.utils.TagManager;

public interface FileStoreTable
extends DataTable {
    public void setManifestCache(SegmentsCache<Path> var1);

    public void setSnapshotCache(Cache<Path, Snapshot> var1);

    public void setStatsCache(Cache<String, Statistics> var1);

    @Override
    default public RowType rowType() {
        return this.schema().logicalRowType();
    }

    @Override
    default public List<String> partitionKeys() {
        return this.schema().partitionKeys();
    }

    @Override
    default public List<String> primaryKeys() {
        return this.schema().primaryKeys();
    }

    default public BucketSpec bucketSpec() {
        return new BucketSpec(this.bucketMode(), this.schema().bucketKeys(), this.schema().numBuckets());
    }

    default public BucketMode bucketMode() {
        return this.store().bucketMode();
    }

    @Override
    default public Map<String, String> options() {
        return this.schema().options();
    }

    @Override
    default public Optional<String> comment() {
        return Optional.ofNullable(this.schema().comment());
    }

    public TableSchema schema();

    public FileStore<?> store();

    public CatalogEnvironment catalogEnvironment();

    @Override
    public FileStoreTable copy(Map<String, String> var1);

    public FileStoreTable copy(TableSchema var1);

    public FileStoreTable copyWithoutTimeTravel(Map<String, String> var1);

    public FileStoreTable copyWithLatestSchema();

    @Override
    public TableWriteImpl<?> newWrite(String var1);

    public TableWriteImpl<?> newWrite(String var1, @Nullable ManifestCacheFilter var2, @Nullable Integer var3);

    @Override
    public TableCommitImpl newCommit(String var1);

    public LocalTableQuery newLocalTableQuery();

    public boolean supportStreamingReadOverwrite();

    public RowKeyExtractor createRowKeyExtractor();

    @Override
    public FileStoreTable switchToBranch(String var1);

    default public void purgeFiles() throws Exception {
        BranchManager branchManager = this.branchManager();
        branchManager.branches().forEach(branchManager::dropBranch);
        TagManager tagManager = this.tagManager();
        tagManager.allTagNames().forEach(this::deleteTag);
        ConsumerManager consumerManager = this.consumerManager();
        consumerManager.consumers().keySet().forEach(consumerManager::deleteConsumer);
        try (BatchTableCommit commit = this.newBatchWriteBuilder().newCommit();){
            commit.truncateTable();
        }
        ChangelogManager changelogManager = this.changelogManager();
        this.fileIO().delete(changelogManager.changelogDirectory(), true);
        this.newExpireSnapshots().config(ExpireConfig.builder().snapshotMaxDeletes(Integer.MAX_VALUE).snapshotRetainMax(1).snapshotRetainMin(1).snapshotTimeRetain(Duration.ZERO).build()).expire();
        LocalOrphanFilesClean clean = new LocalOrphanFilesClean(this, System.currentTimeMillis());
        clean.clean();
    }
}

