/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.query;

import java.net.InetSocketAddress;
import java.util.Optional;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.query.QueryLocation;
import org.apache.paimon.service.ServiceManager;
import org.apache.paimon.table.sink.ChannelComputer;

public class QueryLocationImpl
implements QueryLocation {
    private final ServiceManager manager;
    private InetSocketAddress[] addressesCache;

    public QueryLocationImpl(ServiceManager manager) {
        this.manager = manager;
    }

    @Override
    public InetSocketAddress getLocation(BinaryRow partition, int bucket, boolean forceUpdate) {
        if (this.addressesCache == null || forceUpdate) {
            Optional<InetSocketAddress[]> addresses = this.manager.service("primary-key-lookup");
            if (!addresses.isPresent()) {
                throw new RuntimeException("Cannot find address for table path: " + this.manager.tablePath());
            }
            this.addressesCache = addresses.get();
        }
        return this.addressesCache[ChannelComputer.select(partition, bucket, this.addressesCache.length)];
    }
}

