/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FunctionWithIOException;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.ParallelExecution;

public class SplitsParallelReadUtil {
    public static RecordReader<InternalRow> parallelExecute(RowType projectedType, FunctionWithIOException<Split, RecordReader<InternalRow>> readBuilder, List<Split> splits, int pageSize, int parallelism) {
        return SplitsParallelReadUtil.parallelExecute(projectedType, readBuilder, splits, pageSize, parallelism, split -> null, (row, unused) -> row);
    }

    public static <EXTRA> RecordReader<InternalRow> parallelExecute(RowType projectedType, FunctionWithIOException<Split, RecordReader<InternalRow>> readBuilder, List<Split> splits, int pageSize, int parallelism, Function<Split, EXTRA> extraFunction, final BiFunction<InternalRow, EXTRA, InternalRow> addExtraToRow) {
        ArrayList<Supplier<Pair>> suppliers = new ArrayList<Supplier<Pair>>();
        for (Split split : splits) {
            suppliers.add(() -> {
                try {
                    RecordReader reader = (RecordReader)readBuilder.apply((Object)split);
                    return Pair.of((Object)reader, extraFunction.apply(split));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        final ParallelExecution execution = new ParallelExecution((Serializer)InternalSerializers.create((RowType)projectedType), pageSize, parallelism, suppliers);
        return new RecordReader<InternalRow>(){

            @Nullable
            public RecordReader.RecordIterator<InternalRow> readBatch() throws IOException {
                ParallelExecution.ParallelBatch batch;
                try {
                    batch = execution.take();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                if (batch == null) {
                    return null;
                }
                return new RecordReader.RecordIterator<InternalRow>(){

                    @Nullable
                    public InternalRow next() throws IOException {
                        InternalRow row = (InternalRow)batch.next();
                        if (row == null) {
                            return null;
                        }
                        return (InternalRow)addExtraToRow.apply(row, batch.extraMessage());
                    }

                    public void releaseBatch() {
                        batch.releaseBatch();
                    }
                };
            }

            public void close() throws IOException {
                execution.close();
            }
        };
    }
}

