/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.disk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.paimon.disk.AbstractFileIOChannel;
import org.apache.paimon.disk.BufferFileWriter;
import org.apache.paimon.disk.FileIOChannel;
import org.apache.paimon.memory.Buffer;
import org.apache.paimon.utils.FileIOUtils;

public class BufferFileWriterImpl
extends AbstractFileIOChannel
implements BufferFileWriter {
    protected BufferFileWriterImpl(FileIOChannel.ID channelID) throws IOException {
        super(channelID, true);
    }

    @Override
    public void writeBlock(Buffer buffer) throws IOException {
        ByteBuffer nioBufferReadable = buffer.getMemorySegment().wrap(0, buffer.getSize()).slice();
        ByteBuffer header = ByteBuffer.allocateDirect(4);
        header.putInt(nioBufferReadable.remaining());
        header.flip();
        FileIOUtils.writeCompletely((WritableByteChannel)this.fileChannel, (ByteBuffer)header);
        FileIOUtils.writeCompletely((WritableByteChannel)this.fileChannel, (ByteBuffer)nioBufferReadable);
    }
}

