/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnectionConfiguration;
import org.apache.hadoop.hbase.client.AsyncTableBase;
import org.apache.hadoop.hbase.client.AsyncTableBuilder;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class AsyncTableBuilderBase<T extends AsyncTableBase>
implements AsyncTableBuilder<T> {
    protected TableName tableName;
    protected long operationTimeoutNs;
    protected long scanTimeoutNs;
    protected long rpcTimeoutNs;
    protected long readRpcTimeoutNs;
    protected long writeRpcTimeoutNs;
    protected long pauseNs;
    protected int maxAttempts;
    protected int startLogErrorsCnt;

    AsyncTableBuilderBase(TableName tableName, AsyncConnectionConfiguration connConf) {
        this.tableName = tableName;
        this.operationTimeoutNs = tableName.isSystemTable() ? connConf.getMetaOperationTimeoutNs() : connConf.getOperationTimeoutNs();
        this.scanTimeoutNs = connConf.getScanTimeoutNs();
        this.rpcTimeoutNs = connConf.getRpcTimeoutNs();
        this.readRpcTimeoutNs = connConf.getReadRpcTimeoutNs();
        this.writeRpcTimeoutNs = connConf.getWriteRpcTimeoutNs();
        this.pauseNs = connConf.getPauseNs();
        this.maxAttempts = ConnectionUtils.retries2Attempts(connConf.getMaxRetries());
        this.startLogErrorsCnt = connConf.getStartLogErrorsCnt();
    }

    @Override
    public AsyncTableBuilderBase<T> setOperationTimeout(long timeout, TimeUnit unit) {
        this.operationTimeoutNs = unit.toNanos(timeout);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<T> setScanTimeout(long timeout, TimeUnit unit) {
        this.scanTimeoutNs = unit.toNanos(timeout);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<T> setRpcTimeout(long timeout, TimeUnit unit) {
        this.rpcTimeoutNs = unit.toNanos(timeout);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<T> setReadRpcTimeout(long timeout, TimeUnit unit) {
        this.readRpcTimeoutNs = unit.toNanos(timeout);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<T> setWriteRpcTimeout(long timeout, TimeUnit unit) {
        this.writeRpcTimeoutNs = unit.toNanos(timeout);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<T> setRetryPause(long pause, TimeUnit unit) {
        this.pauseNs = unit.toNanos(pause);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<T> setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }

    @Override
    public AsyncTableBuilderBase<T> setStartLogErrorsCnt(int startLogErrorsCnt) {
        this.startLogErrorsCnt = startLogErrorsCnt;
        return this;
    }
}

