/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcChannel;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.RawAsyncTable;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface AsyncAdmin {
    public CompletableFuture<Boolean> tableExists(TableName var1);

    default public CompletableFuture<List<TableDescriptor>> listTables() {
        return this.listTables(Optional.empty(), false);
    }

    public CompletableFuture<List<TableDescriptor>> listTables(Optional<Pattern> var1, boolean var2);

    default public CompletableFuture<List<TableName>> listTableNames() {
        return this.listTableNames(Optional.empty(), false);
    }

    public CompletableFuture<List<TableName>> listTableNames(Optional<Pattern> var1, boolean var2);

    public CompletableFuture<TableDescriptor> getTableDescriptor(TableName var1);

    default public CompletableFuture<Void> createTable(TableDescriptor desc) {
        return this.createTable(desc, Optional.empty());
    }

    public CompletableFuture<Void> createTable(TableDescriptor var1, byte[] var2, byte[] var3, int var4);

    public CompletableFuture<Void> createTable(TableDescriptor var1, Optional<byte[][]> var2);

    public CompletableFuture<Void> deleteTable(TableName var1);

    public CompletableFuture<Void> truncateTable(TableName var1, boolean var2);

    public CompletableFuture<Void> enableTable(TableName var1);

    public CompletableFuture<Void> disableTable(TableName var1);

    public CompletableFuture<Boolean> isTableEnabled(TableName var1);

    public CompletableFuture<Boolean> isTableDisabled(TableName var1);

    default public CompletableFuture<Boolean> isTableAvailable(TableName tableName) {
        return this.isTableAvailable(tableName, null);
    }

    public CompletableFuture<Boolean> isTableAvailable(TableName var1, byte[][] var2);

    public CompletableFuture<Void> addColumnFamily(TableName var1, ColumnFamilyDescriptor var2);

    public CompletableFuture<Void> deleteColumnFamily(TableName var1, byte[] var2);

    public CompletableFuture<Void> modifyColumnFamily(TableName var1, ColumnFamilyDescriptor var2);

    public CompletableFuture<Void> createNamespace(NamespaceDescriptor var1);

    public CompletableFuture<Void> modifyNamespace(NamespaceDescriptor var1);

    public CompletableFuture<Void> deleteNamespace(String var1);

    public CompletableFuture<NamespaceDescriptor> getNamespaceDescriptor(String var1);

    public CompletableFuture<List<NamespaceDescriptor>> listNamespaceDescriptors();

    public CompletableFuture<List<RegionInfo>> getOnlineRegions(ServerName var1);

    public CompletableFuture<List<RegionInfo>> getTableRegions(TableName var1);

    public CompletableFuture<Void> flush(TableName var1);

    public CompletableFuture<Void> flushRegion(byte[] var1);

    default public CompletableFuture<Void> compact(TableName tableName) {
        return this.compact(tableName, Optional.empty());
    }

    public CompletableFuture<Void> compact(TableName var1, Optional<byte[]> var2);

    default public CompletableFuture<Void> compactRegion(byte[] regionName) {
        return this.compactRegion(regionName, Optional.empty());
    }

    public CompletableFuture<Void> compactRegion(byte[] var1, Optional<byte[]> var2);

    default public CompletableFuture<Void> majorCompact(TableName tableName) {
        return this.majorCompact(tableName, Optional.empty());
    }

    public CompletableFuture<Void> majorCompact(TableName var1, Optional<byte[]> var2);

    default public CompletableFuture<Void> majorCompactRegion(byte[] regionName) {
        return this.majorCompactRegion(regionName, Optional.empty());
    }

    public CompletableFuture<Void> majorCompactRegion(byte[] var1, Optional<byte[]> var2);

    public CompletableFuture<Void> compactRegionServer(ServerName var1);

    public CompletableFuture<Void> majorCompactRegionServer(ServerName var1);

    public CompletableFuture<Boolean> setMergeOn(boolean var1);

    public CompletableFuture<Boolean> isMergeOn();

    public CompletableFuture<Boolean> setSplitOn(boolean var1);

    public CompletableFuture<Boolean> isSplitOn();

    public CompletableFuture<Void> mergeRegions(byte[] var1, byte[] var2, boolean var3);

    public CompletableFuture<Void> split(TableName var1);

    default public CompletableFuture<Void> splitRegion(byte[] regionName) {
        return this.splitRegion(regionName, Optional.empty());
    }

    public CompletableFuture<Void> split(TableName var1, byte[] var2);

    public CompletableFuture<Void> splitRegion(byte[] var1, Optional<byte[]> var2);

    public CompletableFuture<Void> assign(byte[] var1);

    public CompletableFuture<Void> unassign(byte[] var1, boolean var2);

    public CompletableFuture<Void> offline(byte[] var1);

    public CompletableFuture<Void> move(byte[] var1, Optional<ServerName> var2);

    public CompletableFuture<Void> setQuota(QuotaSettings var1);

    public CompletableFuture<List<QuotaSettings>> getQuota(QuotaFilter var1);

    public CompletableFuture<Void> addReplicationPeer(String var1, ReplicationPeerConfig var2);

    public CompletableFuture<Void> removeReplicationPeer(String var1);

    public CompletableFuture<Void> enableReplicationPeer(String var1);

    public CompletableFuture<Void> disableReplicationPeer(String var1);

    public CompletableFuture<ReplicationPeerConfig> getReplicationPeerConfig(String var1);

    public CompletableFuture<Void> updateReplicationPeerConfig(String var1, ReplicationPeerConfig var2);

    public CompletableFuture<Void> appendReplicationPeerTableCFs(String var1, Map<TableName, ? extends Collection<String>> var2);

    public CompletableFuture<Void> removeReplicationPeerTableCFs(String var1, Map<TableName, ? extends Collection<String>> var2);

    default public CompletableFuture<List<ReplicationPeerDescription>> listReplicationPeers() {
        return this.listReplicationPeers(Optional.empty());
    }

    public CompletableFuture<List<ReplicationPeerDescription>> listReplicationPeers(Optional<Pattern> var1);

    public CompletableFuture<List<TableCFs>> listReplicatedTableCFs();

    default public CompletableFuture<Void> snapshot(String snapshotName, TableName tableName) {
        return this.snapshot(snapshotName, tableName, SnapshotType.FLUSH);
    }

    default public CompletableFuture<Void> snapshot(String snapshotName, TableName tableName, SnapshotType type) {
        return this.snapshot(new SnapshotDescription(snapshotName, tableName, type));
    }

    public CompletableFuture<Void> snapshot(SnapshotDescription var1);

    public CompletableFuture<Boolean> isSnapshotFinished(SnapshotDescription var1);

    public CompletableFuture<Void> restoreSnapshot(String var1);

    public CompletableFuture<Void> restoreSnapshot(String var1, boolean var2);

    public CompletableFuture<Void> cloneSnapshot(String var1, TableName var2);

    default public CompletableFuture<List<SnapshotDescription>> listSnapshots() {
        return this.listSnapshots(Optional.empty());
    }

    public CompletableFuture<List<SnapshotDescription>> listSnapshots(Optional<Pattern> var1);

    public CompletableFuture<List<SnapshotDescription>> listTableSnapshots(Pattern var1, Pattern var2);

    public CompletableFuture<Void> deleteSnapshot(String var1);

    default public CompletableFuture<Void> deleteSnapshots(Pattern pattern) {
        return this.deleteTableSnapshots(null, pattern);
    }

    public CompletableFuture<Void> deleteTableSnapshots(Pattern var1, Pattern var2);

    public CompletableFuture<Void> execProcedure(String var1, String var2, Map<String, String> var3);

    public CompletableFuture<byte[]> execProcedureWithRet(String var1, String var2, Map<String, String> var3);

    public CompletableFuture<Boolean> isProcedureFinished(String var1, String var2, Map<String, String> var3);

    public CompletableFuture<Boolean> abortProcedure(long var1, boolean var3);

    public CompletableFuture<String> getProcedures();

    public CompletableFuture<String> getLocks();

    public CompletableFuture<Void> decommissionRegionServers(List<ServerName> var1, boolean var2);

    public CompletableFuture<List<ServerName>> listDecommissionedRegionServers();

    public CompletableFuture<Void> recommissionRegionServer(ServerName var1, List<byte[]> var2);

    public CompletableFuture<ClusterStatus> getClusterStatus();

    public CompletableFuture<ClusterStatus> getClusterStatus(EnumSet<ClusterStatus.Option> var1);

    default public CompletableFuture<ServerName> getMaster() {
        return this.getClusterStatus(EnumSet.of(ClusterStatus.Option.MASTER)).thenApply(ClusterStatus::getMaster);
    }

    default public CompletableFuture<Collection<ServerName>> getBackupMasters() {
        return this.getClusterStatus(EnumSet.of(ClusterStatus.Option.BACKUP_MASTERS)).thenApply(ClusterStatus::getBackupMasters);
    }

    default public CompletableFuture<Collection<ServerName>> getRegionServers() {
        return this.getClusterStatus(EnumSet.of(ClusterStatus.Option.LIVE_SERVERS)).thenApply(ClusterStatus::getServers);
    }

    default public CompletableFuture<Integer> getMasterInfoPort() {
        return this.getClusterStatus(EnumSet.of(ClusterStatus.Option.MASTER_INFO_PORT)).thenApply(ClusterStatus::getMasterInfoPort);
    }

    default public CompletableFuture<List<RegionLoad>> getRegionLoads(ServerName serverName) {
        return this.getRegionLoads(serverName, Optional.empty());
    }

    public CompletableFuture<Void> shutdown();

    public CompletableFuture<Void> stopMaster();

    public CompletableFuture<Void> stopRegionServer(ServerName var1);

    public CompletableFuture<Void> updateConfiguration(ServerName var1);

    public CompletableFuture<Void> updateConfiguration();

    public CompletableFuture<Void> rollWALWriter(ServerName var1);

    public CompletableFuture<Void> clearCompactionQueues(ServerName var1, Set<String> var2);

    public CompletableFuture<List<RegionLoad>> getRegionLoads(ServerName var1, Optional<TableName> var2);

    public CompletableFuture<Boolean> isMasterInMaintenanceMode();

    public CompletableFuture<CompactionState> getCompactionState(TableName var1);

    public CompletableFuture<CompactionState> getCompactionStateForRegion(byte[] var1);

    public CompletableFuture<Optional<Long>> getLastMajorCompactionTimestamp(TableName var1);

    public CompletableFuture<Optional<Long>> getLastMajorCompactionTimestampForRegion(byte[] var1);

    public CompletableFuture<List<SecurityCapability>> getSecurityCapabilities();

    public CompletableFuture<Boolean> setBalancerOn(boolean var1);

    default public CompletableFuture<Boolean> balance() {
        return this.balance(false);
    }

    public CompletableFuture<Boolean> balance(boolean var1);

    public CompletableFuture<Boolean> isBalancerOn();

    public CompletableFuture<Boolean> setNormalizerOn(boolean var1);

    public CompletableFuture<Boolean> isNormalizerOn();

    public CompletableFuture<Boolean> normalize();

    public CompletableFuture<Boolean> setCleanerChoreOn(boolean var1);

    public CompletableFuture<Boolean> isCleanerChoreOn();

    public CompletableFuture<Boolean> runCleanerChore();

    public CompletableFuture<Boolean> setCatalogJanitorOn(boolean var1);

    public CompletableFuture<Boolean> isCatalogJanitorOn();

    public CompletableFuture<Integer> runCatalogJanitor();

    public <S, R> CompletableFuture<R> coprocessorService(Function<RpcChannel, S> var1, RawAsyncTable.CoprocessorCallable<S, R> var2);

    public <S, R> CompletableFuture<R> coprocessorService(Function<RpcChannel, S> var1, RawAsyncTable.CoprocessorCallable<S, R> var2, ServerName var3);

    public CompletableFuture<List<ServerName>> listDeadServers();

    public CompletableFuture<List<ServerName>> clearDeadServers(List<ServerName> var1);
}

