/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.CloneableStream;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.BufferedByteHolderInputStream;
import org.apache.derby.impl.store.raw.data.ByteHolder;

public class OverflowInputStream
extends BufferedByteHolderInputStream
implements Resetable,
CloneableStream {
    protected BaseContainerHandle owner;
    protected long overflowPage;
    protected int overflowId;
    protected long firstOverflowPage;
    protected int firstOverflowId;
    protected RecordHandle recordToLock;
    private boolean initialized = false;

    public OverflowInputStream(ByteHolder byteHolder, BaseContainerHandle baseContainerHandle, long l, int n, RecordHandle recordHandle) {
        super(byteHolder);
        this.owner = baseContainerHandle;
        this.overflowPage = l;
        this.overflowId = n;
        this.firstOverflowPage = l;
        this.firstOverflowId = n;
        this.recordToLock = recordHandle;
    }

    public void fillByteHolder() throws IOException {
        if (this.bh.available() == 0 && this.overflowPage != -1L) {
            this.bh.clear();
            try {
                BasePage basePage = (BasePage)this.owner.getPage(this.overflowPage);
                if (basePage == null) {
                    throw new EOFException(MessageService.getTextMessage("D015"));
                }
                basePage.restorePortionLongColumn(this);
                basePage.unlatch();
                basePage = null;
            }
            catch (StandardException standardException) {
                IOException iOException = new IOException(standardException.toString());
                iOException.initCause(standardException);
                throw iOException;
            }
            this.bh.startReading();
        }
    }

    public void setOverflowPage(long l) {
        this.overflowPage = l;
    }

    public void setOverflowId(int n) {
        this.overflowId = n;
    }

    public long getOverflowPage() {
        return this.overflowPage;
    }

    public int getOverflowId() {
        return this.overflowId;
    }

    public void initStream() throws StandardException {
        if (this.initialized) {
            return;
        }
        if (this.owner.getTransaction() == null) {
            throw StandardException.newException("40XD0");
        }
        LockingPolicy lockingPolicy = this.owner.getTransaction().newLockingPolicy(1, 2, true);
        this.owner = (BaseContainerHandle)this.owner.getTransaction().openContainer(this.owner.getId(), lockingPolicy, this.owner.getMode());
        this.owner.getLockingPolicy().lockRecordForRead(this.owner.getTransaction(), this.owner, this.recordToLock, true, false);
        this.initialized = true;
    }

    public void resetStream() throws IOException, StandardException {
        this.owner.checkOpen();
        this.overflowPage = this.firstOverflowPage;
        this.overflowId = this.firstOverflowId;
        this.bh.clear();
        this.bh.startReading();
    }

    public void closeStream() {
        this.owner.close();
        this.initialized = false;
    }

    public InputStream cloneStream() {
        OverflowInputStream overflowInputStream = new OverflowInputStream(this.bh.cloneEmpty(), this.owner, this.firstOverflowPage, this.firstOverflowId, this.recordToLock);
        return overflowInputStream;
    }
}

