/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authorization.endpoint;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.basic.authorization.BasicRoleBasedAuthorizer;
import org.apache.druid.security.basic.authorization.db.cache.BasicAuthorizerCacheManager;
import org.apache.druid.security.basic.authorization.endpoint.BasicAuthorizerResourceHandler;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerGroupMapping;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ResourceAction;

public class DefaultBasicAuthorizerResourceHandler
implements BasicAuthorizerResourceHandler {
    private static final Logger log = new Logger(DefaultBasicAuthorizerResourceHandler.class);
    private static final Response NOT_FOUND_RESPONSE = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    private static final String UNKNOWN_AUTHORIZER_MSG_FORMAT = "Received update for unknown authorizer[%s]";
    private final BasicAuthorizerCacheManager cacheManager;
    private final Map<String, BasicRoleBasedAuthorizer> authorizerMap;

    @Inject
    public DefaultBasicAuthorizerResourceHandler(BasicAuthorizerCacheManager cacheManager, AuthorizerMapper authorizerMapper) {
        this.cacheManager = cacheManager;
        this.authorizerMap = new HashMap<String, BasicRoleBasedAuthorizer>();
        for (Map.Entry authorizerEntry : authorizerMapper.getAuthorizerMap().entrySet()) {
            String authorizerName = (String)authorizerEntry.getKey();
            Authorizer authorizer = (Authorizer)authorizerEntry.getValue();
            if (!(authorizer instanceof BasicRoleBasedAuthorizer)) continue;
            this.authorizerMap.put(authorizerName, (BasicRoleBasedAuthorizer)authorizer);
        }
    }

    @Override
    public Response getAllUsers(String authorizerName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response getAllGroupMappings(String authorizerName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response getUser(String authorizerName, String userName, boolean isFull, boolean simplifyPermissions) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response getGroupMapping(String authorizerName, String groupMappingName, boolean isFull) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response createUser(String authorizerName, String userName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response createGroupMapping(String authorizerName, BasicAuthorizerGroupMapping groupMapping) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response deleteUser(String authorizerName, String userName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response deleteGroupMapping(String authorizerName, String groupMappingName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response getAllRoles(String authorizerName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response getRole(String authorizerName, String roleName, boolean isFull, boolean simplifyPermissions) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response createRole(String authorizerName, String roleName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response deleteRole(String authorizerName, String roleName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response assignRoleToUser(String authorizerName, String userName, String roleName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response assignRoleToGroupMapping(String authorizerName, String groupMappingName, String roleName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response unassignRoleFromUser(String authorizerName, String userName, String roleName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response unassignRoleFromGroupMapping(String authorizerName, String groupMappingName, String roleName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response setRolePermissions(String authorizerName, String roleName, List<ResourceAction> permissions) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response getRolePermissions(String authorizerName, String roleName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response getCachedUserMaps(String authorizerName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response getCachedGroupMappingMaps(String authorizerName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response refreshAll() {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response authorizerUserUpdateListener(String authorizerName, byte[] serializedUserAndRoleMap) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            log.error(UNKNOWN_AUTHORIZER_MSG_FORMAT, new Object[]{authorizerName});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)UNKNOWN_AUTHORIZER_MSG_FORMAT, (Object[])new Object[]{authorizerName}))).build();
        }
        this.cacheManager.handleAuthorizerUserUpdate(authorizerName, serializedUserAndRoleMap);
        return Response.ok().build();
    }

    @Override
    public Response authorizerGroupMappingUpdateListener(String authorizerName, byte[] serializedGroupMappingAndRoleMap) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            log.error(UNKNOWN_AUTHORIZER_MSG_FORMAT, new Object[]{authorizerName});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)UNKNOWN_AUTHORIZER_MSG_FORMAT, (Object[])new Object[]{authorizerName}))).build();
        }
        this.cacheManager.handleAuthorizerGroupMappingUpdate(authorizerName, serializedGroupMappingAndRoleMap);
        return Response.ok().build();
    }

    @Override
    public Response getLoadStatus() {
        HashMap loadStatus = new HashMap();
        this.authorizerMap.forEach((authorizerName, authorizer) -> loadStatus.put(authorizerName, this.cacheManager.getUserMap((String)authorizerName) != null && this.cacheManager.getRoleMap((String)authorizerName) != null && this.cacheManager.getGroupMappingMap((String)authorizerName) != null && this.cacheManager.getGroupMappingRoleMap((String)authorizerName) != null));
        return Response.ok(loadStatus).build();
    }
}

