/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.stage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.druid.msq.input.stage.ReadablePartition;
import org.apache.druid.msq.input.stage.ReadablePartitions;

public class CombinedReadablePartitions
implements ReadablePartitions {
    private final List<ReadablePartitions> readablePartitions;

    @JsonCreator
    public CombinedReadablePartitions(@JsonProperty(value="children") List<ReadablePartitions> readablePartitions) {
        this.readablePartitions = readablePartitions;
    }

    @Override
    public List<ReadablePartitions> split(int maxNumSplits) {
        List splits = this.readablePartitions.stream().map(rp -> rp.split(maxNumSplits)).collect(Collectors.toList());
        ArrayList<ReadablePartitions> retVal = new ArrayList<ReadablePartitions>();
        for (int i = 0; i < maxNumSplits; ++i) {
            ArrayList<ReadablePartitions> combo = new ArrayList<ReadablePartitions>();
            for (int j = 0; j < this.readablePartitions.size(); ++j) {
                if (((List)splits.get(j)).size() <= i) continue;
                combo.add((ReadablePartitions)((List)splits.get(j)).get(i));
            }
            if (combo.size() == 1) {
                retVal.add((ReadablePartitions)Iterables.getOnlyElement(combo));
                continue;
            }
            retVal.add(new CombinedReadablePartitions(combo));
        }
        return retVal;
    }

    @Override
    public Iterator<ReadablePartition> iterator() {
        return Iterables.concat(this.readablePartitions).iterator();
    }

    @JsonProperty(value="children")
    List<ReadablePartitions> getReadablePartitions() {
        return this.readablePartitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CombinedReadablePartitions that = (CombinedReadablePartitions)o;
        return Objects.equals(this.readablePartitions, that.readablePartitions);
    }

    public int hashCode() {
        return Objects.hash(this.readablePartitions);
    }

    public String toString() {
        return "CombinedReadablePartitions{readablePartitions=" + String.valueOf(this.readablePartitions) + "}";
    }
}

