/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.inputsource.hdfs;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.data.input.AbstractInputSource;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputFileAttribute;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.data.input.impl.systemfield.SystemField;
import org.apache.druid.data.input.impl.systemfield.SystemFieldDecoratorFactory;
import org.apache.druid.data.input.impl.systemfield.SystemFieldInputSource;
import org.apache.druid.data.input.impl.systemfield.SystemFields;
import org.apache.druid.guice.Hdfs;
import org.apache.druid.inputsource.hdfs.HdfsInputEntity;
import org.apache.druid.inputsource.hdfs.HdfsInputSourceConfig;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.utils.Streams;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class HdfsInputSource
extends AbstractInputSource
implements SplittableInputSource<List<Path>>,
SystemFieldInputSource {
    static final String TYPE_KEY = "hdfs";
    private static final String PROP_PATHS = "paths";
    private final List<String> inputPaths;
    private final SystemFields systemFields;
    private final Configuration configuration;
    private final HdfsInputSourceConfig inputSourceConfig;
    @Nullable
    private List<Path> cachedPaths = null;

    @JsonCreator
    public HdfsInputSource(@JsonProperty(value="paths") Object inputPaths, @JsonProperty(value="systemFields") SystemFields systemFields, @JacksonInject @Hdfs Configuration configuration, @JacksonInject HdfsInputSourceConfig inputSourceConfig) {
        this.inputPaths = HdfsInputSource.coerceInputPathsToList(inputPaths, PROP_PATHS);
        this.systemFields = systemFields == null ? SystemFields.none() : systemFields;
        this.configuration = configuration;
        this.inputSourceConfig = inputSourceConfig;
        this.inputPaths.forEach(p -> HdfsInputSource.verifyProtocol(configuration, inputSourceConfig, p));
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getTypes() {
        return Collections.singleton(TYPE_KEY);
    }

    public static List<String> coerceInputPathsToList(Object inputPaths, String propertyName) {
        if (inputPaths instanceof String) {
            return Collections.singletonList((String)inputPaths);
        }
        if (inputPaths instanceof List && ((List)inputPaths).stream().allMatch(x -> x instanceof String)) {
            return ((List)inputPaths).stream().map(x -> (String)x).collect(Collectors.toList());
        }
        throw new IAE("'%s' must be a string or an array of strings", new Object[]{propertyName});
    }

    public static void verifyProtocol(Configuration conf, HdfsInputSourceConfig config, String pathString) {
        Path path = new Path(pathString);
        try {
            HdfsInputSource.throwIfInvalidProtocol(config, path.getFileSystem(conf).getScheme());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void throwIfInvalidProtocol(HdfsInputSourceConfig config, String scheme) {
        if (!config.getAllowedProtocols().contains(StringUtils.toLowerCase((String)scheme))) {
            throw new IAE("Only %s protocols are allowed", new Object[]{config.getAllowedProtocols()});
        }
    }

    public static Collection<Path> getPaths(List<String> inputPaths, Configuration configuration) throws IOException {
        if (inputPaths.isEmpty()) {
            return Collections.emptySet();
        }
        Job job = Job.getInstance((Configuration)configuration);
        for (String inputPath : inputPaths) {
            FileInputFormat.addInputPaths((Job)job, (String)inputPath);
        }
        return new HdfsFileInputFormat().getSplits((JobContext)job).stream().filter(split -> ((FileSplit)split).getLength() > 0L).map(split -> ((FileSplit)split).getPath()).collect(Collectors.toSet());
    }

    @JsonProperty(value="paths")
    @VisibleForTesting
    List<String> getInputPaths() {
        return this.inputPaths;
    }

    public Set<SystemField> getConfiguredSystemFields() {
        return this.systemFields.getFields();
    }

    public Object getSystemFieldValue(InputEntity entity, SystemField field) {
        HdfsInputEntity hdfsEntity = (HdfsInputEntity)entity;
        switch (field) {
            case URI: {
                return hdfsEntity.getUri().toString();
            }
            case PATH: {
                return hdfsEntity.getPath();
            }
        }
        return null;
    }

    protected InputSourceReader formattableReader(InputRowSchema inputRowSchema, InputFormat inputFormat, @Nullable File temporaryDirectory) {
        try {
            this.cachePathsIfNeeded();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new InputEntityIteratingReader(inputRowSchema, inputFormat, CloseableIterators.withEmptyBaggage((Iterator)Iterators.transform(this.cachedPaths.iterator(), path -> new HdfsInputEntity(this.configuration, (Path)path))), SystemFieldDecoratorFactory.fromInputSource((SystemFieldInputSource)this), temporaryDirectory);
    }

    public Stream<InputSplit<List<Path>>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) throws IOException {
        this.cachePathsIfNeeded();
        Iterator splitIterator = this.getSplitHintSpecOrDefault(splitHintSpec).split(this.cachedPaths.iterator(), path -> {
            try {
                long size = path.getFileSystem(this.configuration).getFileStatus(path).getLen();
                return new InputFileAttribute(size);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return Streams.sequentialStreamFrom((Iterator)splitIterator).map(InputSplit::new);
    }

    public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) throws IOException {
        this.cachePathsIfNeeded();
        return this.cachedPaths.size();
    }

    public SplittableInputSource<List<Path>> withSplit(InputSplit<List<Path>> split) {
        List paths = ((List)split.get()).stream().map(path -> path.toString()).collect(Collectors.toList());
        return new HdfsInputSource(paths, this.systemFields, this.configuration, this.inputSourceConfig);
    }

    public boolean needsFormat() {
        return true;
    }

    private void cachePathsIfNeeded() throws IOException {
        if (this.cachedPaths == null) {
            this.cachedPaths = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(HdfsInputSource.getPaths(this.inputPaths, this.configuration), (Object)PROP_PATHS)));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        HdfsInputSource that = (HdfsInputSource)((Object)o);
        return Objects.equals(this.inputPaths, that.inputPaths) && Objects.equals(this.systemFields, that.systemFields) && Objects.equals(this.configuration, that.configuration) && Objects.equals(this.inputSourceConfig, that.inputSourceConfig);
    }

    public int hashCode() {
        return Objects.hash(this.inputPaths, this.systemFields, this.configuration, this.inputSourceConfig);
    }

    public String toString() {
        return "HdfsInputSource{inputPaths=" + String.valueOf(this.inputPaths) + (String)(this.systemFields.getFields().isEmpty() ? "" : ", systemFields=" + String.valueOf(this.systemFields)) + "}";
    }

    @VisibleForTesting
    static Builder builder() {
        return new Builder();
    }

    private static class HdfsFileInputFormat
    extends FileInputFormat<Object, Object> {
        private HdfsFileInputFormat() {
        }

        public RecordReader<Object, Object> createRecordReader(org.apache.hadoop.mapreduce.InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
            throw new UnsupportedOperationException();
        }

        protected boolean isSplitable(JobContext context, Path filename) {
            return false;
        }
    }

    static final class Builder {
        private Object paths;
        private Configuration configuration;
        private HdfsInputSourceConfig inputSourceConfig;
        private SystemFields systemFields = SystemFields.none();

        private Builder() {
        }

        Builder paths(Object paths) {
            this.paths = paths;
            return this;
        }

        Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        Builder inputSourceConfig(HdfsInputSourceConfig inputSourceConfig) {
            this.inputSourceConfig = inputSourceConfig;
            return this;
        }

        Builder systemFields(SystemField ... systemFields) {
            this.systemFields = new SystemFields(EnumSet.copyOf(Arrays.asList(systemFields)));
            return this;
        }

        HdfsInputSource build() {
            return new HdfsInputSource(Preconditions.checkNotNull((Object)this.paths, (Object)HdfsInputSource.PROP_PATHS), this.systemFields, (Configuration)Preconditions.checkNotNull((Object)this.configuration, (Object)"configuration"), (HdfsInputSourceConfig)Preconditions.checkNotNull((Object)this.inputSourceConfig, (Object)"inputSourceConfig"));
        }
    }
}

