/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kafka.supervisor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexing.seekablestream.extension.KafkaConfigOverrides;
import org.apache.druid.indexing.seekablestream.supervisor.IdleConfig;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorIOConfig;
import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.AutoScalerConfig;
import org.apache.druid.java.util.common.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Period;

public class KafkaSupervisorIOConfig
extends SeekableStreamSupervisorIOConfig {
    public static final String DRUID_DYNAMIC_CONFIG_PROVIDER_KEY = "druid.dynamic.config.provider";
    public static final String BOOTSTRAP_SERVERS_KEY = "bootstrap.servers";
    public static final String TRUST_STORE_PASSWORD_KEY = "ssl.truststore.password";
    public static final String KEY_STORE_PASSWORD_KEY = "ssl.keystore.password";
    public static final String KEY_PASSWORD_KEY = "ssl.key.password";
    public static final long DEFAULT_POLL_TIMEOUT_MILLIS = 100L;
    public static final boolean DEFAULT_IS_MULTI_TOPIC = false;
    private final Map<String, Object> consumerProperties;
    private final long pollTimeout;
    private final KafkaConfigOverrides configOverrides;
    private final String topic;
    private final String topicPattern;

    @JsonCreator
    public KafkaSupervisorIOConfig(@JsonProperty(value="topic") String topic, @JsonProperty(value="topicPattern") String topicPattern, @JsonProperty(value="inputFormat") InputFormat inputFormat, @JsonProperty(value="replicas") Integer replicas, @JsonProperty(value="taskCount") Integer taskCount, @JsonProperty(value="taskDuration") Period taskDuration, @JsonProperty(value="consumerProperties") Map<String, Object> consumerProperties, @Nullable @JsonProperty(value="autoScalerConfig") AutoScalerConfig autoScalerConfig, @JsonProperty(value="pollTimeout") Long pollTimeout, @JsonProperty(value="startDelay") Period startDelay, @JsonProperty(value="period") Period period, @JsonProperty(value="useEarliestOffset") Boolean useEarliestOffset, @JsonProperty(value="completionTimeout") Period completionTimeout, @JsonProperty(value="lateMessageRejectionPeriod") Period lateMessageRejectionPeriod, @JsonProperty(value="earlyMessageRejectionPeriod") Period earlyMessageRejectionPeriod, @JsonProperty(value="lateMessageRejectionStartDateTime") DateTime lateMessageRejectionStartDateTime, @JsonProperty(value="configOverrides") KafkaConfigOverrides configOverrides, @JsonProperty(value="idleConfig") IdleConfig idleConfig, @JsonProperty(value="stopTaskCount") Integer stopTaskCount) {
        super(KafkaSupervisorIOConfig.checkTopicArguments(topic, topicPattern), inputFormat, replicas, taskCount, taskDuration, startDelay, period, useEarliestOffset, completionTimeout, lateMessageRejectionPeriod, earlyMessageRejectionPeriod, autoScalerConfig, lateMessageRejectionStartDateTime, idleConfig, stopTaskCount);
        this.consumerProperties = (Map)Preconditions.checkNotNull(consumerProperties, (Object)"consumerProperties");
        Preconditions.checkNotNull((Object)consumerProperties.get(BOOTSTRAP_SERVERS_KEY), (Object)StringUtils.format((String)"consumerProperties must contain entry for [%s]", (Object[])new Object[]{BOOTSTRAP_SERVERS_KEY}));
        this.pollTimeout = pollTimeout != null ? pollTimeout : 100L;
        this.configOverrides = configOverrides;
        this.topic = topic;
        this.topicPattern = topicPattern;
    }

    @JsonProperty
    public String getTopic() {
        return this.topic;
    }

    @JsonProperty
    public String getTopicPattern() {
        return this.topicPattern;
    }

    @JsonProperty
    public Map<String, Object> getConsumerProperties() {
        return this.consumerProperties;
    }

    @JsonProperty
    public long getPollTimeout() {
        return this.pollTimeout;
    }

    @JsonProperty
    public boolean isUseEarliestOffset() {
        return this.isUseEarliestSequenceNumber();
    }

    @JsonProperty
    public KafkaConfigOverrides getConfigOverrides() {
        return this.configOverrides;
    }

    public boolean isMultiTopic() {
        return this.topicPattern != null;
    }

    public String toString() {
        return "KafkaSupervisorIOConfig{topic='" + this.getTopic() + "'topicPattern='" + this.getTopicPattern() + "', replicas=" + this.getReplicas() + ", taskCount=" + this.getTaskCount() + ", taskDuration=" + this.getTaskDuration() + ", consumerProperties=" + this.consumerProperties + ", autoScalerConfig=" + this.getAutoScalerConfig() + ", pollTimeout=" + this.pollTimeout + ", startDelay=" + this.getStartDelay() + ", period=" + this.getPeriod() + ", useEarliestOffset=" + this.isUseEarliestOffset() + ", completionTimeout=" + this.getCompletionTimeout() + ", earlyMessageRejectionPeriod=" + this.getEarlyMessageRejectionPeriod() + ", lateMessageRejectionPeriod=" + this.getLateMessageRejectionPeriod() + ", lateMessageRejectionStartDateTime=" + this.getLateMessageRejectionStartDateTime() + ", configOverrides=" + this.getConfigOverrides() + ", idleConfig=" + this.getIdleConfig() + ", stopTaskCount=" + this.getStopTaskCount() + "}";
    }

    private static String checkTopicArguments(String topic, String topicPattern) {
        if (topic == null && topicPattern == null) {
            throw InvalidInput.exception((String)"Either topic or topicPattern must be specified", (Object[])new Object[0]);
        }
        if (topic != null && topicPattern != null) {
            throw InvalidInput.exception((String)"Only one of topic [%s] or topicPattern [%s] must be specified", (Object[])new Object[]{topic, topicPattern});
        }
        return topic != null ? topic : topicPattern;
    }
}

