/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.annotations.EverythingIsNonnullByDefault;
import org.apache.druid.msq.util.PassthroughAggregator;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnType;

@JsonTypeName(value="passthrough")
@EverythingIsNonnullByDefault
public class PassthroughAggregatorFactory
extends AggregatorFactory {
    private static final int ESTIMATED_HEAP_FOOTPRINT = 800;
    static final String TYPE = "passthrough";
    private final String columnName;
    private final String complexTypeName;

    @JsonCreator
    public PassthroughAggregatorFactory(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="complexTypeName") String complexTypeName) {
        this.columnName = columnName;
        this.complexTypeName = complexTypeName;
    }

    @JsonProperty(value="columnName")
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty(value="complexTypeName")
    public String getComplexName() {
        return this.complexTypeName;
    }

    public byte[] getCacheKey() {
        throw new UnsupportedOperationException();
    }

    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new PassthroughAggregator((BaseObjectColumnValueSelector<?>)metricFactory.makeColumnValueSelector(this.columnName));
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        throw new UnsupportedOperationException();
    }

    public Comparator getComparator() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        throw new UnsupportedOperationException();
    }

    public AggregatorFactory getCombiningFactory() {
        return this;
    }

    public Object deserialize(Object object) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.columnName;
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.columnName);
    }

    public int guessAggregatorHeapFootprint(long rows) {
        return 800;
    }

    public AggregatorFactory withName(String newName) {
        return new PassthroughAggregatorFactory(newName, this.complexTypeName);
    }

    public int getMaxIntermediateSize() {
        throw new UnsupportedOperationException();
    }

    public ColumnType getIntermediateType() {
        return ColumnType.ofComplex((String)this.complexTypeName);
    }

    public ColumnType getResultType() {
        return ColumnType.ofComplex((String)this.complexTypeName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PassthroughAggregatorFactory that = (PassthroughAggregatorFactory)((Object)o);
        return this.columnName.equals(that.columnName) && this.complexTypeName.equals(that.complexTypeName);
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.complexTypeName);
    }

    public String toString() {
        return "PassthroughAggregatorFactory{columnName='" + this.columnName + "', complexTypeName='" + this.complexTypeName + "'}";
    }
}

