/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.msq.exec.MSQTasks;
import org.apache.druid.msq.indexing.MSQControllerTask;
import org.apache.druid.msq.indexing.MSQSpec;
import org.apache.druid.msq.indexing.MSQTuningConfig;
import org.apache.druid.msq.indexing.destination.DataSourceMSQDestination;
import org.apache.druid.msq.indexing.destination.DurableStorageMSQDestination;
import org.apache.druid.msq.indexing.destination.ExportMSQDestination;
import org.apache.druid.msq.indexing.destination.MSQDestination;
import org.apache.druid.msq.indexing.destination.MSQSelectDestination;
import org.apache.druid.msq.indexing.destination.MSQTerminalStageSpecFactory;
import org.apache.druid.msq.indexing.destination.TaskReportMSQDestination;
import org.apache.druid.msq.sql.MSQMode;
import org.apache.druid.msq.util.MSQTaskQueryMakerUtils;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.lookup.cache.LookupLoadingSpec;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.calcite.planner.ColumnMappings;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.QueryUtils;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.Grouping;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.run.SqlResults;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.apache.druid.sql.destination.ExportDestination;
import org.apache.druid.sql.destination.IngestDestination;
import org.apache.druid.sql.destination.TableDestination;
import org.apache.druid.sql.hook.DruidHook;
import org.apache.druid.sql.http.ResultFormat;
import org.joda.time.Interval;

public class MSQTaskQueryMaker
implements QueryMaker {
    public static final String USER_KEY = "__user";
    private static final Granularity DEFAULT_SEGMENT_GRANULARITY = Granularities.ALL;
    private final IngestDestination targetDataSource;
    private final OverlordClient overlordClient;
    private final PlannerContext plannerContext;
    private final ObjectMapper jsonMapper;
    private final List<Map.Entry<Integer, String>> fieldMapping;
    private final MSQTerminalStageSpecFactory terminalStageSpecFactory;

    MSQTaskQueryMaker(@Nullable IngestDestination targetDataSource, OverlordClient overlordClient, PlannerContext plannerContext, ObjectMapper jsonMapper, List<Map.Entry<Integer, String>> fieldMapping, MSQTerminalStageSpecFactory terminalStageSpecFactory) {
        this.targetDataSource = targetDataSource;
        this.overlordClient = (OverlordClient)Preconditions.checkNotNull((Object)overlordClient, (Object)"indexingServiceClient");
        this.plannerContext = (PlannerContext)Preconditions.checkNotNull((Object)plannerContext, (Object)"plannerContext");
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"jsonMapper");
        this.fieldMapping = (List)Preconditions.checkNotNull(fieldMapping, (Object)"fieldMapping");
        this.terminalStageSpecFactory = terminalStageSpecFactory;
    }

    public QueryResponse<Object[]> runQuery(DruidQuery druidQuery) {
        if (!this.plannerContext.getAuthorizationResult().allowAccessWithNoRestriction()) {
            throw new ForbiddenException(this.plannerContext.getAuthorizationResult().getErrorMessage());
        }
        Hook.QUERY_PLAN.run((Object)druidQuery.getQuery());
        this.plannerContext.dispatchHook(DruidHook.NATIVE_PLAN, (Object)druidQuery.getQuery());
        String taskId = MSQTasks.controllerTaskId(this.plannerContext.getSqlQueryId());
        HashMap<String, Object> taskContext = new HashMap<String, Object>();
        taskContext.put("lookupLoadingMode", this.plannerContext.getLookupLoadingSpec().getMode());
        if (this.plannerContext.getLookupLoadingSpec().getMode() == LookupLoadingSpec.Mode.ONLY_REQUIRED) {
            taskContext.put("lookupsToLoad", this.plannerContext.getLookupLoadingSpec().getLookupsToLoad());
        }
        List<Pair<SqlTypeName, ColumnType>> typeList = MSQTaskQueryMaker.getTypes(druidQuery, this.fieldMapping, this.plannerContext);
        MSQControllerTask controllerTask = new MSQControllerTask(taskId, MSQTaskQueryMaker.makeQuerySpec(this.targetDataSource, druidQuery, this.fieldMapping, this.plannerContext, this.terminalStageSpecFactory), MSQTaskQueryMakerUtils.maskSensitiveJsonKeys(this.plannerContext.getSql()), this.plannerContext.queryContextMap(), SqlResults.Context.fromPlannerContext((PlannerContext)this.plannerContext), typeList.stream().map(typeInfo -> (SqlTypeName)typeInfo.lhs).collect(Collectors.toList()), typeList.stream().map(typeInfo -> (ColumnType)typeInfo.rhs).collect(Collectors.toList()), taskContext);
        FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.runTask(taskId, (Object)controllerTask), (boolean)true);
        return QueryResponse.withEmptyContext((Sequence)Sequences.simple(Collections.singletonList(new Object[]{taskId})));
    }

    public static MSQSpec makeQuerySpec(@Nullable IngestDestination targetDataSource, DruidQuery druidQuery, List<Map.Entry<Integer, String>> fieldMapping, PlannerContext plannerContext, MSQTerminalStageSpecFactory terminalStageSpecFactory) {
        MSQDestination destination;
        QueryContext sqlQueryContext = plannerContext.queryContext();
        HashMap<String, Object> nativeQueryContext = new HashMap<String, Object>(sqlQueryContext.asMap());
        nativeQueryContext.put(USER_KEY, plannerContext.getAuthenticationResult().getIdentity());
        String msqMode = MultiStageQueryContext.getMSQMode(sqlQueryContext);
        if (msqMode != null) {
            MSQMode.populateDefaultQueryContext(msqMode, nativeQueryContext);
        }
        Object segmentGranularity = Optional.ofNullable(plannerContext.queryContext().get("sqlInsertSegmentGranularity")).orElseGet(() -> {
            try {
                return plannerContext.getJsonMapper().writeValueAsString((Object)DEFAULT_SEGMENT_GRANULARITY);
            }
            catch (JsonProcessingException e) {
                throw DruidException.defensive().build((Throwable)e, "Unable to serialize DEFAULT_SEGMENT_GRANULARITY", new Object[0]);
            }
        });
        int maxNumTasks = MultiStageQueryContext.getMaxNumTasks(sqlQueryContext);
        if (maxNumTasks < 2) {
            throw InvalidInput.exception((String)"MSQ context maxNumTasks [%,d] cannot be less than 2, since at least 1 controller and 1 worker is necessary", (Object[])new Object[]{maxNumTasks});
        }
        int maxNumWorkers = maxNumTasks - 1;
        int rowsPerSegment = MultiStageQueryContext.getRowsPerSegment(sqlQueryContext);
        int maxRowsInMemory = MultiStageQueryContext.getRowsInMemory(sqlQueryContext);
        Integer maxNumSegments = MultiStageQueryContext.getMaxNumSegments(sqlQueryContext);
        IndexSpec indexSpec = MultiStageQueryContext.getIndexSpec(sqlQueryContext, plannerContext.getJsonMapper());
        boolean finalizeAggregations = MultiStageQueryContext.isFinalizeAggregations(sqlQueryContext);
        List replaceTimeChunks = Optional.ofNullable(sqlQueryContext.get("sqlReplaceTimeChunks")).map(s -> {
            if (s instanceof String && "all".equals(StringUtils.toLowerCase((String)((String)s)))) {
                return Intervals.ONLY_ETERNITY;
            }
            String[] parts = ((String)s).split("\\s*,\\s*");
            ArrayList<Interval> intervals = new ArrayList<Interval>();
            for (String part : parts) {
                intervals.add(Intervals.of((String)part));
            }
            return intervals;
        }).orElse(null);
        if (targetDataSource instanceof ExportDestination) {
            ExportDestination exportDestination = (ExportDestination)targetDataSource;
            ResultFormat format = ResultFormat.fromString((String)sqlQueryContext.getString("__exportFileFormat"));
            destination = new ExportMSQDestination(exportDestination.getStorageConnectorProvider(), format);
        } else if (targetDataSource instanceof TableDestination) {
            Granularity segmentGranularityObject;
            try {
                segmentGranularityObject = (Granularity)plannerContext.getJsonMapper().readValue((String)segmentGranularity, Granularity.class);
            }
            catch (Exception e) {
                throw DruidException.defensive().build((Throwable)e, "Unable to deserialize the provided segmentGranularity [%s]. This is populated internally by Druid and therefore should not occur. Please contact the developers if you are seeing this error message.", new Object[]{segmentGranularity});
            }
            List<String> segmentSortOrder = MultiStageQueryContext.getSortOrder(sqlQueryContext);
            MSQTaskQueryMakerUtils.validateContextSortOrderColumnsExist(segmentSortOrder, fieldMapping.stream().map(Map.Entry::getValue).collect(Collectors.toSet()));
            DataSourceMSQDestination dataSourceDestination = new DataSourceMSQDestination(targetDataSource.getDestinationName(), segmentGranularityObject, segmentSortOrder, replaceTimeChunks, null, terminalStageSpecFactory.createTerminalStageSpec(druidQuery, plannerContext));
            MultiStageQueryContext.validateAndGetTaskLockType(sqlQueryContext, dataSourceDestination.isReplaceTimeChunks());
            destination = dataSourceDestination;
        } else {
            MSQSelectDestination msqSelectDestination = MultiStageQueryContext.getSelectDestination(sqlQueryContext);
            if (msqSelectDestination.equals((Object)MSQSelectDestination.TASKREPORT)) {
                destination = TaskReportMSQDestination.instance();
            } else if (msqSelectDestination.equals((Object)MSQSelectDestination.DURABLESTORAGE)) {
                destination = DurableStorageMSQDestination.instance();
            } else {
                throw InvalidInput.exception((String)"Unsupported select destination [%s] provided in the query context. MSQ can currently write the select results to [%s]", (Object[])new Object[]{msqSelectDestination.getName(), Arrays.stream(MSQSelectDestination.values()).map(MSQSelectDestination::getName).collect(Collectors.joining(","))});
            }
        }
        HashMap<String, Boolean> nativeQueryContextOverrides = new HashMap<String, Boolean>();
        nativeQueryContextOverrides.put("finalize", finalizeAggregations);
        nativeQueryContextOverrides.put("windowFunctionOperatorTransformation", true);
        MSQSpec querySpec = MSQSpec.builder().query(druidQuery.getQuery().withOverriddenContext(nativeQueryContextOverrides)).columnMappings(new ColumnMappings(QueryUtils.buildColumnMappings(fieldMapping, (DruidQuery)druidQuery))).destination(destination).assignmentStrategy(MultiStageQueryContext.getAssignmentStrategy(sqlQueryContext)).tuningConfig(new MSQTuningConfig(maxNumWorkers, maxRowsInMemory, rowsPerSegment, maxNumSegments, indexSpec)).build();
        MSQTaskQueryMakerUtils.validateRealtimeReindex(querySpec);
        return querySpec.withOverriddenContext(nativeQueryContext);
    }

    public static List<Pair<SqlTypeName, ColumnType>> getTypes(DruidQuery druidQuery, List<Map.Entry<Integer, String>> fieldMapping, PlannerContext plannerContext) {
        boolean finalizeAggregations = MultiStageQueryContext.isFinalizeAggregations(plannerContext.queryContext());
        Map<String, ColumnType> aggregationIntermediateTypeMap = finalizeAggregations ? null : MSQTaskQueryMaker.buildAggregationIntermediateTypeMap(druidQuery);
        ArrayList<Pair<SqlTypeName, ColumnType>> retVal = new ArrayList<Pair<SqlTypeName, ColumnType>>();
        for (Map.Entry<Integer, String> entry : fieldMapping) {
            SqlTypeName sqlTypeName;
            String queryColumn = druidQuery.getOutputRowSignature().getColumnName(entry.getKey().intValue());
            if (!finalizeAggregations && aggregationIntermediateTypeMap.containsKey(queryColumn)) {
                ColumnType druidType = aggregationIntermediateTypeMap.get(queryColumn);
                sqlTypeName = new RowSignatures.ComplexSqlType(SqlTypeName.OTHER, druidType, true).getSqlTypeName();
            } else {
                sqlTypeName = ((RelDataTypeField)druidQuery.getOutputRowType().getFieldList().get(entry.getKey())).getType().getSqlTypeName();
            }
            ColumnType columnType = druidQuery.getOutputRowSignature().getColumnType(queryColumn).orElse(ColumnType.STRING);
            retVal.add((Pair<SqlTypeName, ColumnType>)Pair.of((Object)sqlTypeName, (Object)columnType));
        }
        return retVal;
    }

    private static Map<String, ColumnType> buildAggregationIntermediateTypeMap(DruidQuery druidQuery) {
        Grouping grouping = druidQuery.getGrouping();
        if (grouping == null) {
            return Collections.emptyMap();
        }
        HashMap<String, ColumnType> retVal = new HashMap<String, ColumnType>();
        for (AggregatorFactory aggregatorFactory : grouping.getAggregatorFactories()) {
            retVal.put(aggregatorFactory.getName(), aggregatorFactory.getIntermediateType());
        }
        return retVal;
    }
}

