/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.frame.allocation.HeapMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.ReadableConcatFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.OutputChannels;
import org.apache.druid.frame.processor.manager.ProcessorManagers;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.ReadableInputs;
import org.apache.druid.msq.kernel.FrameContext;
import org.apache.druid.msq.kernel.ProcessorsAndChannels;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.querykit.BaseFrameProcessorFactory;
import org.apache.druid.msq.querykit.common.OffsetLimitFrameProcessor;

@JsonTypeName(value="limit")
public class OffsetLimitFrameProcessorFactory
extends BaseFrameProcessorFactory {
    private final long offset;
    @Nullable
    private final Long limit;

    @JsonCreator
    public OffsetLimitFrameProcessorFactory(@JsonProperty(value="offset") long offset, @Nullable @JsonProperty(value="limit") Long limit) {
        this.offset = offset;
        this.limit = limit;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public long getOffset() {
        return this.offset;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getLimit() {
        return this.limit;
    }

    @Override
    public ProcessorsAndChannels<Object, Long> makeProcessors(StageDefinition stageDefinition, int workerNumber, List<InputSlice> inputSlices, InputSliceReader inputSliceReader, @Nullable Object extra, OutputChannelFactory outputChannelFactory, FrameContext frameContext, int maxOutstandingProcessors, CounterTracker counters, Consumer<Throwable> warningPublisher, boolean removeNullBytes) throws IOException {
        if (workerNumber > 0) {
            throw new ISE("%s must be configured with maxWorkerCount = 1", new Object[]{this.getClass().getSimpleName()});
        }
        InputSlice slice = (InputSlice)Iterables.getOnlyElement(inputSlices);
        if (inputSliceReader.numReadableInputs(slice) == 0) {
            return new ProcessorsAndChannels<Object, Long>(ProcessorManagers.none(), OutputChannels.none());
        }
        OutputChannel outputChannel = outputChannelFactory.openChannel(0);
        Supplier<FrameProcessor> workerSupplier = () -> {
            ReadableInputs readableInputs = inputSliceReader.attach(0, slice, counters, warningPublisher);
            if (!readableInputs.isChannelBased()) {
                throw new ISE("Processor inputs must be channels", new Object[0]);
            }
            return new OffsetLimitFrameProcessor((ReadableFrameChannel)ReadableConcatFrameChannel.open((Iterator)Iterators.transform(readableInputs.iterator(), ReadableInput::getChannel)), outputChannel.getWritableChannel(), readableInputs.frameReader(), stageDefinition.createFrameWriterFactory((MemoryAllocator)HeapMemoryAllocator.unlimited(), removeNullBytes), this.offset, this.limit == null ? Long.MAX_VALUE - this.offset : this.limit);
        };
        return new ProcessorsAndChannels<Object, Long>(ProcessorManagers.of(workerSupplier), OutputChannels.wrapReadOnly(Collections.singletonList(outputChannel)));
    }

    @Override
    public boolean usesProcessingBuffers() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetLimitFrameProcessorFactory that = (OffsetLimitFrameProcessorFactory)o;
        return this.offset == that.offset && Objects.equals(this.limit, that.limit);
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.limit);
    }
}

