/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.java.util.common.Unit;
import org.apache.druid.msq.exec.DataServerQueryHandler;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.table.SegmentWithDescriptor;
import org.apache.druid.msq.input.table.SegmentsInputSlice;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentReference;

public abstract class BaseLeafFrameProcessor
implements FrameProcessor<Object> {
    private final ReadableInput baseInput;
    private final ResourceHolder<WritableFrameChannel> outputChannelHolder;
    private final ResourceHolder<FrameWriterFactory> frameWriterFactoryHolder;
    private final Function<SegmentReference, SegmentReference> segmentMapFn;

    protected BaseLeafFrameProcessor(ReadableInput baseInput, Function<SegmentReference, SegmentReference> segmentMapFn, ResourceHolder<WritableFrameChannel> outputChannelHolder, ResourceHolder<FrameWriterFactory> frameWriterFactoryHolder) {
        this.baseInput = baseInput;
        this.outputChannelHolder = outputChannelHolder;
        this.frameWriterFactoryHolder = frameWriterFactoryHolder;
        this.segmentMapFn = segmentMapFn;
    }

    public List<ReadableFrameChannel> inputChannels() {
        if (this.baseInput.hasSegment() || this.baseInput.hasDataServerQuery()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.baseInput.getChannel());
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.singletonList((WritableFrameChannel)this.outputChannelHolder.get());
    }

    public ReturnOrAwait<Object> runIncrementally(IntSet readableInputs) throws IOException {
        Object retVal = this.baseInput.hasSegment() ? this.runWithSegment(this.baseInput.getSegment()) : (this.baseInput.hasDataServerQuery() ? this.runWithDataServerQuery(this.baseInput.getDataServerQuery()) : this.runWithInputChannel(this.baseInput.getChannel(), this.baseInput.getChannelFrameReader()));
        return retVal;
    }

    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), Collections.emptyList(), (Closeable[])new Closeable[]{this.outputChannelHolder, this.frameWriterFactoryHolder});
    }

    protected FrameWriterFactory getFrameWriterFactory() {
        return (FrameWriterFactory)this.frameWriterFactoryHolder.get();
    }

    protected abstract ReturnOrAwait<Unit> runWithSegment(SegmentWithDescriptor var1) throws IOException;

    protected abstract ReturnOrAwait<SegmentsInputSlice> runWithDataServerQuery(DataServerQueryHandler var1) throws IOException;

    protected abstract ReturnOrAwait<Unit> runWithInputChannel(ReadableFrameChannel var1, FrameReader var2) throws IOException;

    protected SegmentReference mapSegment(Segment segment) {
        return this.segmentMapFn.apply((SegmentReference)ReferenceCountingSegment.wrapRootGenerationSegment((Segment)segment));
    }
}

