/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel.worker;

public enum WorkerStagePhase {
    NEW{

        @Override
        public boolean canTransitionFrom(WorkerStagePhase priorPhase) {
            return false;
        }
    }
    ,
    READING_INPUT{

        @Override
        public boolean canTransitionFrom(WorkerStagePhase priorPhase) {
            return priorPhase == NEW;
        }
    }
    ,
    PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES{

        @Override
        public boolean canTransitionFrom(WorkerStagePhase priorPhase) {
            return priorPhase == READING_INPUT;
        }
    }
    ,
    PRESHUFFLE_WRITING_OUTPUT{

        @Override
        public boolean canTransitionFrom(WorkerStagePhase priorPhase) {
            return priorPhase == PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES || priorPhase == READING_INPUT;
        }
    }
    ,
    RESULTS_COMPLETE{

        @Override
        public boolean canTransitionFrom(WorkerStagePhase priorPhase) {
            return priorPhase == READING_INPUT || priorPhase == PRESHUFFLE_WRITING_OUTPUT;
        }
    }
    ,
    FINISHED{

        @Override
        public boolean canTransitionFrom(WorkerStagePhase priorPhase) {
            return priorPhase.compareTo(FINISHED) < 0;
        }
    }
    ,
    FAILED{

        @Override
        public boolean canTransitionFrom(WorkerStagePhase priorPhase) {
            return !priorPhase.isTerminal();
        }
    };


    public abstract boolean canTransitionFrom(WorkerStagePhase var1);

    public boolean isTerminal() {
        return this == FINISHED || this == FAILED;
    }

    public boolean isRunning() {
        return this != NEW && this != RESULTS_COMPLETE && this != FINISHED && this != FAILED;
    }
}

