/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="RowTooLarge")
public class RowTooLargeFault
extends BaseMSQFault {
    static final String CODE = "RowTooLarge";
    private final long maxFrameSize;

    @JsonCreator
    public RowTooLargeFault(@JsonProperty(value="maxFrameSize") long maxFrameSize) {
        super(CODE, "Encountered row that cannot fit in a single frame (max frame size = %,d)", maxFrameSize, new Object[0]);
        this.maxFrameSize = maxFrameSize;
    }

    @JsonProperty
    public long getMaxFrameSize() {
        return this.maxFrameSize;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RowTooLargeFault that = (RowTooLargeFault)o;
        return this.maxFrameSize == that.maxFrameSize;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxFrameSize);
    }
}

