/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.function.TriConsumer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.exec.WorkerClient;
import org.apache.druid.msq.exec.WorkerManager;
import org.apache.druid.msq.indexing.error.MSQFault;
import org.apache.druid.msq.indexing.error.WorkerRpcFailedFault;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.kernel.controller.ControllerQueryKernel;
import org.apache.druid.msq.rpc.SketchEncoding;
import org.apache.druid.msq.statistics.ClusterByStatisticsSnapshot;
import org.apache.druid.msq.statistics.CompleteKeyStatisticsInformation;

public class WorkerSketchFetcher
implements AutoCloseable {
    private static final Logger log = new Logger(WorkerSketchFetcher.class);
    private static final int DEFAULT_THREAD_COUNT = 4;
    private final WorkerClient workerClient;
    private final SketchEncoding sketchEncoding;
    private final WorkerManager workerManager;
    private final boolean retryEnabled;
    private final AtomicReference<Throwable> isError = new AtomicReference();
    final ExecutorService executorService;

    public WorkerSketchFetcher(WorkerClient workerClient, WorkerManager workerManager, boolean retryEnabled, SketchEncoding sketchEncoding) {
        this.workerClient = workerClient;
        this.sketchEncoding = sketchEncoding;
        this.executorService = Execs.multiThreaded((int)4, (String)"SketchFetcherThreadPool-%d");
        this.workerManager = workerManager;
        this.retryEnabled = retryEnabled;
    }

    public void inMemoryFullSketchMerging(Consumer<Consumer<ControllerQueryKernel>> kernelActions, StageId stageId, Set<String> taskIds, TriConsumer<ControllerQueryKernel, Integer, MSQFault> retryOperation) {
        for (String taskId : taskIds) {
            try {
                int workerNumber = this.workerManager.getWorkerNumber(taskId);
                this.executorService.submit(() -> this.fetchStatsFromWorker(kernelActions, () -> this.workerClient.fetchClusterByStatisticsSnapshot(taskId, stageId, this.sketchEncoding), taskId, (kernel, snapshot) -> kernel.mergeClusterByStatisticsCollectorForAllTimeChunks(stageId, workerNumber, (ClusterByStatisticsSnapshot)snapshot), retryOperation));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                if (this.isError.get() == null) {
                    throw rejectedExecutionException;
                }
                throw new ISE("Unable to fetch partitions %s", new Object[]{this.isError.get()});
            }
        }
    }

    private void fetchStatsFromWorker(final Consumer<Consumer<ControllerQueryKernel>> kernelActions, Supplier<ListenableFuture<ClusterByStatisticsSnapshot>> fetchStatsSupplier, final String taskId, final BiConsumer<ControllerQueryKernel, ClusterByStatisticsSnapshot> successKernelOperation, final TriConsumer<ControllerQueryKernel, Integer, MSQFault> retryOperation) {
        if (this.isError.get() != null) {
            this.executorService.shutdownNow();
            return;
        }
        final int worker = this.workerManager.getWorkerNumber(taskId);
        if (worker == -1) {
            log.info("Task[%s] is no longer the latest task for worker[%d]. Skipping fetch.", new Object[]{taskId, worker});
            return;
        }
        try {
            this.workerManager.waitForWorkers((Set<Integer>)ImmutableSet.of((Object)worker));
        }
        catch (InterruptedException interruptedException) {
            this.isError.compareAndSet(null, interruptedException);
            this.executorService.shutdownNow();
            return;
        }
        if (!this.workerManager.isWorkerActive(taskId)) {
            log.info("Task[%s] is no longer the latest task for worker[%d]. Skipping fetch.", new Object[]{taskId, worker});
            return;
        }
        ListenableFuture<ClusterByStatisticsSnapshot> fetchFuture = fetchStatsSupplier.get();
        final SettableFuture kernelActionFuture = SettableFuture.create();
        Futures.addCallback(fetchFuture, (FutureCallback)new FutureCallback<ClusterByStatisticsSnapshot>(){

            public void onSuccess(@Nullable ClusterByStatisticsSnapshot result) {
                try {
                    kernelActions.accept(queryKernel -> {
                        try {
                            successKernelOperation.accept(queryKernel, result);
                            kernelActionFuture.set((Object)true);
                        }
                        catch (Exception e) {
                            WorkerSketchFetcher.this.failFutureAndShutDownExecutorService(e, taskId, (SettableFuture<Boolean>)kernelActionFuture);
                        }
                    });
                }
                catch (Exception e) {
                    WorkerSketchFetcher.this.failFutureAndShutDownExecutorService(e, taskId, (SettableFuture<Boolean>)kernelActionFuture);
                }
            }

            public void onFailure(Throwable t) {
                if (WorkerSketchFetcher.this.retryEnabled) {
                    try {
                        kernelActions.accept(kernel -> {
                            try {
                                retryOperation.accept(kernel, (Object)worker, (Object)new WorkerRpcFailedFault(taskId));
                                kernelActionFuture.set((Object)false);
                            }
                            catch (Exception e) {
                                WorkerSketchFetcher.this.failFutureAndShutDownExecutorService(e, taskId, (SettableFuture<Boolean>)kernelActionFuture);
                            }
                        });
                        kernelActionFuture.set((Object)false);
                    }
                    catch (Exception e) {
                        WorkerSketchFetcher.this.failFutureAndShutDownExecutorService(e, taskId, (SettableFuture<Boolean>)kernelActionFuture);
                    }
                } else {
                    WorkerSketchFetcher.this.failFutureAndShutDownExecutorService(t, taskId, (SettableFuture<Boolean>)kernelActionFuture);
                }
            }
        }, (Executor)MoreExecutors.directExecutor());
        FutureUtils.getUnchecked((ListenableFuture)kernelActionFuture, (boolean)true);
    }

    private void failFutureAndShutDownExecutorService(Throwable t, String taskId, SettableFuture<Boolean> kernelActionFuture) {
        if (this.isError.compareAndSet(null, t)) {
            log.error(t, "Failed while fetching stats from task[%s]", new Object[]{taskId});
        }
        this.executorService.shutdownNow();
        kernelActionFuture.setException(t);
    }

    public void sequentialTimeChunkMerging(Consumer<Consumer<ControllerQueryKernel>> kernelActions, CompleteKeyStatisticsInformation completeKeyStatisticsInformation, StageId stageId, Set<String> tasks, TriConsumer<ControllerQueryKernel, Integer, MSQFault> retryOperation) {
        if (!completeKeyStatisticsInformation.isComplete()) {
            throw new ISE("All worker partial key information not received for stage[%d]", new Object[]{stageId.getStageNumber()});
        }
        HashSet<String> noBoundaries = new HashSet<String>(tasks);
        completeKeyStatisticsInformation.getTimeSegmentVsWorkerMap().forEach((timeChunk, wks) -> {
            for (String taskId : tasks) {
                int workerNumber = this.workerManager.getWorkerNumber(taskId);
                if (!wks.contains(workerNumber)) continue;
                noBoundaries.remove(taskId);
                this.executorService.submit(() -> this.fetchStatsFromWorker(kernelActions, () -> this.workerClient.fetchClusterByStatisticsSnapshotForTimeChunk(taskId, new StageId(stageId.getQueryId(), stageId.getStageNumber()), (long)timeChunk, this.sketchEncoding), taskId, (kernel, snapshot) -> kernel.mergeClusterByStatisticsCollectorForTimeChunk(stageId, workerNumber, (Long)timeChunk, (ClusterByStatisticsSnapshot)snapshot), retryOperation));
            }
        });
        for (String taskId : noBoundaries) {
            kernelActions.accept(kernel -> {
                int workerNumber = this.workerManager.getWorkerNumber(taskId);
                kernel.mergeClusterByStatisticsCollectorForAllTimeChunks(stageId, workerNumber, ClusterByStatisticsSnapshot.empty());
            });
        }
    }

    public Throwable getError() {
        return this.isError.get();
    }

    @Override
    public void close() {
        try {
            this.executorService.shutdownNow();
        }
        catch (Throwable suppressed) {
            log.warn(suppressed, "Error while shutting down WorkerSketchFetcher", new Object[0]);
        }
    }
}

