/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.hadoop;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class DatasourceIngestionSpec {
    private final String dataSource;
    private final List<Interval> intervals;
    private final List<DataSegment> segments;
    private final DimFilter filter;
    private final List<String> dimensions;
    private final List<String> metrics;
    private final boolean ignoreWhenNoSegments;
    private final TransformSpec transformSpec;

    @JsonCreator
    public DatasourceIngestionSpec(@JsonProperty(value="dataSource") String dataSource, @Deprecated @JsonProperty(value="interval") Interval interval, @JsonProperty(value="intervals") List<Interval> intervals, @JsonProperty(value="segments") List<DataSegment> segments, @JsonProperty(value="filter") DimFilter filter, @JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="metrics") List<String> metrics, @JsonProperty(value="ignoreWhenNoSegments") boolean ignoreWhenNoSegments, @JsonProperty(value="transformSpec") TransformSpec transformSpec) {
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"null dataSource");
        Preconditions.checkArgument((interval == null || intervals == null ? 1 : 0) != 0, (Object)"please specify intervals only");
        Object theIntervals = null;
        if (interval != null) {
            theIntervals = ImmutableList.of((Object)interval);
        } else if (intervals != null && intervals.size() > 0) {
            theIntervals = JodaUtils.condenseIntervals(intervals);
        }
        this.intervals = (List)Preconditions.checkNotNull((Object)theIntervals, (Object)"no intervals found");
        this.segments = segments;
        this.filter = filter;
        this.dimensions = dimensions;
        this.metrics = metrics;
        this.ignoreWhenNoSegments = ignoreWhenNoSegments;
        this.transformSpec = transformSpec != null ? transformSpec : TransformSpec.NONE;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public List<Interval> getIntervals() {
        return this.intervals;
    }

    @JsonProperty
    public List<DataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public DimFilter getFilter() {
        return this.filter;
    }

    @JsonProperty
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public List<String> getMetrics() {
        return this.metrics;
    }

    @JsonProperty
    public boolean isIgnoreWhenNoSegments() {
        return this.ignoreWhenNoSegments;
    }

    @JsonProperty
    public TransformSpec getTransformSpec() {
        return this.transformSpec;
    }

    public DatasourceIngestionSpec withDimensions(List<String> dimensions) {
        return new DatasourceIngestionSpec(this.dataSource, null, this.intervals, this.segments, this.filter, dimensions, this.metrics, this.ignoreWhenNoSegments, this.transformSpec);
    }

    public DatasourceIngestionSpec withMetrics(List<String> metrics) {
        return new DatasourceIngestionSpec(this.dataSource, null, this.intervals, this.segments, this.filter, this.dimensions, metrics, this.ignoreWhenNoSegments, this.transformSpec);
    }

    public DatasourceIngestionSpec withQueryGranularity(Granularity granularity) {
        return new DatasourceIngestionSpec(this.dataSource, null, this.intervals, this.segments, this.filter, this.dimensions, this.metrics, this.ignoreWhenNoSegments, this.transformSpec);
    }

    public DatasourceIngestionSpec withIgnoreWhenNoSegments(boolean ignoreWhenNoSegments) {
        return new DatasourceIngestionSpec(this.dataSource, null, this.intervals, this.segments, this.filter, this.dimensions, this.metrics, ignoreWhenNoSegments, this.transformSpec);
    }

    public DatasourceIngestionSpec withTransformSpec(TransformSpec transformSpec) {
        return new DatasourceIngestionSpec(this.dataSource, null, this.intervals, this.segments, this.filter, this.dimensions, this.metrics, this.ignoreWhenNoSegments, transformSpec);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasourceIngestionSpec that = (DatasourceIngestionSpec)o;
        return this.ignoreWhenNoSegments == that.ignoreWhenNoSegments && Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.intervals, that.intervals) && Objects.equals(this.segments, that.segments) && Objects.equals(this.filter, that.filter) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.metrics, that.metrics) && Objects.equals(this.transformSpec, that.transformSpec);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.intervals, this.segments, this.filter, this.dimensions, this.metrics, this.ignoreWhenNoSegments, this.transformSpec);
    }

    public String toString() {
        return "DatasourceIngestionSpec{dataSource='" + this.dataSource + "', intervals=" + this.intervals + ", segments=" + SegmentUtils.commaSeparatedIdentifiers(this.segments) + ", filter=" + this.filter + ", dimensions=" + this.dimensions + ", metrics=" + this.metrics + ", ignoreWhenNoSegments=" + this.ignoreWhenNoSegments + ", transformSpec=" + this.transformSpec + "}";
    }
}

