/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.rules.LoadRule;
import org.apache.druid.server.coordinator.rules.Rules;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class IntervalLoadRule
extends LoadRule {
    private static final Logger log = new Logger(IntervalLoadRule.class);
    private final Interval interval;

    @JsonCreator
    public IntervalLoadRule(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="tieredReplicants") Map<String, Integer> tieredReplicants, @JsonProperty(value="useDefaultTierForNull") @Nullable Boolean useDefaultTierForNull) {
        super(tieredReplicants, useDefaultTierForNull);
        this.interval = interval;
    }

    @Override
    @JsonProperty
    public String getType() {
        return "loadByInterval";
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
        return this.appliesTo(segment.getInterval(), referenceTimestamp);
    }

    @Override
    public boolean appliesTo(Interval theInterval, DateTime referenceTimestamp) {
        return Rules.eligibleForLoad(this.interval, theInterval);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntervalLoadRule that = (IntervalLoadRule)o;
        return Objects.equals(this.interval, that.interval);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.interval);
    }
}

