/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.client.DirectDruidClient;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.SequenceWrapper;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.DruidMetrics;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.context.ConcurrentResponseContext;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.server.QueryResource;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.QueryStats;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class QueryLifecycle {
    private static final Logger log = new Logger(QueryLifecycle.class);
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final QuerySegmentWalker texasRanger;
    private final GenericQueryMetricsFactory queryMetricsFactory;
    private final ServiceEmitter emitter;
    private final RequestLogger requestLogger;
    private final AuthorizerMapper authorizerMapper;
    private final DefaultQueryConfig defaultQueryConfig;
    private final AuthConfig authConfig;
    private final long startMs;
    private final long startNs;
    private State state = State.NEW;
    private AuthenticationResult authenticationResult;
    private QueryToolChest toolChest;
    private @MonotonicNonNull Query<?> baseQuery;
    private @MonotonicNonNull Set<String> userContextKeys;

    public QueryLifecycle(QueryRunnerFactoryConglomerate conglomerate, QuerySegmentWalker texasRanger, GenericQueryMetricsFactory queryMetricsFactory, ServiceEmitter emitter, RequestLogger requestLogger, AuthorizerMapper authorizerMapper, DefaultQueryConfig defaultQueryConfig, AuthConfig authConfig, long startMs, long startNs) {
        this.conglomerate = conglomerate;
        this.texasRanger = texasRanger;
        this.queryMetricsFactory = queryMetricsFactory;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
        this.authorizerMapper = authorizerMapper;
        this.defaultQueryConfig = defaultQueryConfig;
        this.authConfig = authConfig;
        this.startMs = startMs;
        this.startNs = startNs;
    }

    public <T> QueryResponse<T> runSimple(Query<T> query, AuthenticationResult authenticationResult, AuthorizationResult authorizationResult) {
        Sequence<T> results;
        QueryResponse<T> queryResponse;
        this.initialize(query);
        try {
            this.preAuthorized(authenticationResult, authorizationResult);
            queryResponse = this.execute();
            results = queryResponse.getResults();
        }
        catch (Throwable e) {
            this.emitLogsAndMetrics(e, null, -1L);
            throw e;
        }
        return new QueryResponse(Sequences.wrap(results, (SequenceWrapper)new SequenceWrapper(){

            public void after(boolean isDone, Throwable thrown) {
                QueryLifecycle.this.emitLogsAndMetrics(thrown, null, -1L);
            }
        }), queryResponse.getResponseContext());
    }

    public void initialize(Query<?> baseQuery) {
        this.transition(State.NEW, State.INITIALIZED);
        this.userContextKeys = new HashSet(baseQuery.getContext().keySet());
        String queryId = baseQuery.getId();
        if (Strings.isNullOrEmpty((String)queryId)) {
            queryId = UUID.randomUUID().toString();
        }
        Map mergedUserAndConfigContext = QueryContexts.override((Map)this.defaultQueryConfig.getContext(), (Map)baseQuery.getContext());
        mergedUserAndConfigContext.put("queryId", queryId);
        this.baseQuery = baseQuery.withOverriddenContext(mergedUserAndConfigContext);
        this.toolChest = this.conglomerate.getToolChest(this.baseQuery);
    }

    public AuthorizationResult authorize(HttpServletRequest req) {
        this.transition(State.INITIALIZED, State.AUTHORIZING);
        Iterable resourcesToAuthorize = Iterables.concat((Iterable)Iterables.transform((Iterable)this.baseQuery.getDataSource().getTableNames(), AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR), (Iterable)Iterables.transform(this.authConfig.contextKeysToAuthorize(this.userContextKeys), contextParam -> new ResourceAction(new Resource((String)contextParam, "QUERY_CONTEXT"), Action.WRITE)));
        return this.doAuthorize(AuthorizationUtils.authenticationResultFromRequest(req), AuthorizationUtils.authorizeAllResourceActions(req, (Iterable<ResourceAction>)resourcesToAuthorize, this.authorizerMapper));
    }

    public AuthorizationResult authorize(AuthenticationResult authenticationResult) {
        this.transition(State.INITIALIZED, State.AUTHORIZING);
        Iterable resourcesToAuthorize = Iterables.concat((Iterable)Iterables.transform((Iterable)this.baseQuery.getDataSource().getTableNames(), AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR), (Iterable)Iterables.transform(this.authConfig.contextKeysToAuthorize(this.userContextKeys), contextParam -> new ResourceAction(new Resource((String)contextParam, "QUERY_CONTEXT"), Action.WRITE)));
        return this.doAuthorize(authenticationResult, AuthorizationUtils.authorizeAllResourceActions(authenticationResult, (Iterable<ResourceAction>)resourcesToAuthorize, this.authorizerMapper));
    }

    private void preAuthorized(AuthenticationResult authenticationResult, AuthorizationResult authorizationResult) {
        this.transition(State.INITIALIZED, State.AUTHORIZING);
        this.doAuthorize(authenticationResult, authorizationResult);
        if (!this.state.equals((Object)State.AUTHORIZED)) {
            throw DruidException.defensive((String)"Unexpected state [%s], expecting [%s].", (Object[])new Object[]{this.state, State.AUTHORIZED});
        }
    }

    private AuthorizationResult doAuthorize(AuthenticationResult authenticationResult, AuthorizationResult authorizationResult) {
        Preconditions.checkNotNull((Object)authenticationResult, (Object)"authenticationResult");
        Preconditions.checkNotNull((Object)authorizationResult, (Object)"authorizationResult");
        if (!authorizationResult.allowBasicAccess()) {
            this.transition(State.AUTHORIZING, State.UNAUTHORIZED);
        } else {
            this.transition(State.AUTHORIZING, State.AUTHORIZED);
            if (!(this.baseQuery instanceof SegmentMetadataQuery) || !authorizationResult.allowAccessWithNoRestriction()) {
                this.baseQuery = this.baseQuery.withDataSource(this.baseQuery.getDataSource().withPolicies(authorizationResult.getPolicyMap()));
            }
        }
        this.authenticationResult = authenticationResult;
        return authorizationResult;
    }

    public <T> QueryResponse<T> execute() {
        this.transition(State.AUTHORIZED, State.EXECUTING);
        ConcurrentResponseContext responseContext = DirectDruidClient.makeResponseContextForQuery();
        Sequence res = QueryPlus.wrap(this.baseQuery).withIdentity(this.authenticationResult.getIdentity()).run(this.texasRanger, (ResponseContext)responseContext);
        return new QueryResponse(res == null ? Sequences.empty() : res, (ResponseContext)responseContext);
    }

    public void emitLogsAndMetrics(@Nullable Throwable e, @Nullable String remoteAddress, long bytesWritten) {
        if (this.baseQuery == null) {
            return;
        }
        if (this.state == State.DONE) {
            log.warn("Tried to emit logs and metrics twice for query[%s]!", new Object[]{this.baseQuery.getId()});
        }
        this.state = State.DONE;
        boolean success = e == null;
        try {
            long queryTimeNs = System.nanoTime() - this.startNs;
            QueryMetrics queryMetrics = DruidMetrics.makeRequestMetrics((GenericQueryMetricsFactory)this.queryMetricsFactory, (QueryToolChest)this.toolChest, this.baseQuery, (String)StringUtils.nullToEmptyNonDruidDataString((String)remoteAddress));
            queryMetrics.success(success);
            queryMetrics.reportQueryTime(queryTimeNs);
            if (bytesWritten >= 0L) {
                queryMetrics.reportQueryBytes(bytesWritten);
            }
            if (this.authenticationResult != null) {
                queryMetrics.identity(this.authenticationResult.getIdentity());
            }
            queryMetrics.emit(this.emitter);
            LinkedHashMap<String, Object> statsMap = new LinkedHashMap<String, Object>();
            statsMap.put("query/time", TimeUnit.NANOSECONDS.toMillis(queryTimeNs));
            statsMap.put("query/bytes", bytesWritten);
            statsMap.put("success", success);
            if (this.authenticationResult != null) {
                statsMap.put("identity", this.authenticationResult.getIdentity());
            }
            if (e != null) {
                statsMap.put("exception", e.toString());
                if (this.baseQuery.context().isDebug() || e.getMessage() == null) {
                    log.warn(e, "Exception while processing queryId [%s]", new Object[]{this.baseQuery.getId()});
                } else {
                    log.noStackTrace().warn(e, "Exception while processing queryId [%s]", new Object[]{this.baseQuery.getId()});
                }
                if (e instanceof QueryInterruptedException || e instanceof QueryTimeoutException) {
                    statsMap.put("interrupted", true);
                    statsMap.put("reason", e.toString());
                }
            }
            this.requestLogger.logNativeQuery(RequestLogLine.forNative(this.baseQuery, DateTimes.utc((long)this.startMs), StringUtils.nullToEmptyNonDruidDataString((String)remoteAddress), new QueryStats(statsMap)));
        }
        catch (Exception ex) {
            log.error((Throwable)ex, "Unable to log query [%s]!", new Object[]{this.baseQuery});
        }
    }

    @Nullable
    public Query<?> getQuery() {
        return this.baseQuery;
    }

    public String getQueryId() {
        return this.baseQuery.getId();
    }

    public String threadName(String currThreadName) {
        return StringUtils.format((String)"%s[%s_%s_%s]", (Object[])new Object[]{currThreadName, this.baseQuery.getType(), this.baseQuery.getDataSource().getTableNames(), this.getQueryId()});
    }

    private boolean isSerializeDateTimeAsLong() {
        QueryContext queryContext = this.baseQuery.context();
        boolean shouldFinalize = queryContext.isFinalize(true);
        return queryContext.isSerializeDateTimeAsLong(false) || !shouldFinalize && queryContext.isSerializeDateTimeAsLongInner(false);
    }

    public ObjectMapper newOutputWriter(QueryResource.ResourceIOReaderWriter ioReaderWriter) {
        return ioReaderWriter.getResponseWriter().newOutputWriter(this.getToolChest(), this.baseQuery, this.isSerializeDateTimeAsLong());
    }

    public QueryToolChest getToolChest() {
        if (this.state.compareTo(State.INITIALIZED) < 0) {
            throw new ISE("Not yet initialized", new Object[0]);
        }
        return this.toolChest;
    }

    private void transition(State from, State to) {
        if (this.state != from) {
            throw DruidException.defensive((String)"Cannot transition from[%s] to[%s], current state[%s].", (Object[])new Object[]{from, to, this.state});
        }
        this.state = to;
    }

    static enum State {
        NEW,
        INITIALIZED,
        AUTHORIZING,
        AUTHORIZED,
        EXECUTING,
        UNAUTHORIZED,
        DONE;

    }
}

