/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.DruidServerMetadata;

public class ServiceLocation {
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;
    private static final Splitter HOST_SPLITTER = Splitter.on((String)":").limit(2);
    private final String host;
    private final int plaintextPort;
    private final int tlsPort;
    private final String basePath;

    public ServiceLocation(String host, int plaintextPort, int tlsPort, String basePath) {
        this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host");
        this.plaintextPort = plaintextPort;
        this.tlsPort = tlsPort;
        this.basePath = (String)Preconditions.checkNotNull((Object)basePath, (Object)"basePath");
    }

    public static ServiceLocation fromDruidNode(DruidNode druidNode) {
        return new ServiceLocation(druidNode.getHost(), druidNode.getPlaintextPort(), druidNode.getTlsPort(), "");
    }

    public static ServiceLocation fromUri(URI uri) {
        if (uri == null || uri.getHost() == null) {
            throw new IAE("URI[%s] has no host", new Object[]{uri});
        }
        String scheme = uri.getScheme();
        String host = ServiceLocation.stripBrackets(uri.getHost());
        StringBuilder basePath = new StringBuilder();
        if (uri.getRawPath() != null) {
            if (uri.getRawQuery() == null && uri.getRawFragment() == null && uri.getRawPath().endsWith("/")) {
                basePath.append(uri.getRawPath(), 0, uri.getRawPath().length() - 1);
            } else {
                basePath.append(uri.getRawPath());
            }
        }
        if (uri.getRawQuery() != null) {
            basePath.append('?').append(uri.getRawQuery());
        }
        if (uri.getRawFragment() != null) {
            basePath.append('#').append(uri.getRawFragment());
        }
        if (HTTP_SCHEME.equals(scheme)) {
            int port = uri.getPort() < 0 ? 80 : uri.getPort();
            return new ServiceLocation(host, port, -1, basePath.toString());
        }
        if (HTTPS_SCHEME.equals(scheme)) {
            int port = uri.getPort() < 0 ? 443 : uri.getPort();
            return new ServiceLocation(host, -1, port, basePath.toString());
        }
        throw new IAE("URI[%s] has invalid scheme[%s]", new Object[]{uri, scheme});
    }

    public static ServiceLocation fromDruidServerMetadata(DruidServerMetadata druidServerMetadata) {
        String host = ServiceLocation.getHostFromString((String)Preconditions.checkNotNull((Object)druidServerMetadata.getHost(), (String)"Host was null for druid server metadata[%s]", (Object)druidServerMetadata));
        int plaintextPort = ServiceLocation.getPortFromString(druidServerMetadata.getHostAndPort());
        int tlsPort = ServiceLocation.getPortFromString(druidServerMetadata.getHostAndTlsPort());
        return new ServiceLocation(host, plaintextPort, tlsPort, "");
    }

    private static String getHostFromString(@NotNull String s) {
        Iterator iterator = HOST_SPLITTER.split((CharSequence)s).iterator();
        ImmutableList strings = ImmutableList.copyOf(iterator);
        return (String)strings.get(0);
    }

    private static int getPortFromString(String s) {
        if (s == null) {
            return -1;
        }
        Iterator iterator = HOST_SPLITTER.split((CharSequence)s).iterator();
        ImmutableList strings = ImmutableList.copyOf(iterator);
        try {
            return Integer.parseInt((String)strings.get(1));
        }
        catch (NumberFormatException e) {
            throw new ISE((Throwable)e, "Unable to parse port out of %s", new Object[]{strings.get(1)});
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPlaintextPort() {
        return this.plaintextPort;
    }

    public int getTlsPort() {
        return this.tlsPort;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ServiceLocation withBasePath(String newBasePath) {
        return new ServiceLocation(this.host, this.plaintextPort, this.tlsPort, newBasePath);
    }

    public URL toURL(@Nullable String encodedPathAndQueryString) {
        int portToUse;
        String scheme;
        if (this.tlsPort > 0) {
            scheme = HTTPS_SCHEME;
            portToUse = this.tlsPort;
        } else {
            scheme = HTTP_SCHEME;
            portToUse = this.plaintextPort;
        }
        try {
            return new URL(scheme, this.host, portToUse, this.basePath + (encodedPathAndQueryString == null ? "" : encodedPathAndQueryString));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLocation that = (ServiceLocation)o;
        return this.plaintextPort == that.plaintextPort && this.tlsPort == that.tlsPort && Objects.equals(this.host, that.host) && Objects.equals(this.basePath, that.basePath);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.plaintextPort, this.tlsPort, this.basePath);
    }

    public String toString() {
        return "ServiceLocation{host='" + this.host + "', plaintextPort=" + this.plaintextPort + ", tlsPort=" + this.tlsPort + ", basePath='" + this.basePath + "'}";
    }

    static String stripBrackets(String host) {
        if (host.charAt(0) == '[' && host.charAt(host.length() - 1) == ']') {
            return host.substring(1, host.length() - 1);
        }
        return host;
    }
}

