/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.SegmentCreateRequest;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.PendingSegmentRecord;
import org.apache.druid.metadata.ReplaceTaskLock;
import org.apache.druid.metadata.RetryTransactionException;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SqlSegmentsMetadataQuery;
import org.apache.druid.segment.SegmentMetadata;
import org.apache.druid.segment.SegmentSchemaMapping;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.SegmentSchemaManager;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Partitions;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;
import org.joda.time.chrono.ISOChronology;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.CallbackFailedException;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.ByteArrayMapper;

public class IndexerSQLMetadataStorageCoordinator
implements IndexerMetadataStorageCoordinator {
    private static final Logger log = new Logger(IndexerSQLMetadataStorageCoordinator.class);
    private static final int MAX_NUM_SEGMENTS_TO_ANNOUNCE_AT_ONCE = 100;
    private static final String UPGRADED_PENDING_SEGMENT_PREFIX = "upgraded_to_version__";
    private final ObjectMapper jsonMapper;
    private final MetadataStorageTablesConfig dbTables;
    private final SQLMetadataConnector connector;
    private final SegmentSchemaManager segmentSchemaManager;
    private final CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig;
    private final boolean schemaPersistEnabled;

    @Inject
    public IndexerSQLMetadataStorageCoordinator(ObjectMapper jsonMapper, MetadataStorageTablesConfig dbTables, SQLMetadataConnector connector, SegmentSchemaManager segmentSchemaManager, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
        this.jsonMapper = jsonMapper;
        this.dbTables = dbTables;
        this.connector = connector;
        this.segmentSchemaManager = segmentSchemaManager;
        this.centralizedDatasourceSchemaConfig = centralizedDatasourceSchemaConfig;
        this.schemaPersistEnabled = centralizedDatasourceSchemaConfig.isEnabled() && !centralizedDatasourceSchemaConfig.isTaskSchemaPublishDisabled();
    }

    @LifecycleStart
    public void start() {
        this.connector.createDataSourceTable();
        this.connector.createPendingSegmentsTable();
        if (this.centralizedDatasourceSchemaConfig.isEnabled()) {
            this.connector.createSegmentSchemasTable();
        }
        this.connector.createSegmentTable();
        this.connector.createUpgradeSegmentsTable();
    }

    @Override
    public Set<DataSegment> retrieveUsedSegmentsForIntervals(String dataSource, List<Interval> intervals, Segments visibility) {
        if (intervals == null || intervals.isEmpty()) {
            throw new IAE("null/empty intervals", new Object[0]);
        }
        return this.doRetrieveUsedSegments(dataSource, intervals, visibility);
    }

    @Override
    public Set<DataSegment> retrieveAllUsedSegments(String dataSource, Segments visibility) {
        return this.doRetrieveUsedSegments(dataSource, Collections.emptyList(), visibility);
    }

    private Set<DataSegment> doRetrieveUsedSegments(String dataSource, List<Interval> intervals, Segments visibility) {
        return (Set)this.connector.retryWithHandle(handle -> {
            if (visibility == Segments.ONLY_VISIBLE) {
                SegmentTimeline timeline = this.getTimelineForIntervalsWithHandle(handle, dataSource, intervals);
                return timeline.findNonOvershadowedObjectsInInterval(Intervals.ETERNITY, Partitions.ONLY_COMPLETE);
            }
            return this.retrieveAllUsedSegmentsForIntervalsWithHandle(handle, dataSource, intervals);
        });
    }

    public List<Pair<DataSegment, String>> retrieveUsedSegmentsAndCreatedDates(String dataSource, List<Interval> intervals) {
        StringBuilder queryBuilder = new StringBuilder("SELECT created_date, payload FROM %1$s WHERE dataSource = :dataSource AND used = true");
        boolean compareIntervalEndpointsAsString = intervals.stream().allMatch(Intervals::canCompareEndpointsAsStrings);
        SqlSegmentsMetadataQuery.IntervalMode intervalMode = SqlSegmentsMetadataQuery.IntervalMode.OVERLAPS;
        queryBuilder.append(SqlSegmentsMetadataQuery.getConditionForIntervalsAndMatchMode(compareIntervalEndpointsAsString ? intervals : Collections.emptyList(), intervalMode, this.connector.getQuoteString()));
        String queryString = StringUtils.format((String)queryBuilder.toString(), (Object[])new Object[]{this.dbTables.getSegmentsTable()});
        return (List)this.connector.retryWithHandle(handle -> {
            Query query = (Query)handle.createQuery(queryString).bind("dataSource", dataSource);
            if (compareIntervalEndpointsAsString) {
                SqlSegmentsMetadataQuery.bindIntervalsToQuery((Query<Map<String, Object>>)query, intervals);
            }
            List segmentsWithCreatedDates = query.map((index, r, ctx) -> new Pair((Object)((DataSegment)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])r.getBytes("payload"), DataSegment.class)), (Object)r.getString("created_date"))).list();
            if (intervals.isEmpty() || compareIntervalEndpointsAsString) {
                return segmentsWithCreatedDates;
            }
            return segmentsWithCreatedDates.stream().filter(pair -> {
                for (Interval interval : intervals) {
                    if (!intervalMode.apply(interval, ((DataSegment)pair.lhs).getInterval())) continue;
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
        });
    }

    List<String> retrieveUnusedSegmentIdsForExactIntervalAndVersion(String dataSource, Interval interval, String version) {
        String sql = "SELECT id FROM %1$s WHERE used = :used AND dataSource = :dataSource AND version = :version AND start = :start AND %2$send%2$s = :end";
        List matchingSegments = (List)this.connector.inReadOnlyTransaction((handle, status) -> {
            Query query = (Query)((Query)((Query)((Query)((Query)handle.createQuery(StringUtils.format((String)"SELECT id FROM %1$s WHERE used = :used AND dataSource = :dataSource AND version = :version AND start = :start AND %2$send%2$s = :end", (Object[])new Object[]{this.dbTables.getSegmentsTable(), this.connector.getQuoteString()})).setFetchSize(this.connector.getStreamingFetchSize()).bind("used", false)).bind("dataSource", dataSource)).bind("version", version)).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString());
            try (ResultIterator iterator = query.map((index, r, ctx) -> r.getString(1)).iterator();){
                ImmutableList immutableList = ImmutableList.copyOf((Iterator)iterator);
                return immutableList;
            }
        });
        log.debug("Found [%,d] unused segments for datasource[%s] for interval[%s] and version[%s].", new Object[]{matchingSegments.size(), dataSource, interval, version});
        return matchingSegments;
    }

    @Override
    public List<DataSegment> retrieveUnusedSegmentsForInterval(String dataSource, Interval interval, @Nullable List<String> versions, @Nullable Integer limit, @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        List matchingSegments = (List)this.connector.inReadOnlyTransaction((handle, status) -> {
            try (CloseableIterator<DataSegment> iterator = SqlSegmentsMetadataQuery.forHandle(handle, this.connector, this.dbTables, this.jsonMapper).retrieveUnusedSegments(dataSource, Collections.singletonList(interval), versions, limit, null, null, maxUsedStatusLastUpdatedTime);){
                ImmutableList immutableList = ImmutableList.copyOf(iterator);
                return immutableList;
            }
        });
        log.info("Found [%,d] unused segments for datasource[%s] in interval[%s] and versions[%s] with maxUsedStatusLastUpdatedTime[%s].", new Object[]{matchingSegments.size(), dataSource, interval, versions, maxUsedStatusLastUpdatedTime});
        return matchingSegments;
    }

    @Override
    public Set<DataSegment> retrieveSegmentsById(String dataSource, Set<String> segmentIds) {
        return (Set)this.connector.inReadOnlyTransaction((handle, transactionStatus) -> this.retrieveSegmentsById(handle, dataSource, segmentIds).stream().map(DataSegmentPlus::getDataSegment).collect(Collectors.toSet()));
    }

    @Override
    public int markSegmentsAsUnusedWithinInterval(String dataSource, Interval interval) {
        Integer numSegmentsMarkedUnused = (Integer)this.connector.retryTransaction((handle, status) -> SqlSegmentsMetadataQuery.forHandle(handle, this.connector, this.dbTables, this.jsonMapper).markSegmentsUnused(dataSource, interval), 3, 10);
        log.info("Marked %,d segments unused for %s for interval %s.", new Object[]{numSegmentsMarkedUnused, dataSource, interval});
        return numSegmentsMarkedUnused;
    }

    private List<PendingSegmentRecord> getPendingSegmentsForInterval(Handle handle, String dataSource, Interval interval) {
        boolean compareIntervalEndpointsAsStrings = Intervals.canCompareEndpointsAsStrings((Interval)interval);
        String sql = "SELECT payload, sequence_name, sequence_prev_id, task_allocator_id, upgraded_from_segment_id FROM " + this.dbTables.getPendingSegmentsTable() + " WHERE dataSource = :dataSource";
        if (compareIntervalEndpointsAsStrings) {
            sql = sql + " AND start < :end" + StringUtils.format((String)" AND %1$send%1$s > :start", (Object[])new Object[]{this.connector.getQuoteString()});
        }
        Query query = (Query)handle.createQuery(sql).bind("dataSource", dataSource);
        if (compareIntervalEndpointsAsStrings) {
            query = (Query)((Query)query.bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString());
        }
        ResultIterator pendingSegmentIterator = query.map((index, r, ctx) -> PendingSegmentRecord.fromResultSet(r, this.jsonMapper)).iterator();
        ImmutableList.Builder pendingSegments = ImmutableList.builder();
        while (pendingSegmentIterator.hasNext()) {
            PendingSegmentRecord pendingSegment = (PendingSegmentRecord)pendingSegmentIterator.next();
            if (!compareIntervalEndpointsAsStrings && !pendingSegment.getId().getInterval().overlaps((ReadableInterval)interval)) continue;
            pendingSegments.add((Object)pendingSegment);
        }
        pendingSegmentIterator.close();
        return pendingSegments.build();
    }

    private List<PendingSegmentRecord> getPendingSegmentsForTaskAllocatorId(Handle handle, String dataSource, String taskAllocatorId) {
        String sql = "SELECT payload, sequence_name, sequence_prev_id, task_allocator_id, upgraded_from_segment_id FROM " + this.dbTables.getPendingSegmentsTable() + " WHERE dataSource = :dataSource AND task_allocator_id = :task_allocator_id";
        Query query = (Query)((Query)handle.createQuery(sql).bind("dataSource", dataSource)).bind("task_allocator_id", taskAllocatorId);
        ResultIterator pendingSegmentRecords = query.map((index, r, ctx) -> PendingSegmentRecord.fromResultSet(r, this.jsonMapper)).iterator();
        ArrayList<PendingSegmentRecord> pendingSegments = new ArrayList<PendingSegmentRecord>();
        while (pendingSegmentRecords.hasNext()) {
            pendingSegments.add((PendingSegmentRecord)pendingSegmentRecords.next());
        }
        pendingSegmentRecords.close();
        return pendingSegments;
    }

    private SegmentTimeline getTimelineForIntervalsWithHandle(Handle handle, String dataSource, List<Interval> intervals) throws IOException {
        try (CloseableIterator<DataSegment> iterator = SqlSegmentsMetadataQuery.forHandle(handle, this.connector, this.dbTables, this.jsonMapper).retrieveUsedSegments(dataSource, intervals);){
            SegmentTimeline segmentTimeline = SegmentTimeline.forSegments(iterator);
            return segmentTimeline;
        }
    }

    private Set<DataSegment> retrieveAllUsedSegmentsForIntervalsWithHandle(Handle handle, String dataSource, List<Interval> intervals) throws IOException {
        try (CloseableIterator<DataSegment> iterator = SqlSegmentsMetadataQuery.forHandle(handle, this.connector, this.dbTables, this.jsonMapper).retrieveUsedSegments(dataSource, intervals);){
            HashSet<DataSegment> retVal = new HashSet<DataSegment>();
            iterator.forEachRemaining(retVal::add);
            HashSet<DataSegment> hashSet = retVal;
            return hashSet;
        }
    }

    @Override
    public Set<DataSegment> commitSegments(Set<DataSegment> segments, @Nullable SegmentSchemaMapping segmentSchemaMapping) {
        SegmentPublishResult result = this.commitSegmentsAndMetadata(segments, null, null, segmentSchemaMapping);
        if (!result.isSuccess()) {
            throw new ISE("announceHistoricalSegments failed with null metadata, should not happen.", new Object[0]);
        }
        return result.getSegments();
    }

    @Override
    public SegmentPublishResult commitSegmentsAndMetadata(Set<DataSegment> segments, @Nullable DataSourceMetadata startMetadata, @Nullable DataSourceMetadata endMetadata, @Nullable SegmentSchemaMapping segmentSchemaMapping) {
        this.verifySegmentsToCommit(segments);
        if (startMetadata == null && endMetadata != null || startMetadata != null && endMetadata == null) {
            throw new IllegalArgumentException("start/end metadata pair must be either null or non-null");
        }
        String dataSource = segments.iterator().next().getDataSource();
        HashSet<DataSegment> usedSegments = new HashSet<DataSegment>();
        List segmentHolders = SegmentTimeline.forSegments(segments).lookupWithIncompletePartitions(Intervals.ETERNITY);
        for (TimelineObjectHolder holder : segmentHolders) {
            for (PartitionChunk chunk : holder.getObject()) {
                usedSegments.add((DataSegment)chunk.getObject());
            }
        }
        AtomicBoolean definitelyNotUpdated = new AtomicBoolean(false);
        try {
            return (SegmentPublishResult)this.connector.retryTransaction((handle, transactionStatus) -> {
                DataStoreMetadataUpdateResult result;
                definitelyNotUpdated.set(false);
                if (startMetadata != null && (result = this.updateDataSourceMetadataWithHandle(handle, dataSource, startMetadata, endMetadata)).isFailed()) {
                    transactionStatus.setRollbackOnly();
                    definitelyNotUpdated.set(true);
                    if (result.canRetry()) {
                        throw new RetryTransactionException(result.getErrorMsg());
                    }
                    throw InvalidInput.exception((String)result.getErrorMsg(), (Object[])new Object[0]);
                }
                Set<DataSegment> inserted = this.announceHistoricalSegmentBatch(handle, segments, usedSegments, segmentSchemaMapping);
                return SegmentPublishResult.ok((Set<DataSegment>)ImmutableSet.copyOf(inserted));
            }, 3, this.getSqlMetadataMaxRetry());
        }
        catch (CallbackFailedException e) {
            if (definitelyNotUpdated.get()) {
                return SegmentPublishResult.fail(e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public SegmentPublishResult commitReplaceSegments(Set<DataSegment> replaceSegments, Set<ReplaceTaskLock> locksHeldByReplaceTask, @Nullable SegmentSchemaMapping segmentSchemaMapping) {
        this.verifySegmentsToCommit(replaceSegments);
        try {
            return (SegmentPublishResult)this.connector.retryTransaction((handle, transactionStatus) -> {
                HashSet<DataSegment> segmentsToInsert = new HashSet<DataSegment>(replaceSegments);
                Set<DataSegmentPlus> upgradedSegments = this.createNewIdsOfAppendSegmentsAfterReplace(handle, replaceSegments, locksHeldByReplaceTask);
                HashMap<SegmentId, SegmentMetadata> upgradeSegmentMetadata = new HashMap<SegmentId, SegmentMetadata>();
                HashMap<String, String> upgradedFromSegmentIdMap = new HashMap<String, String>();
                for (DataSegmentPlus dataSegmentPlus : upgradedSegments) {
                    segmentsToInsert.add(dataSegmentPlus.getDataSegment());
                    if (dataSegmentPlus.getSchemaFingerprint() != null && dataSegmentPlus.getNumRows() != null) {
                        upgradeSegmentMetadata.put(dataSegmentPlus.getDataSegment().getId(), new SegmentMetadata(dataSegmentPlus.getNumRows(), dataSegmentPlus.getSchemaFingerprint()));
                    }
                    if (dataSegmentPlus.getUpgradedFromSegmentId() == null) continue;
                    upgradedFromSegmentIdMap.put(dataSegmentPlus.getDataSegment().getId().toString(), dataSegmentPlus.getUpgradedFromSegmentId());
                }
                return SegmentPublishResult.ok(this.insertSegments(handle, segmentsToInsert, segmentSchemaMapping, upgradeSegmentMetadata, Collections.emptyMap(), upgradedFromSegmentIdMap), this.upgradePendingSegmentsOverlappingWith(segmentsToInsert));
            }, 3, this.getSqlMetadataMaxRetry());
        }
        catch (CallbackFailedException e) {
            return SegmentPublishResult.fail(e.getMessage());
        }
    }

    @Override
    public SegmentPublishResult commitAppendSegments(Set<DataSegment> appendSegments, Map<DataSegment, ReplaceTaskLock> appendSegmentToReplaceLock, String taskAllocatorId, @Nullable SegmentSchemaMapping segmentSchemaMapping) {
        return this.commitAppendSegmentsAndMetadataInTransaction(appendSegments, appendSegmentToReplaceLock, null, null, taskAllocatorId, segmentSchemaMapping);
    }

    @Override
    public SegmentPublishResult commitAppendSegmentsAndMetadata(Set<DataSegment> appendSegments, Map<DataSegment, ReplaceTaskLock> appendSegmentToReplaceLock, DataSourceMetadata startMetadata, DataSourceMetadata endMetadata, String taskAllocatorId, @Nullable SegmentSchemaMapping segmentSchemaMapping) {
        return this.commitAppendSegmentsAndMetadataInTransaction(appendSegments, appendSegmentToReplaceLock, startMetadata, endMetadata, taskAllocatorId, segmentSchemaMapping);
    }

    @Override
    public SegmentPublishResult commitMetadataOnly(final String dataSource, final DataSourceMetadata startMetadata, final DataSourceMetadata endMetadata) {
        if (dataSource == null) {
            throw new IllegalArgumentException("datasource name cannot be null");
        }
        if (startMetadata == null) {
            throw new IllegalArgumentException("start metadata cannot be null");
        }
        if (endMetadata == null) {
            throw new IllegalArgumentException("end metadata cannot be null");
        }
        final AtomicBoolean definitelyNotUpdated = new AtomicBoolean(false);
        try {
            return this.connector.retryTransaction(new TransactionCallback<SegmentPublishResult>(){

                public SegmentPublishResult inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                    definitelyNotUpdated.set(false);
                    DataStoreMetadataUpdateResult result = IndexerSQLMetadataStorageCoordinator.this.updateDataSourceMetadataWithHandle(handle, dataSource, startMetadata, endMetadata);
                    if (result.isFailed()) {
                        transactionStatus.setRollbackOnly();
                        definitelyNotUpdated.set(true);
                        if (result.canRetry()) {
                            throw new RetryTransactionException(result.getErrorMsg());
                        }
                        throw new RuntimeException(result.getErrorMsg());
                    }
                    return SegmentPublishResult.ok((Set<DataSegment>)ImmutableSet.of());
                }
            }, 3, this.getSqlMetadataMaxRetry());
        }
        catch (CallbackFailedException e) {
            if (definitelyNotUpdated.get()) {
                return SegmentPublishResult.fail(e.getMessage());
            }
            throw e;
        }
    }

    @VisibleForTesting
    public int getSqlMetadataMaxRetry() {
        return 10;
    }

    @Override
    public Map<SegmentCreateRequest, SegmentIdWithShardSpec> allocatePendingSegments(String dataSource, Interval allocateInterval, boolean skipSegmentLineageCheck, List<SegmentCreateRequest> requests, boolean reduceMetadataIO) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        Preconditions.checkNotNull((Object)allocateInterval, (Object)"interval");
        Interval interval = allocateInterval.withChronology((Chronology)ISOChronology.getInstanceUTC());
        return (Map)this.connector.retryWithHandle(handle -> this.allocatePendingSegments(handle, dataSource, interval, skipSegmentLineageCheck, requests, reduceMetadataIO));
    }

    @Override
    @Nullable
    public SegmentIdWithShardSpec allocatePendingSegment(String dataSource, Interval interval, boolean skipSegmentLineageCheck, SegmentCreateRequest createRequest) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        Preconditions.checkNotNull((Object)interval, (Object)"interval");
        Interval allocateInterval = interval.withChronology((Chronology)ISOChronology.getInstanceUTC());
        return (SegmentIdWithShardSpec)this.connector.retryWithHandle(handle -> {
            List existingChunks = this.getTimelineForIntervalsWithHandle(handle, dataSource, (List<Interval>)ImmutableList.of((Object)interval)).lookup(interval);
            if (existingChunks.size() > 1) {
                log.warn("Cannot allocate new segment for dataSource[%s], interval[%s] as it already has [%,d] versions.", new Object[]{dataSource, interval, existingChunks.size()});
                return null;
            }
            if (skipSegmentLineageCheck) {
                return this.allocatePendingSegment(handle, dataSource, allocateInterval, createRequest, existingChunks);
            }
            return this.allocatePendingSegmentWithSegmentLineageCheck(handle, dataSource, allocateInterval, createRequest, existingChunks);
        });
    }

    @Override
    public List<PendingSegmentRecord> upgradePendingSegmentsOverlappingWith(Set<DataSegment> replaceSegments) {
        if (replaceSegments.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Interval, DataSegment> replaceIntervalToMaxId = new HashMap<Interval, DataSegment>();
        for (DataSegment segment : replaceSegments) {
            DataSegment committedMaxId = (DataSegment)replaceIntervalToMaxId.get(segment.getInterval());
            if (committedMaxId != null && committedMaxId.getShardSpec().getPartitionNum() >= segment.getShardSpec().getPartitionNum()) continue;
            replaceIntervalToMaxId.put(segment.getInterval(), segment);
        }
        String datasource = replaceSegments.iterator().next().getDataSource();
        return (List)this.connector.retryWithHandle(handle -> this.upgradePendingSegments(handle, datasource, replaceIntervalToMaxId));
    }

    private List<PendingSegmentRecord> upgradePendingSegments(Handle handle, String datasource, Map<Interval, DataSegment> replaceIntervalToMaxId) throws JsonProcessingException {
        ArrayList<PendingSegmentRecord> upgradedPendingSegments = new ArrayList<PendingSegmentRecord>();
        for (Map.Entry<Interval, DataSegment> entry : replaceIntervalToMaxId.entrySet()) {
            Interval replaceInterval = entry.getKey();
            DataSegment maxSegmentId = entry.getValue();
            String replaceVersion = maxSegmentId.getVersion();
            int numCorePartitions = maxSegmentId.getShardSpec().getNumCorePartitions();
            int currentPartitionNumber = maxSegmentId.getShardSpec().getPartitionNum();
            List<PendingSegmentRecord> overlappingPendingSegments = this.getPendingSegmentsForInterval(handle, datasource, replaceInterval);
            for (PendingSegmentRecord overlappingPendingSegment : overlappingPendingSegments) {
                SegmentIdWithShardSpec pendingSegmentId = overlappingPendingSegment.getId();
                if (!this.shouldUpgradePendingSegment(overlappingPendingSegment, replaceInterval, replaceVersion)) continue;
                SegmentIdWithShardSpec newId = new SegmentIdWithShardSpec(datasource, replaceInterval, replaceVersion, (ShardSpec)new NumberedShardSpec(++currentPartitionNumber, numCorePartitions));
                upgradedPendingSegments.add(new PendingSegmentRecord(newId, UPGRADED_PENDING_SEGMENT_PREFIX + replaceVersion, pendingSegmentId.toString(), pendingSegmentId.toString(), overlappingPendingSegment.getTaskAllocatorId()));
            }
        }
        int numInsertedPendingSegments = this.insertPendingSegmentsIntoMetastore(handle, upgradedPendingSegments, datasource, false);
        log.info("Inserted total [%d] new versions for [%d] pending segments.", new Object[]{numInsertedPendingSegments, upgradedPendingSegments.size()});
        return upgradedPendingSegments;
    }

    private boolean shouldUpgradePendingSegment(PendingSegmentRecord pendingSegment, Interval replaceInterval, String replaceVersion) {
        if (pendingSegment.getTaskAllocatorId() == null) {
            return false;
        }
        if (pendingSegment.getId().getVersion().compareTo(replaceVersion) >= 0) {
            return false;
        }
        if (!replaceInterval.contains((ReadableInterval)pendingSegment.getId().getInterval())) {
            SegmentId pendingSegmentId = pendingSegment.getId().asSegmentId();
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.UNSUPPORTED).build("Replacing with a finer segment granularity than a concurrent append is unsupported. Cannot upgrade pendingSegment[%s] to version[%s] as the replace interval[%s] does not fully contain the pendingSegment interval[%s].", new Object[]{pendingSegmentId, replaceVersion, replaceInterval, pendingSegmentId.getInterval()});
        }
        return pendingSegment.getSequenceName() == null || !pendingSegment.getSequenceName().startsWith(UPGRADED_PENDING_SEGMENT_PREFIX);
    }

    @Nullable
    private SegmentIdWithShardSpec allocatePendingSegmentWithSegmentLineageCheck(Handle handle, String dataSource, Interval interval, SegmentCreateRequest createRequest, List<TimelineObjectHolder<String, DataSegment>> existingChunks) throws IOException {
        String sql = StringUtils.format((String)"SELECT payload FROM %s WHERE dataSource = :dataSource AND sequence_name = :sequence_name AND sequence_prev_id = :sequence_prev_id", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable()});
        Query query = (Query)((Query)((Query)handle.createQuery(sql).bind("dataSource", dataSource)).bind("sequence_name", createRequest.getSequenceName())).bind("sequence_prev_id", createRequest.getPreviousSegmentId());
        String usedSegmentVersion = existingChunks.isEmpty() ? null : (String)existingChunks.get(0).getVersion();
        CheckExistingSegmentIdResult result = this.findExistingPendingSegment((Query<Map<String, Object>>)query, interval, createRequest.getSequenceName(), createRequest.getPreviousSegmentId(), usedSegmentVersion);
        if (result.found) {
            return result.segmentIdentifier;
        }
        SegmentIdWithShardSpec newIdentifier = this.createNewPendingSegment(handle, dataSource, interval, createRequest.getPartialShardSpec(), createRequest.getVersion(), existingChunks);
        if (newIdentifier == null) {
            return null;
        }
        String sequenceNamePrevIdSha1 = BaseEncoding.base16().encode(Hashing.sha1().newHasher().putBytes(StringUtils.toUtf8((String)createRequest.getSequenceName())).putByte((byte)-1).putBytes(StringUtils.toUtf8((String)createRequest.getPreviousSegmentId())).putByte((byte)-1).putBytes(StringUtils.toUtf8((String)newIdentifier.getVersion())).hash().asBytes());
        this.insertPendingSegmentIntoMetastore(handle, newIdentifier, dataSource, interval, createRequest.getPreviousSegmentId(), createRequest.getSequenceName(), sequenceNamePrevIdSha1, createRequest.getTaskAllocatorId());
        return newIdentifier;
    }

    @Override
    public SegmentTimeline getSegmentTimelineForAllocation(String dataSource, Interval interval, boolean reduceMetadataIO) {
        return (SegmentTimeline)this.connector.retryWithHandle(handle -> {
            if (reduceMetadataIO) {
                return SegmentTimeline.forSegments(this.retrieveUsedSegmentsForAllocation(handle, dataSource, interval));
            }
            return this.getTimelineForIntervalsWithHandle(handle, dataSource, Collections.singletonList(interval));
        });
    }

    private Map<SegmentCreateRequest, SegmentIdWithShardSpec> allocatePendingSegments(Handle handle, String dataSource, Interval interval, boolean skipSegmentLineageCheck, List<SegmentCreateRequest> requests, boolean reduceMetadataIO) throws IOException {
        List existingChunks = this.getSegmentTimelineForAllocation(dataSource, interval, reduceMetadataIO).lookup(interval);
        if (existingChunks.size() > 1) {
            log.warn("Cannot allocate new segments for dataSource[%s], interval[%s] as interval already has [%,d] chunks.", new Object[]{dataSource, interval, existingChunks.size()});
            return Collections.emptyMap();
        }
        String existingVersion = existingChunks.isEmpty() ? null : (String)((TimelineObjectHolder)existingChunks.get(0)).getVersion();
        Map<SegmentCreateRequest, CheckExistingSegmentIdResult> existingSegmentIds = skipSegmentLineageCheck ? this.getExistingSegmentIdsSkipLineageCheck(handle, dataSource, interval, existingVersion, requests) : this.getExistingSegmentIdsWithLineageCheck(handle, dataSource, interval, existingVersion, requests);
        HashMap<SegmentCreateRequest, SegmentIdWithShardSpec> allocatedSegmentIds = new HashMap<SegmentCreateRequest, SegmentIdWithShardSpec>();
        ArrayList<SegmentCreateRequest> requestsForNewSegments = new ArrayList<SegmentCreateRequest>();
        for (SegmentCreateRequest request : requests) {
            CheckExistingSegmentIdResult existingSegmentId = existingSegmentIds.get(request);
            if (existingSegmentId == null || !existingSegmentId.found) {
                requestsForNewSegments.add(request);
                continue;
            }
            if (existingSegmentId.segmentIdentifier != null) {
                log.info("Found valid existing segment [%s] for request.", new Object[]{existingSegmentId.segmentIdentifier});
                allocatedSegmentIds.put(request, existingSegmentId.segmentIdentifier);
                continue;
            }
            log.info("Found clashing existing segment [%s] for request.", new Object[]{existingSegmentId});
        }
        Map<SegmentCreateRequest, PendingSegmentRecord> createdSegments = this.createNewSegments(handle, dataSource, interval, skipSegmentLineageCheck, existingChunks, requestsForNewSegments);
        this.insertPendingSegmentsIntoMetastore(handle, (List<PendingSegmentRecord>)ImmutableList.copyOf(createdSegments.values()), dataSource, skipSegmentLineageCheck);
        for (Map.Entry<SegmentCreateRequest, PendingSegmentRecord> entry : createdSegments.entrySet()) {
            allocatedSegmentIds.put(entry.getKey(), entry.getValue().getId());
        }
        return allocatedSegmentIds;
    }

    @Nullable
    private SegmentIdWithShardSpec allocatePendingSegment(Handle handle, String dataSource, Interval interval, SegmentCreateRequest createRequest, List<TimelineObjectHolder<String, DataSegment>> existingChunks) throws IOException {
        String sql = StringUtils.format((String)"SELECT payload FROM %s WHERE dataSource = :dataSource AND sequence_name = :sequence_name AND start = :start AND %2$send%2$s = :end", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable(), this.connector.getQuoteString()});
        Query query = (Query)((Query)((Query)((Query)handle.createQuery(sql).bind("dataSource", dataSource)).bind("sequence_name", createRequest.getSequenceName())).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString());
        CheckExistingSegmentIdResult result = this.findExistingPendingSegment((Query<Map<String, Object>>)query, interval, createRequest.getSequenceName(), null, existingChunks.isEmpty() ? null : (String)existingChunks.get(0).getVersion());
        if (result.found) {
            return result.segmentIdentifier;
        }
        SegmentIdWithShardSpec newIdentifier = this.createNewPendingSegment(handle, dataSource, interval, createRequest.getPartialShardSpec(), createRequest.getVersion(), existingChunks);
        if (newIdentifier == null) {
            return null;
        }
        String sequenceNamePrevIdSha1 = BaseEncoding.base16().encode(Hashing.sha1().newHasher().putBytes(StringUtils.toUtf8((String)createRequest.getSequenceName())).putByte((byte)-1).putLong(interval.getStartMillis()).putLong(interval.getEndMillis()).putByte((byte)-1).putBytes(StringUtils.toUtf8((String)newIdentifier.getVersion())).hash().asBytes());
        this.insertPendingSegmentIntoMetastore(handle, newIdentifier, dataSource, interval, "", createRequest.getSequenceName(), sequenceNamePrevIdSha1, createRequest.getTaskAllocatorId());
        log.info("Created new pending segment[%s] for datasource[%s], interval[%s].", new Object[]{newIdentifier, dataSource, interval});
        return newIdentifier;
    }

    private Map<SegmentCreateRequest, CheckExistingSegmentIdResult> getExistingSegmentIdsSkipLineageCheck(Handle handle, String dataSource, Interval interval, String usedSegmentVersion, List<SegmentCreateRequest> requests) throws IOException {
        Query query = (Query)((Query)((Query)handle.createQuery(StringUtils.format((String)"SELECT sequence_name, payload FROM %s WHERE dataSource = :dataSource AND start = :start AND %2$send%2$s = :end", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable(), this.connector.getQuoteString()})).bind("dataSource", dataSource)).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString());
        ResultIterator dbSegments = query.map((index, r, ctx) -> PendingSegmentsRecord.fromResultSet(r)).iterator();
        HashMap<String, SegmentIdWithShardSpec> sequenceToSegmentId = new HashMap<String, SegmentIdWithShardSpec>();
        while (dbSegments.hasNext()) {
            PendingSegmentsRecord record = (PendingSegmentsRecord)dbSegments.next();
            SegmentIdWithShardSpec segmentId = (SegmentIdWithShardSpec)this.jsonMapper.readValue(record.getPayload(), SegmentIdWithShardSpec.class);
            if (usedSegmentVersion != null && !segmentId.getVersion().equals(usedSegmentVersion)) continue;
            sequenceToSegmentId.put(record.getSequenceName(), segmentId);
        }
        HashMap<SegmentCreateRequest, CheckExistingSegmentIdResult> requestToResult = new HashMap<SegmentCreateRequest, CheckExistingSegmentIdResult>();
        Iterator<SegmentCreateRequest> iterator = requests.iterator();
        while (iterator.hasNext()) {
            SegmentCreateRequest request;
            SegmentIdWithShardSpec segmentId = (SegmentIdWithShardSpec)sequenceToSegmentId.get((request = iterator.next()).getSequenceName());
            requestToResult.put(request, new CheckExistingSegmentIdResult(segmentId != null, segmentId));
        }
        return requestToResult;
    }

    private Map<SegmentCreateRequest, CheckExistingSegmentIdResult> getExistingSegmentIdsWithLineageCheck(Handle handle, String dataSource, Interval interval, String usedSegmentVersion, List<SegmentCreateRequest> requests) throws IOException {
        String sql = StringUtils.format((String)"SELECT payload FROM %s WHERE dataSource = :dataSource AND sequence_name = :sequence_name AND sequence_prev_id = :sequence_prev_id", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable()});
        HashMap<SegmentCreateRequest, CheckExistingSegmentIdResult> requestToResult = new HashMap<SegmentCreateRequest, CheckExistingSegmentIdResult>();
        for (SegmentCreateRequest request : requests) {
            CheckExistingSegmentIdResult result = this.findExistingPendingSegment((Query<Map<String, Object>>)((Query)((Query)((Query)handle.createQuery(sql).bind("dataSource", dataSource)).bind("sequence_name", request.getSequenceName())).bind("sequence_prev_id", request.getPreviousSegmentId())), interval, request.getSequenceName(), request.getPreviousSegmentId(), usedSegmentVersion);
            requestToResult.put(request, result);
        }
        return requestToResult;
    }

    private CheckExistingSegmentIdResult findExistingPendingSegment(Query<Map<String, Object>> query, Interval interval, String sequenceName, @Nullable String previousSegmentId, @Nullable String usedSegmentVersion) throws IOException {
        List records = query.map((ResultSetMapper)ByteArrayMapper.FIRST).list();
        if (records.isEmpty()) {
            return new CheckExistingSegmentIdResult(false, null);
        }
        for (byte[] record : records) {
            SegmentIdWithShardSpec pendingSegment = (SegmentIdWithShardSpec)this.jsonMapper.readValue(record, SegmentIdWithShardSpec.class);
            if (usedSegmentVersion != null && !pendingSegment.getVersion().equals(usedSegmentVersion)) continue;
            if (pendingSegment.getInterval().isEqual((ReadableInterval)interval)) {
                log.info("Found existing pending segment[%s] for sequence[%s], previous segment[%s], version[%s] in DB", new Object[]{pendingSegment, sequenceName, previousSegmentId, usedSegmentVersion});
                return new CheckExistingSegmentIdResult(true, pendingSegment);
            }
            log.warn("Cannot use existing pending segment [%s] for sequence[%s], previous segment[%s] in DB as it does not match requested interval[%s], version[%s].", new Object[]{pendingSegment, sequenceName, previousSegmentId, interval, usedSegmentVersion});
            return new CheckExistingSegmentIdResult(true, null);
        }
        return new CheckExistingSegmentIdResult(false, null);
    }

    private int deletePendingSegmentsById(Handle handle, String datasource, List<String> pendingSegmentIds) {
        if (pendingSegmentIds.isEmpty()) {
            return 0;
        }
        Update query = (Update)handle.createStatement(StringUtils.format((String)"DELETE FROM %s WHERE dataSource = :dataSource %s", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable(), SqlSegmentsMetadataQuery.getParameterizedInConditionForColumn("id", pendingSegmentIds)})).bind("dataSource", datasource);
        SqlSegmentsMetadataQuery.bindColumnValuesToQueryWithInCondition("id", pendingSegmentIds, query);
        return query.execute();
    }

    private SegmentPublishResult commitAppendSegmentsAndMetadataInTransaction(Set<DataSegment> appendSegments, Map<DataSegment, ReplaceTaskLock> appendSegmentToReplaceLock, @Nullable DataSourceMetadata startMetadata, @Nullable DataSourceMetadata endMetadata, String taskAllocatorId, @Nullable SegmentSchemaMapping segmentSchemaMapping) {
        this.verifySegmentsToCommit(appendSegments);
        if (startMetadata == null && endMetadata != null || startMetadata != null && endMetadata == null) {
            throw new IllegalArgumentException("start/end metadata pair must be either null or non-null");
        }
        String dataSource = appendSegments.iterator().next().getDataSource();
        List segmentIdsForNewVersions = (List)this.connector.retryTransaction((handle, transactionStatus) -> this.getPendingSegmentsForTaskAllocatorId(handle, dataSource, taskAllocatorId), 0, 10);
        HashSet<DataSegment> allSegmentsToInsert = new HashSet<DataSegment>(appendSegments);
        HashMap newVersionSegmentToParent = new HashMap();
        HashMap segmentIdMap = new HashMap();
        HashMap upgradedFromSegmentIdMap = new HashMap();
        appendSegments.forEach(segment -> segmentIdMap.put(segment.getId().toString(), segment));
        segmentIdsForNewVersions.forEach(pendingSegment -> {
            if (segmentIdMap.containsKey(pendingSegment.getUpgradedFromSegmentId())) {
                DataSegment oldSegment = (DataSegment)segmentIdMap.get(pendingSegment.getUpgradedFromSegmentId());
                SegmentId newVersionSegmentId = pendingSegment.getId().asSegmentId();
                newVersionSegmentToParent.put(newVersionSegmentId, oldSegment.getId());
                upgradedFromSegmentIdMap.put(newVersionSegmentId.toString(), oldSegment.getId().toString());
                allSegmentsToInsert.add(new DataSegment(pendingSegment.getId().asSegmentId(), oldSegment.getLoadSpec(), oldSegment.getDimensions(), oldSegment.getMetrics(), pendingSegment.getId().getShardSpec(), oldSegment.getLastCompactionState(), oldSegment.getBinaryVersion(), oldSegment.getSize()));
            }
        });
        AtomicBoolean metadataNotUpdated = new AtomicBoolean(false);
        try {
            return (SegmentPublishResult)this.connector.retryTransaction((handle, transactionStatus) -> {
                DataStoreMetadataUpdateResult metadataUpdateResult;
                metadataNotUpdated.set(false);
                if (startMetadata != null && (metadataUpdateResult = this.updateDataSourceMetadataWithHandle(handle, dataSource, startMetadata, endMetadata)).isFailed()) {
                    transactionStatus.setRollbackOnly();
                    metadataNotUpdated.set(true);
                    if (metadataUpdateResult.canRetry()) {
                        throw new RetryTransactionException(metadataUpdateResult.getErrorMsg());
                    }
                    throw new RuntimeException(metadataUpdateResult.getErrorMsg());
                }
                this.insertIntoUpgradeSegmentsTable(handle, appendSegmentToReplaceLock);
                List pendingSegmentIdBatches = Lists.partition(allSegmentsToInsert.stream().map(pendingSegment -> pendingSegment.getId().toString()).collect(Collectors.toList()), (int)100);
                int numDeletedPendingSegments = 0;
                for (List pendingSegmentIdBatch : pendingSegmentIdBatches) {
                    numDeletedPendingSegments += this.deletePendingSegmentsById(handle, dataSource, pendingSegmentIdBatch);
                }
                log.info("Deleted [%d] entries from pending segments table upon commit.", new Object[]{numDeletedPendingSegments});
                return SegmentPublishResult.ok(this.insertSegments(handle, allSegmentsToInsert, segmentSchemaMapping, Collections.emptyMap(), newVersionSegmentToParent, upgradedFromSegmentIdMap));
            }, 3, this.getSqlMetadataMaxRetry());
        }
        catch (CallbackFailedException e) {
            if (metadataNotUpdated.get()) {
                return SegmentPublishResult.fail(e.getMessage());
            }
            throw e;
        }
    }

    @VisibleForTesting
    int insertPendingSegmentsIntoMetastore(Handle handle, List<PendingSegmentRecord> pendingSegments, String dataSource, boolean skipSegmentLineageCheck) throws JsonProcessingException {
        PreparedBatch insertBatch = handle.prepareBatch(StringUtils.format((String)"INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, sequence_name, sequence_prev_id, sequence_name_prev_id_sha1, payload, task_allocator_id, upgraded_from_segment_id) VALUES (:id, :dataSource, :created_date, :start, :end, :sequence_name, :sequence_prev_id, :sequence_name_prev_id_sha1, :payload, :task_allocator_id, :upgraded_from_segment_id)", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable(), this.connector.getQuoteString()}));
        String now = DateTimes.nowUtc().toString();
        HashSet<SegmentIdWithShardSpec> processedSegmentIds = new HashSet<SegmentIdWithShardSpec>();
        for (PendingSegmentRecord pendingSegment : pendingSegments) {
            SegmentIdWithShardSpec segmentId = pendingSegment.getId();
            if (processedSegmentIds.contains(segmentId)) continue;
            Interval interval = segmentId.getInterval();
            ((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)insertBatch.add().bind("id", segmentId.toString())).bind("dataSource", dataSource)).bind("created_date", now)).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString())).bind("sequence_name", pendingSegment.getSequenceName())).bind("sequence_prev_id", pendingSegment.getSequencePrevId())).bind("sequence_name_prev_id_sha1", pendingSegment.computeSequenceNamePrevIdSha1(skipSegmentLineageCheck))).bind("payload", this.jsonMapper.writeValueAsBytes((Object)segmentId))).bind("task_allocator_id", pendingSegment.getTaskAllocatorId())).bind("upgraded_from_segment_id", pendingSegment.getUpgradedFromSegmentId());
            processedSegmentIds.add(segmentId);
        }
        int[] updated = insertBatch.execute();
        return Arrays.stream(updated).sum();
    }

    private void insertPendingSegmentIntoMetastore(Handle handle, SegmentIdWithShardSpec newIdentifier, String dataSource, Interval interval, String previousSegmentId, String sequenceName, String sequenceNamePrevIdSha1, String taskAllocatorId) throws JsonProcessingException {
        ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(StringUtils.format((String)"INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, sequence_name, sequence_prev_id, sequence_name_prev_id_sha1, payload, task_allocator_id) VALUES (:id, :dataSource, :created_date, :start, :end, :sequence_name, :sequence_prev_id, :sequence_name_prev_id_sha1, :payload, :task_allocator_id)", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable(), this.connector.getQuoteString()})).bind("id", newIdentifier.toString())).bind("dataSource", dataSource)).bind("created_date", DateTimes.nowUtc().toString())).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString())).bind("sequence_name", sequenceName)).bind("sequence_prev_id", previousSegmentId)).bind("sequence_name_prev_id_sha1", sequenceNamePrevIdSha1)).bind("payload", this.jsonMapper.writeValueAsBytes((Object)newIdentifier))).bind("task_allocator_id", taskAllocatorId)).execute();
    }

    private Map<SegmentCreateRequest, PendingSegmentRecord> createNewSegments(Handle handle, String dataSource, Interval interval, boolean skipSegmentLineageCheck, List<TimelineObjectHolder<String, DataSegment>> existingChunks, List<SegmentCreateRequest> requests) {
        String versionOfExistingChunk;
        if (requests.isEmpty()) {
            return Collections.emptyMap();
        }
        PartialShardSpec partialShardSpec = requests.get(0).getPartialShardSpec();
        SegmentIdWithShardSpec committedMaxId = null;
        if (existingChunks.isEmpty()) {
            versionOfExistingChunk = null;
        } else {
            TimelineObjectHolder existingHolder = (TimelineObjectHolder)Iterables.getOnlyElement(existingChunks);
            versionOfExistingChunk = (String)existingHolder.getVersion();
            for (DataSegment segment2 : FluentIterable.from((Iterable)existingHolder.getObject()).transform(PartitionChunk::getObject).filter(segment -> segment.getShardSpec().sharePartitionSpace(partialShardSpec))) {
                if (committedMaxId != null && committedMaxId.getShardSpec().getPartitionNum() >= segment2.getShardSpec().getPartitionNum()) continue;
                committedMaxId = SegmentIdWithShardSpec.fromDataSegment(segment2);
            }
        }
        Set<SegmentIdWithShardSpec> pendingSegments = this.getPendingSegmentsForInterval(handle, dataSource, interval).stream().map(PendingSegmentRecord::getId).collect(Collectors.toSet());
        HashMap<SegmentCreateRequest, PendingSegmentRecord> createdSegments = new HashMap<SegmentCreateRequest, PendingSegmentRecord>();
        HashMap<UniqueAllocateRequest, PendingSegmentRecord> uniqueRequestToSegment = new HashMap<UniqueAllocateRequest, PendingSegmentRecord>();
        for (SegmentCreateRequest request : requests) {
            PendingSegmentRecord createdSegment;
            UniqueAllocateRequest uniqueRequest = new UniqueAllocateRequest(interval, request, skipSegmentLineageCheck);
            if (uniqueRequestToSegment.containsKey(uniqueRequest)) {
                createdSegment = (PendingSegmentRecord)uniqueRequestToSegment.get(uniqueRequest);
            } else {
                createdSegment = this.createNewPendingSegment(request, dataSource, interval, versionOfExistingChunk, committedMaxId, pendingSegments);
                if (createdSegment != null) {
                    pendingSegments.add(createdSegment.getId());
                    uniqueRequestToSegment.put(uniqueRequest, createdSegment);
                    log.info("Created new segment[%s]", new Object[]{createdSegment.getId()});
                }
            }
            if (createdSegment == null) continue;
            createdSegments.put(request, createdSegment);
        }
        log.info("Created [%d] new segments for [%d] allocate requests.", new Object[]{uniqueRequestToSegment.size(), requests.size()});
        return createdSegments;
    }

    @Nullable
    private PendingSegmentRecord createNewPendingSegment(SegmentCreateRequest request, String dataSource, Interval interval, String versionOfExistingChunk, SegmentIdWithShardSpec committedMaxId, Set<SegmentIdWithShardSpec> pendingSegments) {
        PartialShardSpec partialShardSpec = request.getPartialShardSpec();
        String existingVersion = request.getVersion();
        HashSet<SegmentIdWithShardSpec> mutablePendingSegments = new HashSet<SegmentIdWithShardSpec>(pendingSegments);
        if (committedMaxId != null) {
            mutablePendingSegments.add(committedMaxId);
        }
        SegmentIdWithShardSpec overallMaxId = mutablePendingSegments.stream().filter(id -> id.getShardSpec().sharePartitionSpace(partialShardSpec)).filter(id -> versionOfExistingChunk == null || id.getVersion().equals(versionOfExistingChunk)).max(Comparator.comparing(SegmentIdWithShardSpec::getVersion).thenComparing(id -> id.getShardSpec().getPartitionNum())).orElse(null);
        String newSegmentVersion = versionOfExistingChunk != null ? versionOfExistingChunk : (overallMaxId != null ? overallMaxId.getVersion() : null);
        if (overallMaxId == null) {
            int newPartitionId = partialShardSpec.useNonRootGenerationPartitionSpace() ? 32768 : 0;
            String version = newSegmentVersion == null ? existingVersion : newSegmentVersion;
            SegmentIdWithShardSpec pendingSegmentId = new SegmentIdWithShardSpec(dataSource, interval, version, partialShardSpec.complete(this.jsonMapper, newPartitionId, 0));
            return new PendingSegmentRecord(pendingSegmentId, request.getSequenceName(), request.getPreviousSegmentId(), null, request.getTaskAllocatorId());
        }
        if (!overallMaxId.getInterval().equals((Object)interval)) {
            log.warn("Cannot allocate new segment for dataSource[%s], interval[%s], existingVersion[%s]: conflicting segment[%s].", new Object[]{dataSource, interval, existingVersion, overallMaxId});
            return null;
        }
        if (committedMaxId != null && committedMaxId.getShardSpec().getNumCorePartitions() == -1) {
            log.warn("Cannot allocate new segment because of unknown core partition size of segment[%s], shardSpec[%s]", new Object[]{committedMaxId, committedMaxId.getShardSpec()});
            return null;
        }
        SegmentIdWithShardSpec pendingSegmentId = new SegmentIdWithShardSpec(dataSource, interval, (String)Preconditions.checkNotNull((Object)newSegmentVersion, (Object)"newSegmentVersion"), partialShardSpec.complete(this.jsonMapper, overallMaxId.getShardSpec().getPartitionNum() + 1, committedMaxId == null ? 0 : committedMaxId.getShardSpec().getNumCorePartitions()));
        return new PendingSegmentRecord(this.getTrueAllocatedId(pendingSegmentId), request.getSequenceName(), request.getPreviousSegmentId(), null, request.getTaskAllocatorId());
    }

    @Nullable
    private SegmentIdWithShardSpec createNewPendingSegment(Handle handle, String dataSource, Interval interval, PartialShardSpec partialShardSpec, String existingVersion, List<TimelineObjectHolder<String, DataSegment>> existingChunks) {
        String versionOfExistingChunk;
        SegmentIdWithShardSpec committedMaxId = null;
        if (existingChunks.isEmpty()) {
            versionOfExistingChunk = null;
        } else {
            TimelineObjectHolder existingHolder = (TimelineObjectHolder)Iterables.getOnlyElement(existingChunks);
            versionOfExistingChunk = (String)existingHolder.getVersion();
            for (DataSegment segment2 : FluentIterable.from((Iterable)existingHolder.getObject()).transform(PartitionChunk::getObject).filter(segment -> segment.getShardSpec().sharePartitionSpace(partialShardSpec))) {
                if (committedMaxId != null && committedMaxId.getShardSpec().getPartitionNum() >= segment2.getShardSpec().getPartitionNum()) continue;
                committedMaxId = SegmentIdWithShardSpec.fromDataSegment(segment2);
            }
        }
        Set pendings = this.getPendingSegmentsForInterval(handle, dataSource, interval).stream().map(PendingSegmentRecord::getId).collect(Collectors.toSet());
        if (committedMaxId != null) {
            pendings.add(committedMaxId);
        }
        SegmentIdWithShardSpec overallMaxId = pendings.stream().filter(id -> id.getShardSpec().sharePartitionSpace(partialShardSpec)).filter(id -> versionOfExistingChunk == null || id.getVersion().equals(versionOfExistingChunk)).max(Comparator.comparing(SegmentIdWithShardSpec::getVersion).thenComparing(id -> id.getShardSpec().getPartitionNum())).orElse(null);
        String newSegmentVersion = versionOfExistingChunk != null ? versionOfExistingChunk : (overallMaxId != null ? overallMaxId.getVersion() : null);
        if (overallMaxId == null) {
            int newPartitionId = partialShardSpec.useNonRootGenerationPartitionSpace() ? 32768 : 0;
            String version = newSegmentVersion == null ? existingVersion : newSegmentVersion;
            return new SegmentIdWithShardSpec(dataSource, interval, version, partialShardSpec.complete(this.jsonMapper, newPartitionId, 0));
        }
        if (!overallMaxId.getInterval().equals((Object)interval)) {
            log.warn("Cannot allocate new segment for dataSource[%s], interval[%s], existingVersion[%s]: conflicting segment[%s].", new Object[]{dataSource, interval, existingVersion, overallMaxId});
            return null;
        }
        if (committedMaxId != null && committedMaxId.getShardSpec().getNumCorePartitions() == -1) {
            log.warn("Cannot allocate new segment because of unknown core partition size of segment[%s], shardSpec[%s]", new Object[]{committedMaxId, committedMaxId.getShardSpec()});
            return null;
        }
        SegmentIdWithShardSpec allocatedId = new SegmentIdWithShardSpec(dataSource, interval, (String)Preconditions.checkNotNull((Object)newSegmentVersion, (Object)"newSegmentVersion"), partialShardSpec.complete(this.jsonMapper, overallMaxId.getShardSpec().getPartitionNum() + 1, committedMaxId == null ? 0 : committedMaxId.getShardSpec().getNumCorePartitions()));
        return this.getTrueAllocatedId(allocatedId);
    }

    private SegmentIdWithShardSpec getTrueAllocatedId(SegmentIdWithShardSpec allocatedId) {
        if (this.retrieveSegmentForId(allocatedId.asSegmentId().toString(), true) == null) {
            return allocatedId;
        }
        SegmentId unusedMaxId = this.getMaxIdOfUnusedSegment(allocatedId.getDataSource(), allocatedId.getInterval(), allocatedId.getVersion());
        if (unusedMaxId == null) {
            return allocatedId;
        }
        int maxPartitionNum = Math.max(allocatedId.getShardSpec().getPartitionNum(), unusedMaxId.getPartitionNum() + 1);
        return new SegmentIdWithShardSpec(allocatedId.getDataSource(), allocatedId.getInterval(), allocatedId.getVersion(), (ShardSpec)new NumberedShardSpec(maxPartitionNum, allocatedId.getShardSpec().getNumCorePartitions()));
    }

    @Nullable
    private SegmentId getMaxIdOfUnusedSegment(String datasource, Interval interval, String version) {
        List<String> unusedSegmentIds = this.retrieveUnusedSegmentIdsForExactIntervalAndVersion(datasource, interval, version);
        SegmentId unusedMaxId = null;
        int maxPartitionNum = -1;
        for (String id : unusedSegmentIds) {
            int partitionNum;
            SegmentId segmentId = SegmentId.tryParse((String)datasource, (String)id);
            if (segmentId == null || maxPartitionNum >= (partitionNum = segmentId.getPartitionNum())) continue;
            maxPartitionNum = partitionNum;
            unusedMaxId = segmentId;
        }
        return unusedMaxId;
    }

    @Override
    public int deletePendingSegmentsCreatedInInterval(String dataSource, Interval deleteInterval) {
        return (Integer)this.connector.getDBI().inTransaction((handle, status) -> ((Update)((Update)((Update)handle.createStatement(StringUtils.format((String)"DELETE FROM %s WHERE datasource = :dataSource AND created_date >= :start AND created_date < :end", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable()})).bind("dataSource", dataSource)).bind("start", deleteInterval.getStart().toString())).bind("end", deleteInterval.getEnd().toString())).execute());
    }

    @Override
    public int deletePendingSegments(String dataSource) {
        return (Integer)this.connector.getDBI().inTransaction((handle, status) -> ((Update)handle.createStatement(StringUtils.format((String)"DELETE FROM %s WHERE datasource = :dataSource", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable()})).bind("dataSource", dataSource)).execute());
    }

    private boolean shouldPersistSchema(SegmentSchemaMapping segmentSchemaMapping) {
        return this.schemaPersistEnabled && segmentSchemaMapping != null && segmentSchemaMapping.isNonEmpty();
    }

    private void persistSchema(Handle handle, Set<DataSegment> segments, SegmentSchemaMapping segmentSchemaMapping) throws JsonProcessingException {
        if (segmentSchemaMapping.getSchemaVersion() != 1) {
            log.error("Schema version [%d] doesn't match the current version [%d]. Not persisting this schema [%s]. Schema for this segment will be populated by the schema backfill job in Coordinator.", new Object[]{segmentSchemaMapping.getSchemaVersion(), 1, segmentSchemaMapping});
            return;
        }
        String dataSource = ((DataSegment)segments.stream().iterator().next()).getDataSource();
        this.segmentSchemaManager.persistSegmentSchema(handle, dataSource, segmentSchemaMapping.getSchemaVersion(), segmentSchemaMapping.getSchemaFingerprintToPayloadMap());
    }

    private Set<DataSegment> announceHistoricalSegmentBatch(Handle handle, Set<DataSegment> segments, Set<DataSegment> usedSegments, @Nullable SegmentSchemaMapping segmentSchemaMapping) throws IOException {
        HashSet<DataSegment> toInsertSegments = new HashSet<DataSegment>();
        try {
            boolean shouldPersistSchema = this.shouldPersistSchema(segmentSchemaMapping);
            if (shouldPersistSchema) {
                this.persistSchema(handle, segments, segmentSchemaMapping);
            }
            Set<String> existedSegments = this.segmentExistsBatch(handle, segments);
            log.info("Found these segments already exist in DB: %s", new Object[]{existedSegments});
            for (DataSegment segment : segments) {
                if (existedSegments.contains(segment.getId().toString())) continue;
                toInsertSegments.add(segment);
            }
            List partitionedSegments = Lists.partition(new ArrayList(toInsertSegments), (int)100);
            String now = DateTimes.nowUtc().toString();
            PreparedBatch preparedBatch = handle.prepareBatch(this.buildSqlToInsertSegments());
            for (List partition : partitionedSegments) {
                for (DataSegment segment : partition) {
                    String segmentId = segment.getId().toString();
                    PreparedBatchPart preparedBatchPart = (PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)preparedBatch.add().bind("id", segmentId)).bind("dataSource", segment.getDataSource())).bind("created_date", now)).bind("start", segment.getInterval().getStart().toString())).bind("end", segment.getInterval().getEnd().toString())).bind("partitioned", !(segment.getShardSpec() instanceof NoneShardSpec))).bind("version", segment.getVersion())).bind("used", usedSegments.contains(segment))).bind("payload", this.jsonMapper.writeValueAsBytes((Object)segment))).bind("used_status_last_updated", now)).bind("upgraded_from_segment_id", (String)null);
                    if (!this.schemaPersistEnabled) continue;
                    Long numRows = null;
                    String schemaFingerprint = null;
                    if (shouldPersistSchema && segmentSchemaMapping.getSegmentIdToMetadataMap().containsKey(segmentId)) {
                        SegmentMetadata segmentMetadata = (SegmentMetadata)segmentSchemaMapping.getSegmentIdToMetadataMap().get(segmentId);
                        numRows = segmentMetadata.getNumRows();
                        schemaFingerprint = segmentMetadata.getSchemaFingerprint();
                    }
                    ((PreparedBatchPart)preparedBatchPart.bind("num_rows", numRows)).bind("schema_fingerprint", schemaFingerprint);
                }
                int[] affectedRows = preparedBatch.execute();
                boolean succeeded = Arrays.stream(affectedRows).allMatch(eachAffectedRows -> eachAffectedRows == 1);
                if (succeeded) {
                    log.infoSegments((Collection)partition, "Published segments to DB");
                    continue;
                }
                List failedToPublish = IntStream.range(0, partition.size()).filter(i -> affectedRows[i] != 1).mapToObj(partition::get).collect(Collectors.toList());
                throw new ISE("Failed to publish segments to DB: %s", new Object[]{SegmentUtils.commaSeparatedIdentifiers(failedToPublish)});
            }
        }
        catch (Exception e) {
            log.errorSegments(segments, "Exception inserting segments");
            throw e;
        }
        return toInsertSegments;
    }

    private Set<DataSegmentPlus> createNewIdsOfAppendSegmentsAfterReplace(Handle handle, Set<DataSegment> replaceSegments, Set<ReplaceTaskLock> locksHeldByReplaceTask) {
        if (replaceSegments.isEmpty() || locksHeldByReplaceTask.isEmpty()) {
            return Collections.emptySet();
        }
        String datasource = replaceSegments.iterator().next().getDataSource();
        HashMap<Interval, Integer> intervalToNumCorePartitions = new HashMap<Interval, Integer>();
        HashMap<Interval, Integer> intervalToCurrentPartitionNum = new HashMap<Interval, Integer>();
        for (DataSegment segment : replaceSegments) {
            intervalToNumCorePartitions.put(segment.getInterval(), segment.getShardSpec().getNumCorePartitions());
            int partitionNum = segment.getShardSpec().getPartitionNum();
            intervalToCurrentPartitionNum.compute(segment.getInterval(), (i, value) -> value == null ? partitionNum : Math.max(value, partitionNum));
        }
        String taskId = locksHeldByReplaceTask.stream().map(ReplaceTaskLock::getSupervisorTaskId).findFirst().orElse(null);
        Map<String, String> upgradeSegmentToLockVersion = this.getAppendSegmentsCommittedDuringTask(handle, taskId);
        List<DataSegmentPlus> segmentsToUpgrade = this.retrieveSegmentsById(handle, datasource, upgradeSegmentToLockVersion.keySet());
        if (segmentsToUpgrade.isEmpty()) {
            return Collections.emptySet();
        }
        Set replaceIntervals = intervalToNumCorePartitions.keySet();
        HashSet<DataSegmentPlus> upgradedSegments = new HashSet<DataSegmentPlus>();
        for (DataSegmentPlus oldSegmentMetadata : segmentsToUpgrade) {
            DataSegment oldSegment = oldSegmentMetadata.getDataSegment();
            Interval oldInterval = oldSegment.getInterval();
            Interval newInterval = null;
            for (Interval replaceInterval : replaceIntervals) {
                if (replaceInterval.contains((ReadableInterval)oldInterval)) {
                    newInterval = replaceInterval;
                    break;
                }
                if (!replaceInterval.overlaps((ReadableInterval)oldInterval)) continue;
                String conflictingSegmentId = oldSegment.getId().toString();
                String upgradeVersion = upgradeSegmentToLockVersion.get(conflictingSegmentId);
                throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.UNSUPPORTED).build("Replacing with a finer segment granularity than a concurrent append is unsupported. Cannot upgrade segment[%s] to version[%s] as the replace interval[%s] does not fully contain the pending segment interval[%s].", new Object[]{conflictingSegmentId, upgradeVersion, replaceInterval, oldInterval});
            }
            if (newInterval == null) {
                newInterval = oldInterval;
            }
            int partitionNum = intervalToCurrentPartitionNum.compute(newInterval, (i, value) -> value == null ? 0 : value + 1);
            int numCorePartitions = (Integer)intervalToNumCorePartitions.get(newInterval);
            NumberedShardSpec shardSpec = new NumberedShardSpec(partitionNum, numCorePartitions);
            String lockVersion = upgradeSegmentToLockVersion.get(oldSegment.getId().toString());
            DataSegment dataSegment = DataSegment.builder((DataSegment)oldSegment).interval(newInterval).version(lockVersion).shardSpec((ShardSpec)shardSpec).build();
            String upgradedFromSegmentId = oldSegmentMetadata.getUpgradedFromSegmentId() == null ? oldSegmentMetadata.getDataSegment().getId().toString() : oldSegmentMetadata.getUpgradedFromSegmentId();
            upgradedSegments.add(new DataSegmentPlus(dataSegment, null, null, null, oldSegmentMetadata.getSchemaFingerprint(), oldSegmentMetadata.getNumRows(), upgradedFromSegmentId));
        }
        return upgradedSegments;
    }

    private void verifySegmentsToCommit(Collection<DataSegment> segments) {
        if (segments.isEmpty()) {
            throw new IllegalArgumentException("No segment to commit");
        }
        String dataSource = segments.iterator().next().getDataSource();
        for (DataSegment segment : segments) {
            if (dataSource.equals(segment.getDataSource())) continue;
            throw new IllegalArgumentException("Segments to commit must all belong to the same datasource");
        }
    }

    private Set<DataSegment> insertSegments(Handle handle, Set<DataSegment> segments, @Nullable SegmentSchemaMapping segmentSchemaMapping, Map<SegmentId, SegmentMetadata> upgradeSegmentMetadata, Map<SegmentId, SegmentId> newVersionForAppendToParent, Map<String, String> upgradedFromSegmentIdMap) throws IOException {
        if (this.shouldPersistSchema(segmentSchemaMapping)) {
            this.persistSchema(handle, segments, segmentSchemaMapping);
        }
        Set<String> existingSegmentIds = this.segmentExistsBatch(handle, segments);
        Set<DataSegment> segmentsToInsert = segments.stream().filter(s -> !existingSegmentIds.contains(s.getId().toString())).collect(Collectors.toSet());
        List partitionedSegments = Lists.partition(new ArrayList(segmentsToInsert), (int)100);
        String now = DateTimes.nowUtc().toString();
        PreparedBatch batch = handle.prepareBatch(this.buildSqlToInsertSegments());
        for (List partition : partitionedSegments) {
            for (DataSegment segment : partition) {
                PreparedBatchPart preparedBatchPart = (PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)batch.add().bind("id", segment.getId().toString())).bind("dataSource", segment.getDataSource())).bind("created_date", now)).bind("start", segment.getInterval().getStart().toString())).bind("end", segment.getInterval().getEnd().toString())).bind("partitioned", !(segment.getShardSpec() instanceof NoneShardSpec))).bind("version", segment.getVersion())).bind("used", true)).bind("payload", this.jsonMapper.writeValueAsBytes((Object)segment))).bind("used_status_last_updated", now)).bind("upgraded_from_segment_id", upgradedFromSegmentIdMap.get(segment.getId().toString()));
                if (!this.schemaPersistEnabled) continue;
                SegmentMetadata segmentMetadata = this.getSegmentMetadataFromSchemaMappingOrUpgradeMetadata(segment.getId(), segmentSchemaMapping, newVersionForAppendToParent, upgradeSegmentMetadata);
                Long numRows = null;
                String schemaFingerprint = null;
                if (segmentMetadata != null) {
                    numRows = segmentMetadata.getNumRows();
                    schemaFingerprint = segmentMetadata.getSchemaFingerprint();
                }
                ((PreparedBatchPart)preparedBatchPart.bind("num_rows", numRows)).bind("schema_fingerprint", schemaFingerprint);
            }
            int[] affectedRows = batch.execute();
            ArrayList<DataSegment> failedInserts = new ArrayList<DataSegment>();
            for (int i = 0; i < partition.size(); ++i) {
                if (affectedRows[i] == 1) continue;
                failedInserts.add((DataSegment)partition.get(i));
            }
            if (failedInserts.isEmpty()) {
                log.infoSegments((Collection)partition, "Published segments to DB");
                continue;
            }
            throw new ISE("Failed to publish segments to DB: %s", new Object[]{SegmentUtils.commaSeparatedIdentifiers(failedInserts)});
        }
        return segmentsToInsert;
    }

    @Nullable
    private SegmentMetadata getSegmentMetadataFromSchemaMappingOrUpgradeMetadata(SegmentId segmentId, SegmentSchemaMapping segmentSchemaMapping, Map<SegmentId, SegmentId> newVersionForAppendToParent, Map<SegmentId, SegmentMetadata> upgradeSegmentMetadata) {
        boolean upgradedAppendSegment;
        if (!this.shouldPersistSchema(segmentSchemaMapping)) {
            return null;
        }
        SegmentMetadata segmentMetadata = null;
        boolean presentInSchemaMetadata = segmentSchemaMapping.getSegmentIdToMetadataMap().containsKey(segmentId.toString());
        boolean bl = upgradedAppendSegment = newVersionForAppendToParent.containsKey(segmentId) && segmentSchemaMapping.getSegmentIdToMetadataMap().containsKey(newVersionForAppendToParent.get(segmentId).toString());
        if (presentInSchemaMetadata || upgradedAppendSegment) {
            String segmentIdToUse = presentInSchemaMetadata ? segmentId.toString() : newVersionForAppendToParent.get(segmentId).toString();
            segmentMetadata = (SegmentMetadata)segmentSchemaMapping.getSegmentIdToMetadataMap().get(segmentIdToUse);
        } else if (upgradeSegmentMetadata.containsKey(segmentId)) {
            segmentMetadata = upgradeSegmentMetadata.get(segmentId);
        }
        return segmentMetadata;
    }

    private void insertIntoUpgradeSegmentsTable(Handle handle, Map<DataSegment, ReplaceTaskLock> segmentToReplaceLock) {
        if (segmentToReplaceLock.isEmpty()) {
            return;
        }
        PreparedBatch batch = handle.prepareBatch(StringUtils.format((String)"INSERT INTO %1$s (task_id, segment_id, lock_version) VALUES (:task_id, :segment_id, :lock_version)", (Object[])new Object[]{this.dbTables.getUpgradeSegmentsTable()}));
        List partitions = Lists.partition(new ArrayList<Map.Entry<DataSegment, ReplaceTaskLock>>(segmentToReplaceLock.entrySet()), (int)100);
        for (List partition : partitions) {
            for (Map.Entry entry : partition) {
                DataSegment segment = (DataSegment)entry.getKey();
                ReplaceTaskLock lock = (ReplaceTaskLock)entry.getValue();
                ((PreparedBatchPart)((PreparedBatchPart)batch.add().bind("task_id", lock.getSupervisorTaskId())).bind("segment_id", segment.getId().toString())).bind("lock_version", lock.getVersion());
            }
            int[] affectedAppendRows = batch.execute();
            ArrayList<DataSegment> failedInserts = new ArrayList<DataSegment>();
            for (int i = 0; i < partition.size(); ++i) {
                if (affectedAppendRows[i] == 1) continue;
                failedInserts.add((DataSegment)((Map.Entry)partition.get(i)).getKey());
            }
            if (failedInserts.size() <= 0) continue;
            throw new ISE("Failed to insert upgrade segments in DB: %s", new Object[]{SegmentUtils.commaSeparatedIdentifiers(failedInserts)});
        }
    }

    private List<DataSegmentPlus> retrieveSegmentsById(Handle handle, String datasource, Set<String> segmentIds) {
        if (segmentIds.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.schemaPersistEnabled) {
            return SqlSegmentsMetadataQuery.forHandle(handle, this.connector, this.dbTables, this.jsonMapper).retrieveSegmentsWithSchemaById(datasource, segmentIds);
        }
        return SqlSegmentsMetadataQuery.forHandle(handle, this.connector, this.dbTables, this.jsonMapper).retrieveSegmentsById(datasource, segmentIds);
    }

    private String buildSqlToInsertSegments() {
        String insertStatement = "INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, partitioned, version, used, payload, used_status_last_updated, upgraded_from_segment_id %3$s) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload, :used_status_last_updated, :upgraded_from_segment_id %4$s)";
        if (this.schemaPersistEnabled) {
            return StringUtils.format((String)insertStatement, (Object[])new Object[]{this.dbTables.getSegmentsTable(), this.connector.getQuoteString(), ", schema_fingerprint, num_rows", ", :schema_fingerprint, :num_rows"});
        }
        return StringUtils.format((String)insertStatement, (Object[])new Object[]{this.dbTables.getSegmentsTable(), this.connector.getQuoteString(), "", ""});
    }

    private Map<String, String> getAppendSegmentsCommittedDuringTask(Handle handle, String taskId) {
        String sql = StringUtils.format((String)"SELECT segment_id, lock_version FROM %1$s WHERE task_id = :task_id", (Object[])new Object[]{this.dbTables.getUpgradeSegmentsTable()});
        ResultIterator resultIterator = ((Query)handle.createQuery(sql).bind("task_id", taskId)).map((index, r, ctx) -> Pair.of((Object)r.getString("segment_id"), (Object)r.getString("lock_version"))).iterator();
        HashMap<String, String> segmentIdToLockVersion = new HashMap<String, String>();
        while (resultIterator.hasNext()) {
            Pair result = (Pair)resultIterator.next();
            segmentIdToLockVersion.put((String)result.lhs, (String)result.rhs);
        }
        return segmentIdToLockVersion;
    }

    private Set<String> segmentExistsBatch(Handle handle, Set<DataSegment> segments) {
        HashSet<String> existedSegments = new HashSet<String>();
        List segmentsLists = Lists.partition(new ArrayList<DataSegment>(segments), (int)100);
        for (List segmentList : segmentsLists) {
            String segmentIds = segmentList.stream().map(segment -> "'" + StringUtils.escapeSql((String)segment.getId().toString()) + "'").collect(Collectors.joining(","));
            List existIds = handle.createQuery(StringUtils.format((String)"SELECT id FROM %s WHERE id in (%s)", (Object[])new Object[]{this.dbTables.getSegmentsTable(), segmentIds})).mapTo(String.class).list();
            existedSegments.addAll(existIds);
        }
        return existedSegments;
    }

    @Override
    @Nullable
    public DataSourceMetadata retrieveDataSourceMetadata(String dataSource) {
        byte[] bytes = this.connector.lookup(this.dbTables.getDataSourceTable(), "dataSource", "commit_metadata_payload", dataSource);
        if (bytes == null) {
            return null;
        }
        return (DataSourceMetadata)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])bytes, DataSourceMetadata.class);
    }

    @Nullable
    private byte[] retrieveDataSourceMetadataWithHandleAsBytes(Handle handle, String dataSource) {
        return this.connector.lookupWithHandle(handle, this.dbTables.getDataSourceTable(), "dataSource", "commit_metadata_payload", dataSource);
    }

    protected DataStoreMetadataUpdateResult updateDataSourceMetadataWithHandle(Handle handle, String dataSource, DataSourceMetadata startMetadata, DataSourceMetadata endMetadata) throws IOException {
        DataStoreMetadataUpdateResult retVal;
        boolean startMetadataMatchesExisting;
        DataSourceMetadata oldCommitMetadataFromDb;
        String oldCommitMetadataSha1FromDb;
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        Preconditions.checkNotNull((Object)startMetadata, (Object)"startMetadata");
        Preconditions.checkNotNull((Object)endMetadata, (Object)"endMetadata");
        byte[] oldCommitMetadataBytesFromDb = this.retrieveDataSourceMetadataWithHandleAsBytes(handle, dataSource);
        if (oldCommitMetadataBytesFromDb == null) {
            oldCommitMetadataSha1FromDb = null;
            oldCommitMetadataFromDb = null;
        } else {
            oldCommitMetadataSha1FromDb = BaseEncoding.base16().encode(Hashing.sha1().hashBytes(oldCommitMetadataBytesFromDb).asBytes());
            oldCommitMetadataFromDb = (DataSourceMetadata)this.jsonMapper.readValue(oldCommitMetadataBytesFromDb, DataSourceMetadata.class);
        }
        boolean startMetadataGreaterThanExisting = false;
        if (oldCommitMetadataFromDb == null) {
            startMetadataMatchesExisting = startMetadata.isValidStart();
            startMetadataGreaterThanExisting = true;
        } else {
            if (startMetadata instanceof Comparable) {
                startMetadataGreaterThanExisting = ((Comparable)((Object)startMetadata.asStartMetadata())).compareTo(oldCommitMetadataFromDb.asStartMetadata()) > 0;
            }
            startMetadataMatchesExisting = startMetadata.asStartMetadata().matches(oldCommitMetadataFromDb.asStartMetadata());
        }
        if (startMetadataGreaterThanExisting && !startMetadataMatchesExisting) {
            return DataStoreMetadataUpdateResult.retryableFailure("The new start metadata state[%s] is ahead of the last committed end state[%s]. Try resetting the supervisor.", startMetadata, oldCommitMetadataFromDb);
        }
        if (!startMetadataMatchesExisting) {
            return DataStoreMetadataUpdateResult.failure("Inconsistency between stored metadata state[%s] and target state[%s]. Try resetting the supervisor.", oldCommitMetadataFromDb, startMetadata);
        }
        DataSourceMetadata newCommitMetadata = oldCommitMetadataFromDb == null ? endMetadata : oldCommitMetadataFromDb.plus(endMetadata);
        byte[] newCommitMetadataBytes = this.jsonMapper.writeValueAsBytes((Object)newCommitMetadata);
        String newCommitMetadataSha1 = BaseEncoding.base16().encode(Hashing.sha1().hashBytes(newCommitMetadataBytes).asBytes());
        if (oldCommitMetadataBytesFromDb == null) {
            int numRows = ((Update)((Update)((Update)((Update)handle.createStatement(StringUtils.format((String)"INSERT INTO %s (dataSource, created_date, commit_metadata_payload, commit_metadata_sha1) VALUES (:dataSource, :created_date, :commit_metadata_payload, :commit_metadata_sha1)", (Object[])new Object[]{this.dbTables.getDataSourceTable()})).bind("dataSource", dataSource)).bind("created_date", DateTimes.nowUtc().toString())).bind("commit_metadata_payload", newCommitMetadataBytes)).bind("commit_metadata_sha1", newCommitMetadataSha1)).execute();
            retVal = numRows == 1 ? DataStoreMetadataUpdateResult.SUCCESS : DataStoreMetadataUpdateResult.retryableFailure("Failed to insert metadata for datasource[%s]", dataSource);
        } else {
            int numRows = ((Update)((Update)((Update)((Update)handle.createStatement(StringUtils.format((String)"UPDATE %s SET commit_metadata_payload = :new_commit_metadata_payload, commit_metadata_sha1 = :new_commit_metadata_sha1 WHERE dataSource = :dataSource AND commit_metadata_sha1 = :old_commit_metadata_sha1", (Object[])new Object[]{this.dbTables.getDataSourceTable()})).bind("dataSource", dataSource)).bind("old_commit_metadata_sha1", oldCommitMetadataSha1FromDb)).bind("new_commit_metadata_payload", newCommitMetadataBytes)).bind("new_commit_metadata_sha1", newCommitMetadataSha1)).execute();
            DataStoreMetadataUpdateResult dataStoreMetadataUpdateResult = retVal = numRows == 1 ? DataStoreMetadataUpdateResult.SUCCESS : DataStoreMetadataUpdateResult.retryableFailure("Failed to update metadata for datasource[%s]", dataSource);
        }
        if (retVal.isSuccess()) {
            log.info("Updated metadata from[%s] to[%s].", new Object[]{oldCommitMetadataFromDb, newCommitMetadata});
        } else {
            log.info("Not updating metadata, compare-and-swap failure.", new Object[0]);
        }
        return retVal;
    }

    @Override
    public boolean deleteDataSourceMetadata(String dataSource) {
        return (Boolean)this.connector.retryWithHandle(handle -> {
            int rows = ((Update)handle.createStatement(StringUtils.format((String)"DELETE from %s WHERE dataSource = :dataSource", (Object[])new Object[]{this.dbTables.getDataSourceTable()})).bind("dataSource", dataSource)).execute();
            return rows > 0;
        });
    }

    @Override
    public boolean resetDataSourceMetadata(String dataSource, DataSourceMetadata dataSourceMetadata) throws IOException {
        byte[] newCommitMetadataBytes = this.jsonMapper.writeValueAsBytes((Object)dataSourceMetadata);
        String newCommitMetadataSha1 = BaseEncoding.base16().encode(Hashing.sha1().hashBytes(newCommitMetadataBytes).asBytes());
        String sql = "UPDATE %s SET commit_metadata_payload = :new_commit_metadata_payload, commit_metadata_sha1 = :new_commit_metadata_sha1 WHERE dataSource = :dataSource";
        return (Boolean)this.connector.retryWithHandle(handle -> {
            int numRows = ((Update)((Update)((Update)handle.createStatement(StringUtils.format((String)"UPDATE %s SET commit_metadata_payload = :new_commit_metadata_payload, commit_metadata_sha1 = :new_commit_metadata_sha1 WHERE dataSource = :dataSource", (Object[])new Object[]{this.dbTables.getDataSourceTable()})).bind("dataSource", dataSource)).bind("new_commit_metadata_payload", newCommitMetadataBytes)).bind("new_commit_metadata_sha1", newCommitMetadataSha1)).execute();
            return numRows == 1;
        });
    }

    @Override
    public void updateSegmentMetadata(Set<DataSegment> segments) {
        this.connector.getDBI().inTransaction((handle, transactionStatus) -> {
            for (DataSegment segment : segments) {
                this.updatePayload(handle, segment);
            }
            return 0;
        });
    }

    @Override
    public void deleteSegments(Set<DataSegment> segments) {
        if (segments.isEmpty()) {
            log.info("No segments to delete.", new Object[0]);
            return;
        }
        String deleteSql = StringUtils.format((String)"DELETE from %s WHERE id = :id", (Object[])new Object[]{this.dbTables.getSegmentsTable()});
        String dataSource = segments.stream().findFirst().map(DataSegment::getDataSource).get();
        List ids = segments.stream().map(s -> s.getId().toString()).collect(Collectors.toList());
        int numDeletedSegments = (Integer)this.connector.getDBI().inTransaction((handle, transactionStatus) -> {
            PreparedBatch batch = handle.prepareBatch(deleteSql);
            for (String id : ids) {
                ((PreparedBatch)batch.bind("id", id)).add();
            }
            int[] deletedRows = batch.execute();
            return Arrays.stream(deletedRows).sum();
        });
        log.debugSegments(segments, "Delete the metadata of segments");
        log.info("Deleted [%d] segments from metadata storage for dataSource [%s].", new Object[]{numDeletedSegments, dataSource});
    }

    private void updatePayload(Handle handle, DataSegment segment) throws IOException {
        try {
            ((Update)((Update)handle.createStatement(StringUtils.format((String)"UPDATE %s SET payload = :payload WHERE id = :id", (Object[])new Object[]{this.dbTables.getSegmentsTable()})).bind("id", segment.getId().toString())).bind("payload", this.jsonMapper.writeValueAsBytes((Object)segment))).execute();
        }
        catch (IOException e) {
            log.error((Throwable)e, "Exception inserting into DB", new Object[0]);
            throw e;
        }
    }

    @Override
    public boolean insertDataSourceMetadata(String dataSource, DataSourceMetadata metadata) {
        return 1 == (Integer)this.connector.getDBI().inTransaction((handle, status) -> ((Update)((Update)((Update)((Update)handle.createStatement(StringUtils.format((String)"INSERT INTO %s (dataSource, created_date, commit_metadata_payload, commit_metadata_sha1) VALUES (:dataSource, :created_date, :commit_metadata_payload, :commit_metadata_sha1)", (Object[])new Object[]{this.dbTables.getDataSourceTable()})).bind("dataSource", dataSource)).bind("created_date", DateTimes.nowUtc().toString())).bind("commit_metadata_payload", this.jsonMapper.writeValueAsBytes((Object)metadata))).bind("commit_metadata_sha1", BaseEncoding.base16().encode(Hashing.sha1().hashBytes(this.jsonMapper.writeValueAsBytes((Object)metadata)).asBytes()))).execute());
    }

    @Override
    public int removeDataSourceMetadataOlderThan(long timestamp, @NotNull Set<String> excludeDatasources) {
        DateTime dateTime = DateTimes.utc((long)timestamp);
        List datasourcesToDelete = (List)this.connector.getDBI().withHandle(handle -> handle.createQuery(StringUtils.format((String)"SELECT dataSource FROM %1$s WHERE created_date < '%2$s'", (Object[])new Object[]{this.dbTables.getDataSourceTable(), dateTime.toString()})).mapTo(String.class).list());
        datasourcesToDelete.removeAll(excludeDatasources);
        return (Integer)this.connector.getDBI().withHandle(handle -> {
            PreparedBatch batch = handle.prepareBatch(StringUtils.format((String)"DELETE FROM %1$s WHERE dataSource = :dataSource AND created_date < '%2$s'", (Object[])new Object[]{this.dbTables.getDataSourceTable(), dateTime.toString()}));
            for (String datasource : datasourcesToDelete) {
                ((PreparedBatch)batch.bind("dataSource", datasource)).add();
            }
            int[] result = batch.execute();
            return IntStream.of(result).sum();
        });
    }

    @VisibleForTesting
    Set<DataSegment> retrieveUsedSegmentsForAllocation(Handle handle, String dataSource, Interval interval) {
        Set<SegmentId> overlappingSegmentIds = SqlSegmentsMetadataQuery.forHandle(handle, this.connector, this.dbTables, this.jsonMapper).retrieveUsedSegmentIds(dataSource, interval);
        HashMap<String, Map> versionIntervalToSmallestSegmentId = new HashMap<String, Map>();
        for (SegmentId segmentId : overlappingSegmentIds) {
            Map map = versionIntervalToSmallestSegmentId.computeIfAbsent(segmentId.getVersion(), v -> new HashMap());
            SegmentId value = (SegmentId)map.get(segmentId.getInterval());
            if (value != null && value.getPartitionNum() <= segmentId.getPartitionNum()) continue;
            map.put(segmentId.getInterval(), segmentId);
        }
        HashSet<String> segmentIdsToRetrieve = new HashSet<String>();
        for (Map itvlMap : versionIntervalToSmallestSegmentId.values()) {
            segmentIdsToRetrieve.addAll(itvlMap.values().stream().map(SegmentId::toString).collect(Collectors.toList()));
        }
        Set<DataSegment> set = this.retrieveSegmentsById(dataSource, segmentIdsToRetrieve);
        HashSet<String> retrievedIds = new HashSet<String>();
        HashMap<String, Map> versionIntervalToNumCorePartitions = new HashMap<String, Map>();
        for (DataSegment segment : set) {
            versionIntervalToNumCorePartitions.computeIfAbsent(segment.getVersion(), v -> new HashMap()).put(segment.getInterval(), segment.getShardSpec().getNumCorePartitions());
            retrievedIds.add(segment.getId().toString());
        }
        if (!retrievedIds.equals(segmentIdsToRetrieve)) {
            throw DruidException.defensive((String)"Used segment IDs for dataSource[%s] and interval[%s] have changed in the metadata store.", (Object[])new Object[]{dataSource, interval});
        }
        HashSet<DataSegment> segmentsWithAllocationInfo = new HashSet<DataSegment>();
        for (SegmentId id : overlappingSegmentIds) {
            int corePartitions = (Integer)((Map)versionIntervalToNumCorePartitions.get(id.getVersion())).get(id.getInterval());
            segmentsWithAllocationInfo.add(new DataSegment(id, null, null, null, (ShardSpec)new NumberedShardSpec(id.getPartitionNum(), corePartitions), null, null, 1L));
        }
        return segmentsWithAllocationInfo;
    }

    @Override
    public DataSegment retrieveSegmentForId(String id, boolean includeUnused) {
        return (DataSegment)this.connector.retryTransaction((handle, status) -> {
            if (includeUnused) {
                return SqlSegmentsMetadataQuery.forHandle(handle, this.connector, this.dbTables, this.jsonMapper).retrieveSegmentForId(id);
            }
            return SqlSegmentsMetadataQuery.forHandle(handle, this.connector, this.dbTables, this.jsonMapper).retrieveUsedSegmentForId(id);
        }, 3, 10);
    }

    @Override
    public int deletePendingSegmentsForTaskAllocatorId(String datasource, String taskAllocatorId) {
        return (Integer)this.connector.getDBI().inTransaction((handle, status) -> ((Update)((Update)handle.createStatement(StringUtils.format((String)"DELETE FROM %s WHERE dataSource = :dataSource AND task_allocator_id = :task_allocator_id", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable()})).bind("dataSource", datasource)).bind("task_allocator_id", taskAllocatorId)).execute());
    }

    @Override
    public List<PendingSegmentRecord> getPendingSegments(String datasource, Interval interval) {
        return (List)this.connector.retryWithHandle(handle -> this.getPendingSegmentsForInterval(handle, datasource, interval));
    }

    @Override
    public int deleteUpgradeSegmentsForTask(String taskId) {
        return (Integer)this.connector.getDBI().inTransaction((handle, status) -> ((Update)handle.createStatement(StringUtils.format((String)"DELETE FROM %s WHERE task_id = :task_id", (Object[])new Object[]{this.dbTables.getUpgradeSegmentsTable()})).bind("task_id", taskId)).execute());
    }

    @Override
    public Map<String, String> retrieveUpgradedFromSegmentIds(String dataSource, Set<String> segmentIds) {
        if (segmentIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> upgradedFromSegmentIds = new HashMap<String, String>();
        List partitions = Lists.partition((List)ImmutableList.copyOf(segmentIds), (int)100);
        for (List partition : partitions) {
            String sql = StringUtils.format((String)"SELECT id, upgraded_from_segment_id FROM %s WHERE dataSource = :dataSource %s", (Object[])new Object[]{this.dbTables.getSegmentsTable(), SqlSegmentsMetadataQuery.getParameterizedInConditionForColumn("id", partition)});
            this.connector.retryWithHandle(handle -> {
                Query query = (Query)handle.createQuery(sql).bind("dataSource", dataSource);
                SqlSegmentsMetadataQuery.bindColumnValuesToQueryWithInCondition("id", partition, query);
                return query.map((index, r, ctx) -> {
                    String id = r.getString(1);
                    String upgradedFromSegmentId = r.getString(2);
                    if (upgradedFromSegmentId != null) {
                        upgradedFromSegmentIds.put(id, upgradedFromSegmentId);
                    }
                    return null;
                }).list();
            });
        }
        return upgradedFromSegmentIds;
    }

    @Override
    public Map<String, Set<String>> retrieveUpgradedToSegmentIds(String dataSource, Set<String> segmentIds) {
        if (segmentIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> upgradedToSegmentIds = new HashMap<String, Set<String>>();
        this.retrieveSegmentsById(dataSource, segmentIds).stream().map(DataSegment::getId).map(SegmentId::toString).forEach(id -> upgradedToSegmentIds.computeIfAbsent((String)id, k -> new HashSet()).add(id));
        List partitions = Lists.partition((List)ImmutableList.copyOf(segmentIds), (int)100);
        for (List partition : partitions) {
            String sql = StringUtils.format((String)"SELECT id, upgraded_from_segment_id FROM %s WHERE dataSource = :dataSource %s", (Object[])new Object[]{this.dbTables.getSegmentsTable(), SqlSegmentsMetadataQuery.getParameterizedInConditionForColumn("upgraded_from_segment_id", partition)});
            this.connector.retryWithHandle(handle -> {
                Query query = (Query)handle.createQuery(sql).bind("dataSource", dataSource);
                SqlSegmentsMetadataQuery.bindColumnValuesToQueryWithInCondition("upgraded_from_segment_id", partition, query);
                return query.map((index, r, ctx) -> {
                    String upgradedToId = r.getString(1);
                    String id = r.getString(2);
                    upgradedToSegmentIds.computeIfAbsent(id, k -> new HashSet()).add(upgradedToId);
                    return null;
                }).list();
            });
        }
        return upgradedToSegmentIds;
    }

    public static class DataStoreMetadataUpdateResult {
        private final boolean failed;
        private final boolean canRetry;
        private final String errorMsg;
        public static final DataStoreMetadataUpdateResult SUCCESS = new DataStoreMetadataUpdateResult(false, false, null, new Object[0]);

        public static DataStoreMetadataUpdateResult failure(String errorMsgFormat, Object ... messageArgs) {
            return new DataStoreMetadataUpdateResult(true, false, errorMsgFormat, messageArgs);
        }

        public static DataStoreMetadataUpdateResult retryableFailure(String errorMsgFormat, Object ... messageArgs) {
            return new DataStoreMetadataUpdateResult(true, true, errorMsgFormat, messageArgs);
        }

        DataStoreMetadataUpdateResult(boolean failed, boolean canRetry, @Nullable String errorMsg, Object ... errorFormatArgs) {
            this.failed = failed;
            this.canRetry = canRetry;
            this.errorMsg = null == errorMsg ? null : StringUtils.format((String)errorMsg, (Object[])errorFormatArgs);
        }

        public boolean isFailed() {
            return this.failed;
        }

        public boolean isSuccess() {
            return !this.failed;
        }

        public boolean canRetry() {
            return this.canRetry;
        }

        @Nullable
        public String getErrorMsg() {
            return this.errorMsg;
        }
    }

    private static class PendingSegmentsRecord {
        private final String sequenceName;
        private final byte[] payload;

        static PendingSegmentsRecord fromResultSet(ResultSet resultSet) {
            try {
                return new PendingSegmentsRecord(resultSet.getString(1), resultSet.getBytes(2));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        PendingSegmentsRecord(String sequenceName, byte[] payload) {
            this.payload = payload;
            this.sequenceName = sequenceName;
        }

        public byte[] getPayload() {
            return this.payload;
        }

        public String getSequenceName() {
            return this.sequenceName;
        }
    }

    private static class UniqueAllocateRequest {
        private final Interval interval;
        private final String previousSegmentId;
        private final String sequenceName;
        private final boolean skipSegmentLineageCheck;
        private final int hashCode;

        public UniqueAllocateRequest(Interval interval, SegmentCreateRequest request, boolean skipSegmentLineageCheck) {
            this.interval = interval;
            this.sequenceName = request.getSequenceName();
            this.previousSegmentId = skipSegmentLineageCheck ? null : request.getPreviousSegmentId();
            this.skipSegmentLineageCheck = skipSegmentLineageCheck;
            this.hashCode = Objects.hash(interval, this.sequenceName, this.previousSegmentId, skipSegmentLineageCheck);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UniqueAllocateRequest that = (UniqueAllocateRequest)o;
            return this.skipSegmentLineageCheck == that.skipSegmentLineageCheck && Objects.equals(this.interval, that.interval) && Objects.equals(this.sequenceName, that.sequenceName) && Objects.equals(this.previousSegmentId, that.previousSegmentId);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class CheckExistingSegmentIdResult {
        private final boolean found;
        private final SegmentIdWithShardSpec segmentIdentifier;

        CheckExistingSegmentIdResult(boolean found, @Nullable SegmentIdWithShardSpec segmentIdentifier) {
            this.found = found;
            this.segmentIdentifier = segmentIdentifier;
        }
    }
}

