/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Bytes;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.client.CacheUtil;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.QueryableDruidServer;
import org.apache.druid.client.SegmentServerSelector;
import org.apache.druid.client.ServerView;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.client.selector.ServerSelector;
import org.apache.druid.guice.annotations.Client;
import org.apache.druid.guice.annotations.Merging;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.LazySequence;
import org.apache.druid.java.util.common.guava.ParallelMergeCombiningSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.BrokerParallelMergeConfig;
import org.apache.druid.query.BySegmentResultValueClass;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.aggregation.MetricManipulatorFns;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilterUtils;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Overshadowable;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.TimelineLookup;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.joda.time.Interval;

public class CachingClusteredClient
implements QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(CachingClusteredClient.class);
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final TimelineServerView serverView;
    private final Cache cache;
    private final ObjectMapper objectMapper;
    private final CachePopulator cachePopulator;
    private final CacheConfig cacheConfig;
    private final DruidHttpClientConfig httpClientConfig;
    private final BrokerParallelMergeConfig parallelMergeConfig;
    private final ForkJoinPool pool;
    private final QueryScheduler scheduler;
    private final ServiceEmitter emitter;

    @Inject
    public CachingClusteredClient(QueryRunnerFactoryConglomerate conglomerate, TimelineServerView serverView, Cache cache, @Smile ObjectMapper objectMapper, CachePopulator cachePopulator, CacheConfig cacheConfig, @Client DruidHttpClientConfig httpClientConfig, BrokerParallelMergeConfig parallelMergeConfig, @Merging ForkJoinPool pool, QueryScheduler scheduler, ServiceEmitter emitter) {
        this.conglomerate = conglomerate;
        this.serverView = serverView;
        this.cache = cache;
        this.objectMapper = objectMapper;
        this.cachePopulator = cachePopulator;
        this.cacheConfig = cacheConfig;
        this.httpClientConfig = httpClientConfig;
        this.parallelMergeConfig = parallelMergeConfig;
        this.pool = pool;
        this.scheduler = scheduler;
        this.emitter = emitter;
        if (cacheConfig.isQueryCacheable("groupBy") && (cacheConfig.isUseCache() || cacheConfig.isPopulateCache())) {
            log.warn("Even though groupBy caching is enabled in your configuration, v2 groupBys will not be cached on the broker. Consider enabling caching on your data nodes if it is not already enabled.", new Object[0]);
        }
        serverView.registerSegmentCallback(Execs.singleThreaded((String)"CCClient-ServerView-CB-%d"), new ServerView.BaseSegmentCallback(){

            @Override
            public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
                CachingClusteredClient.this.cache.close(segment.getId().toString());
                return ServerView.CallbackAction.CONTINUE;
            }
        });
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        return new QueryRunner<T>(){

            public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
                return CachingClusteredClient.this.run(queryPlus, responseContext, timeline -> timeline, false);
            }
        };
    }

    private <T> Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext, UnaryOperator<TimelineLookup<String, ServerSelector>> timelineConverter, boolean specificSegments) {
        ClusterQueryResult<T> result = new SpecificQueryRunnable<T>(queryPlus, responseContext).run(timelineConverter, specificSegments);
        CachingClusteredClient.initializeNumRemainingResponsesInResponseContext(queryPlus.getQuery(), responseContext, result.numQueryServers);
        return result.sequence;
    }

    private static <T> void initializeNumRemainingResponsesInResponseContext(Query<T> query, ResponseContext responseContext, int numQueryServers) {
        responseContext.addRemainingResponse(query.getMostSpecificId(), numQueryServers);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, final Iterable<SegmentDescriptor> specs) {
        return new QueryRunner<T>(){

            public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
                return CachingClusteredClient.this.run(queryPlus, responseContext, new TimelineConverter<ServerSelector>(specs), true);
            }
        };
    }

    public static class TimelineConverter<T extends Overshadowable<T>>
    implements UnaryOperator<TimelineLookup<String, T>> {
        private final Iterable<SegmentDescriptor> specs;

        public TimelineConverter(Iterable<SegmentDescriptor> specs) {
            this.specs = specs;
        }

        @Override
        public TimelineLookup<String, T> apply(TimelineLookup<String, T> timeline) {
            Iterator unfilteredIterator = Iterators.transform(this.specs.iterator(), spec -> this.toChunkEntry(timeline, (SegmentDescriptor)spec));
            UnmodifiableIterator iterator = Iterators.filter((Iterator)unfilteredIterator, Objects::nonNull);
            VersionedIntervalTimeline newTimeline = new VersionedIntervalTimeline((Comparator)Ordering.natural(), true);
            newTimeline.addAll((Iterator)iterator);
            return newTimeline;
        }

        @Nullable
        private VersionedIntervalTimeline.PartitionChunkEntry<String, T> toChunkEntry(TimelineLookup<String, T> timeline, SegmentDescriptor spec) {
            PartitionChunk chunk = timeline.findChunk(spec.getInterval(), (Object)spec.getVersion(), spec.getPartitionNumber());
            if (null == chunk) {
                return null;
            }
            return new VersionedIntervalTimeline.PartitionChunkEntry(spec.getInterval(), (Object)spec.getVersion(), chunk);
        }
    }

    @VisibleForTesting
    static class CacheKeyManager<T> {
        private final Query<T> query;
        private final CacheStrategy<T, Object, Query<T>> strategy;
        private final boolean isSegmentLevelCachingEnable;

        CacheKeyManager(Query<T> query, CacheStrategy<T, Object, Query<T>> strategy, boolean useCache, boolean populateCache) {
            this.query = query;
            this.strategy = strategy;
            this.isSegmentLevelCachingEnable = (populateCache || useCache) && !query.context().isBySegment();
        }

        @Nullable
        byte[] computeSegmentLevelQueryCacheKey() {
            if (this.isSegmentLevelCachingEnable) {
                return this.computeQueryCacheKeyWithJoin();
            }
            return null;
        }

        @Nullable
        String computeResultLevelCachingEtag(Set<SegmentServerSelector> segments, @Nullable byte[] queryCacheKey) {
            byte[] queryCacheKeyFinal;
            Hasher hasher = Hashing.sha1().newHasher();
            boolean hasOnlyHistoricalSegments = true;
            for (SegmentServerSelector p : segments) {
                QueryableDruidServer queryableServer = p.getServer().pick(this.query);
                if (queryableServer == null || !queryableServer.getServer().isSegmentReplicationTarget()) {
                    hasOnlyHistoricalSegments = false;
                    break;
                }
                hasher.putString((CharSequence)p.getServer().getSegment().getId().toString(), StandardCharsets.UTF_8);
                hasher.putString((CharSequence)((SegmentDescriptor)p.rhs).getInterval().toString(), StandardCharsets.UTF_8);
            }
            if (!hasOnlyHistoricalSegments) {
                return null;
            }
            byte[] byArray = queryCacheKeyFinal = queryCacheKey == null ? this.computeQueryCacheKeyWithJoin() : queryCacheKey;
            if (queryCacheKeyFinal == null) {
                return null;
            }
            hasher.putBytes(queryCacheKeyFinal);
            String currEtag = StringUtils.encodeBase64String((byte[])hasher.hash().asBytes());
            return currEtag;
        }

        @Nullable
        private byte[] computeQueryCacheKeyWithJoin() {
            Preconditions.checkNotNull(this.strategy, (Object)"strategy cannot be null");
            byte[] dataSourceCacheKey = this.query.getDataSource().getCacheKey();
            if (null == dataSourceCacheKey) {
                return null;
            }
            if (dataSourceCacheKey.length > 0) {
                return Bytes.concat((byte[][])new byte[][]{dataSourceCacheKey, this.strategy.computeCacheKey(this.query)});
            }
            return this.strategy.computeCacheKey(this.query);
        }
    }

    private class SpecificQueryRunnable<T> {
        private final ResponseContext responseContext;
        private QueryPlus<T> queryPlus;
        private Query<T> query;
        private final QueryToolChest<T, Query<T>> toolChest;
        @Nullable
        private final CacheStrategy<T, Object, Query<T>> strategy;
        private final boolean useCache;
        private final boolean populateCache;
        private final boolean isBySegment;
        private final int uncoveredIntervalsLimit;
        private final Map<String, Cache.NamedKey> cachePopulatorKeyMap = new HashMap<String, Cache.NamedKey>();
        private final DataSourceAnalysis dataSourceAnalysis;
        private final List<Interval> intervals;
        private final CacheKeyManager<T> cacheKeyManager;

        SpecificQueryRunnable(QueryPlus<T> queryPlus, ResponseContext responseContext) {
            this.queryPlus = queryPlus;
            this.responseContext = responseContext;
            this.query = queryPlus.getQuery();
            this.toolChest = CachingClusteredClient.this.conglomerate.getToolChest(this.query);
            this.strategy = this.toolChest.getCacheStrategy(this.query, CachingClusteredClient.this.objectMapper);
            this.dataSourceAnalysis = this.query.getDataSource().getAnalysis();
            this.useCache = CacheUtil.isUseSegmentCache(this.query, this.strategy, CachingClusteredClient.this.cacheConfig, CacheUtil.ServerType.BROKER);
            this.populateCache = CacheUtil.isPopulateSegmentCache(this.query, this.strategy, CachingClusteredClient.this.cacheConfig, CacheUtil.ServerType.BROKER);
            QueryContext queryContext = this.query.context();
            this.isBySegment = queryContext.isBySegment();
            this.uncoveredIntervalsLimit = queryContext.getUncoveredIntervalsLimit();
            this.intervals = this.dataSourceAnalysis.getBaseQuerySegmentSpec().map(QuerySegmentSpec::getIntervals).orElseGet(() -> this.query.getIntervals());
            this.cacheKeyManager = new CacheKeyManager<T>(this.query, this.strategy, this.useCache, this.populateCache);
        }

        private ImmutableMap<String, Object> makeDownstreamQueryContext() {
            ImmutableMap.Builder contextBuilder = new ImmutableMap.Builder();
            QueryContext queryContext = this.query.context();
            int priority = queryContext.getPriority();
            contextBuilder.put((Object)"priority", (Object)priority);
            String lane = queryContext.getLane();
            if (lane != null) {
                contextBuilder.put((Object)"lane", (Object)lane);
            }
            if (this.populateCache) {
                contextBuilder.put((Object)"populateCache", (Object)false);
                contextBuilder.put((Object)"bySegment", (Object)true);
            }
            return contextBuilder.build();
        }

        ClusterQueryResult<T> run(UnaryOperator<TimelineLookup<String, ServerSelector>> timelineConverter, boolean specificSegments) {
            Optional maybeTimeline = CachingClusteredClient.this.serverView.getTimeline(this.dataSourceAnalysis);
            if (!maybeTimeline.isPresent()) {
                return new ClusterQueryResult(Sequences.empty(), 0);
            }
            TimelineLookup timeline = (TimelineLookup)timelineConverter.apply((TimelineLookup)maybeTimeline.get());
            if (this.uncoveredIntervalsLimit > 0) {
                this.computeUncoveredIntervals((TimelineLookup<String, ServerSelector>)timeline);
            }
            Set<SegmentServerSelector> segmentServers = this.computeSegmentsToQuery((TimelineLookup<String, ServerSelector>)timeline, specificSegments);
            byte[] queryCacheKey = this.cacheKeyManager.computeSegmentLevelQueryCacheKey();
            String prevEtag = (String)this.query.getContext().get("If-None-Match");
            if (prevEtag != null) {
                String currentEtag = this.cacheKeyManager.computeResultLevelCachingEtag(segmentServers, queryCacheKey);
                if (null != currentEtag) {
                    this.responseContext.putEntityTag(currentEtag);
                }
                if (currentEtag != null && currentEtag.equals(prevEtag)) {
                    return new ClusterQueryResult(Sequences.empty(), 0);
                }
            }
            List<Pair<Interval, byte[]>> alreadyCachedResults = this.pruneSegmentsWithCachedResults(queryCacheKey, segmentServers);
            this.query = CachingClusteredClient.this.scheduler.prioritizeAndLaneQuery(this.queryPlus, segmentServers);
            this.queryPlus = this.queryPlus.withQuery(this.query);
            this.queryPlus = this.queryPlus.withQueryMetrics(this.toolChest);
            this.queryPlus.getQueryMetrics().reportQueriedSegmentCount((long)segmentServers.size()).emit(CachingClusteredClient.this.emitter);
            SortedMap<DruidServer, List<SegmentDescriptor>> segmentsByServer = this.groupSegmentsByServer(segmentServers);
            LazySequence mergedResultSequence = new LazySequence(() -> {
                ArrayList<Sequence<T>> sequencesByInterval = new ArrayList<Sequence<T>>(alreadyCachedResults.size() + segmentsByServer.size());
                this.addSequencesFromCache(sequencesByInterval, alreadyCachedResults);
                this.addSequencesFromServer(sequencesByInterval, segmentsByServer);
                return this.merge(sequencesByInterval);
            });
            return new ClusterQueryResult(CachingClusteredClient.this.scheduler.run(this.query, mergedResultSequence), segmentsByServer.size());
        }

        private Sequence<T> merge(List<Sequence<T>> sequencesByInterval) {
            BinaryOperator mergeFn = this.toolChest.createMergeFn(this.query);
            QueryContext queryContext = this.query.context();
            if (CachingClusteredClient.this.parallelMergeConfig.useParallelMergePool() && queryContext.getEnableParallelMerges() && mergeFn != null) {
                ParallelMergeCombiningSequence parallelSequence = new ParallelMergeCombiningSequence(CachingClusteredClient.this.pool, sequencesByInterval, this.query.getResultOrdering(), mergeFn, queryContext.hasTimeout(), queryContext.getTimeout(), queryContext.getPriority(), queryContext.getParallelMergeParallelism(CachingClusteredClient.this.parallelMergeConfig.getDefaultMaxQueryParallelism()), queryContext.getParallelMergeInitialYieldRows(CachingClusteredClient.this.parallelMergeConfig.getInitialYieldNumRows()), queryContext.getParallelMergeSmallBatchRows(CachingClusteredClient.this.parallelMergeConfig.getSmallBatchNumRows()), CachingClusteredClient.this.parallelMergeConfig.getTargetRunTimeMillis(), reportMetrics -> {
                    QueryMetrics queryMetrics = this.queryPlus.getQueryMetrics();
                    if (queryMetrics != null) {
                        queryMetrics.parallelMergeParallelism(reportMetrics.getParallelism());
                        queryMetrics.reportParallelMergeParallelism(reportMetrics.getParallelism()).emit(CachingClusteredClient.this.emitter);
                        queryMetrics.reportParallelMergeInputSequences(reportMetrics.getInputSequences()).emit(CachingClusteredClient.this.emitter);
                        queryMetrics.reportParallelMergeInputRows(reportMetrics.getInputRows()).emit(CachingClusteredClient.this.emitter);
                        queryMetrics.reportParallelMergeOutputRows(reportMetrics.getOutputRows()).emit(CachingClusteredClient.this.emitter);
                        queryMetrics.reportParallelMergeTaskCount(reportMetrics.getTaskCount()).emit(CachingClusteredClient.this.emitter);
                        queryMetrics.reportParallelMergeTotalCpuTime(reportMetrics.getTotalCpuTime()).emit(CachingClusteredClient.this.emitter);
                        queryMetrics.reportParallelMergeTotalTime(reportMetrics.getTotalTime()).emit(CachingClusteredClient.this.emitter);
                        queryMetrics.reportParallelMergeSlowestPartitionTime(reportMetrics.getSlowestPartitionInitializedTime()).emit(CachingClusteredClient.this.emitter);
                        queryMetrics.reportParallelMergeFastestPartitionTime(reportMetrics.getFastestPartitionInitializedTime()).emit(CachingClusteredClient.this.emitter);
                    }
                });
                CachingClusteredClient.this.scheduler.registerQueryFuture(this.query, (ListenableFuture<?>)parallelSequence.getCancellationFuture());
                return parallelSequence;
            }
            return Sequences.simple(sequencesByInterval).flatMerge(seq -> seq, this.query.getResultOrdering());
        }

        private Set<SegmentServerSelector> computeSegmentsToQuery(TimelineLookup<String, ServerSelector> timeline, boolean specificSegments) {
            Set filterFieldsForPruning;
            HashMap dimensionRangeCache;
            boolean trySecondaryPartititionPruning;
            java.util.function.Function<Interval, List> lookupFn = specificSegments ? arg_0 -> timeline.lookupWithIncompletePartitions(arg_0) : arg_0 -> timeline.lookup(arg_0);
            List timelineObjectHolders = this.intervals.stream().flatMap(i -> ((List)lookupFn.apply((Interval)i)).stream()).collect(Collectors.toList());
            List serversLookup = this.toolChest.filterSegments(this.query, timelineObjectHolders);
            LinkedHashSet<SegmentServerSelector> segments = new LinkedHashSet<SegmentServerSelector>();
            boolean bl = trySecondaryPartititionPruning = this.query.getFilter() != null && this.query.context().isSecondaryPartitionPruningEnabled();
            if (trySecondaryPartititionPruning) {
                dimensionRangeCache = new HashMap();
                filterFieldsForPruning = DimFilterUtils.onlyBaseFields((Set)this.query.getFilter().getRequiredColumns(), (DataSourceAnalysis)this.dataSourceAnalysis);
            } else {
                dimensionRangeCache = null;
                filterFieldsForPruning = null;
            }
            for (TimelineObjectHolder holder : serversLookup) {
                Set filteredChunks = trySecondaryPartititionPruning ? DimFilterUtils.filterShards((DimFilter)this.query.getFilter(), (Set)filterFieldsForPruning, (Iterable)holder.getObject(), partitionChunk -> ((ServerSelector)partitionChunk.getObject()).getSegment().getShardSpec(), dimensionRangeCache) : Sets.newLinkedHashSet((Iterable)holder.getObject());
                for (PartitionChunk chunk : filteredChunks) {
                    ServerSelector server = (ServerSelector)chunk.getObject();
                    SegmentDescriptor segment = new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), chunk.getChunkNumber());
                    segments.add(new SegmentServerSelector(server, segment));
                }
            }
            return segments;
        }

        private void computeUncoveredIntervals(TimelineLookup<String, ServerSelector> timeline) {
            ArrayList<Interval> uncoveredIntervals = new ArrayList<Interval>(this.uncoveredIntervalsLimit);
            boolean uncoveredIntervalsOverflowed = false;
            for (Interval interval : this.intervals) {
                List lookup = timeline.lookup(interval);
                long startMillis = interval.getStartMillis();
                long endMillis = interval.getEndMillis();
                for (TimelineObjectHolder holder : lookup) {
                    Interval holderInterval = holder.getInterval();
                    long intervalStart = holderInterval.getStartMillis();
                    if (!uncoveredIntervalsOverflowed && startMillis != intervalStart) {
                        if (this.uncoveredIntervalsLimit > uncoveredIntervals.size()) {
                            uncoveredIntervals.add(Intervals.utc((long)startMillis, (long)intervalStart));
                        } else {
                            uncoveredIntervalsOverflowed = true;
                        }
                    }
                    startMillis = holderInterval.getEndMillis();
                }
                if (uncoveredIntervalsOverflowed || startMillis >= endMillis) continue;
                if (this.uncoveredIntervalsLimit > uncoveredIntervals.size()) {
                    uncoveredIntervals.add(Intervals.utc((long)startMillis, (long)endMillis));
                    continue;
                }
                uncoveredIntervalsOverflowed = true;
            }
            if (!uncoveredIntervals.isEmpty()) {
                this.responseContext.putUncoveredIntervals(uncoveredIntervals, uncoveredIntervalsOverflowed);
            }
        }

        private List<Pair<Interval, byte[]>> pruneSegmentsWithCachedResults(byte[] queryCacheKey, Set<SegmentServerSelector> segments) {
            if (queryCacheKey == null) {
                return Collections.emptyList();
            }
            ArrayList<Pair<Interval, byte[]>> alreadyCachedResults = new ArrayList<Pair<Interval, byte[]>>();
            Map<SegmentServerSelector, Cache.NamedKey> perSegmentCacheKeys = this.computePerSegmentCacheKeys(segments, queryCacheKey);
            Map<Cache.NamedKey, byte[]> cachedValues = this.computeCachedValues(perSegmentCacheKeys);
            perSegmentCacheKeys.forEach((segment, segmentCacheKey) -> {
                Interval segmentQueryInterval = segment.getSegmentDescriptor().getInterval();
                byte[] cachedValue = (byte[])cachedValues.get(segmentCacheKey);
                if (cachedValue != null) {
                    segments.remove(segment);
                    alreadyCachedResults.add(Pair.of((Object)segmentQueryInterval, (Object)cachedValue));
                } else if (this.populateCache) {
                    SegmentId segmentId = segment.getServer().getSegment().getId();
                    this.addCachePopulatorKey((Cache.NamedKey)segmentCacheKey, segmentId, segmentQueryInterval);
                }
            });
            return alreadyCachedResults;
        }

        private Map<SegmentServerSelector, Cache.NamedKey> computePerSegmentCacheKeys(Set<SegmentServerSelector> segments, byte[] queryCacheKey) {
            LinkedHashMap cacheKeys = Maps.newLinkedHashMap();
            for (SegmentServerSelector segmentServer : segments) {
                Cache.NamedKey segmentCacheKey = CacheUtil.computeSegmentCacheKey(segmentServer.getServer().getSegment().getId().toString(), segmentServer.getSegmentDescriptor(), queryCacheKey);
                cacheKeys.put(segmentServer, segmentCacheKey);
            }
            return cacheKeys;
        }

        private Map<Cache.NamedKey, byte[]> computeCachedValues(Map<SegmentServerSelector, Cache.NamedKey> cacheKeys) {
            if (this.useCache) {
                return CachingClusteredClient.this.cache.getBulk(Iterables.limit(cacheKeys.values(), (int)CachingClusteredClient.this.cacheConfig.getCacheBulkMergeLimit()));
            }
            return ImmutableMap.of();
        }

        private void addCachePopulatorKey(Cache.NamedKey segmentCacheKey, SegmentId segmentId, Interval segmentQueryInterval) {
            this.cachePopulatorKeyMap.put(StringUtils.format((String)"%s_%s", (Object[])new Object[]{segmentId, segmentQueryInterval}), segmentCacheKey);
        }

        @Nullable
        private Cache.NamedKey getCachePopulatorKey(String segmentId, Interval segmentInterval) {
            return this.cachePopulatorKeyMap.get(StringUtils.format((String)"%s_%s", (Object[])new Object[]{segmentId, segmentInterval}));
        }

        private SortedMap<DruidServer, List<SegmentDescriptor>> groupSegmentsByServer(Set<SegmentServerSelector> segments) {
            TreeMap<DruidServer, List<SegmentDescriptor>> serverSegments = new TreeMap<DruidServer, List<SegmentDescriptor>>();
            for (SegmentServerSelector segmentServer : segments) {
                QueryableDruidServer queryableDruidServer = segmentServer.getServer().pick(this.query);
                if (queryableDruidServer == null) {
                    log.makeAlert("No servers found for SegmentDescriptor[%s] for DataSource[%s]?! How can this be?!", new Object[]{segmentServer.getSegmentDescriptor(), this.query.getDataSource()}).emit();
                    continue;
                }
                DruidServer server = queryableDruidServer.getServer();
                serverSegments.computeIfAbsent(server, s -> new ArrayList()).add(segmentServer.getSegmentDescriptor());
            }
            return serverSegments;
        }

        private void addSequencesFromCache(List<Sequence<T>> listOfSequences, List<Pair<Interval, byte[]>> cachedResults) {
            if (this.strategy == null) {
                return;
            }
            Function pullFromCacheFunction = this.strategy.pullFromSegmentLevelCache();
            final TypeReference cacheObjectClazz = this.strategy.getCacheObjectClazz();
            for (Pair<Interval, byte[]> cachedResultPair : cachedResults) {
                final byte[] cachedResult = (byte[])cachedResultPair.rhs;
                BaseSequence cachedSequence = new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Object, Iterator<Object>>(){

                    public Iterator<Object> make() {
                        try {
                            if (cachedResult.length == 0) {
                                return Collections.emptyIterator();
                            }
                            return CachingClusteredClient.this.objectMapper.readValues(CachingClusteredClient.this.objectMapper.getFactory().createParser(cachedResult), cacheObjectClazz);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public void cleanup(Iterator<Object> iterFromMake) {
                    }
                });
                listOfSequences.add(Sequences.map((Sequence)cachedSequence, (Function)pullFromCacheFunction));
            }
        }

        private void addSequencesFromServer(List<Sequence<T>> listOfSequences, SortedMap<DruidServer, List<SegmentDescriptor>> segmentsByServer) {
            segmentsByServer.forEach((server, segmentsOfServer) -> {
                QueryRunner serverRunner = CachingClusteredClient.this.serverView.getQueryRunner((DruidServer)server);
                if (serverRunner == null) {
                    log.error("Server [%s] doesn't have a query runner", new Object[]{server.getName()});
                    return;
                }
                long maxQueuedBytes = this.query.context().getMaxQueuedBytes(CachingClusteredClient.this.httpClientConfig.getMaxQueuedBytes());
                long maxQueuedBytesPerServer = maxQueuedBytes / (long)segmentsByServer.size();
                Sequence<T> serverResults = this.isBySegment ? this.getBySegmentServerResults(serverRunner, (List<SegmentDescriptor>)segmentsOfServer, maxQueuedBytesPerServer) : (!server.isSegmentReplicationTarget() || !this.populateCache ? this.getSimpleServerResults(serverRunner, (List<SegmentDescriptor>)segmentsOfServer, maxQueuedBytesPerServer) : this.getAndCacheServerResults(serverRunner, (List<SegmentDescriptor>)segmentsOfServer, maxQueuedBytesPerServer));
                listOfSequences.add(serverResults);
            });
        }

        private Sequence<T> getBySegmentServerResults(QueryRunner serverRunner, List<SegmentDescriptor> segmentsOfServer, long maxQueuedBytesPerServer) {
            Sequence resultsBySegments = serverRunner.run(this.queryPlus.withQuery(Queries.withSpecificSegments((Query)this.queryPlus.getQuery(), segmentsOfServer)).withMaxQueuedBytes(maxQueuedBytesPerServer), this.responseContext);
            return resultsBySegments.map(result -> result.map(resultsOfSegment -> resultsOfSegment.mapResults(arg_0 -> ((Function)this.toolChest.makePreComputeManipulatorFn(this.query, MetricManipulatorFns.deserializing())).apply(arg_0))));
        }

        private Sequence<T> getSimpleServerResults(QueryRunner serverRunner, List<SegmentDescriptor> segmentsOfServer, long maxQueuedBytesPerServer) {
            return serverRunner.run(this.queryPlus.withQuery(Queries.withSpecificSegments((Query)this.queryPlus.getQuery(), segmentsOfServer)).withMaxQueuedBytes(maxQueuedBytesPerServer), this.responseContext);
        }

        private Sequence<T> getAndCacheServerResults(QueryRunner serverRunner, List<SegmentDescriptor> segmentsOfServer, long maxQueuedBytesPerServer) {
            Query downstreamQuery = this.query.withOverriddenContext(this.makeDownstreamQueryContext());
            Sequence resultsBySegments = serverRunner.run(this.queryPlus.withQuery(Queries.withSpecificSegments((Query)downstreamQuery, segmentsOfServer)).withMaxQueuedBytes(maxQueuedBytesPerServer), this.responseContext);
            Function cacheFn = this.strategy.prepareForSegmentLevelCache();
            return resultsBySegments.map(result -> {
                BySegmentResultValueClass resultsOfSegment = (BySegmentResultValueClass)result.getValue();
                Cache.NamedKey cachePopulatorKey = this.getCachePopulatorKey(resultsOfSegment.getSegmentId(), resultsOfSegment.getInterval());
                Sequence<Object> res = Sequences.simple((Iterable)resultsOfSegment.getResults());
                if (cachePopulatorKey != null) {
                    res = CachingClusteredClient.this.cachePopulator.wrap(res, arg_0 -> ((Function)cacheFn).apply(arg_0), CachingClusteredClient.this.cache, cachePopulatorKey);
                }
                return res.map(arg_0 -> ((Function)this.toolChest.makePreComputeManipulatorFn(downstreamQuery, MetricManipulatorFns.deserializing())).apply(arg_0));
            }).flatMerge(seq -> seq, this.query.getResultOrdering());
        }
    }

    private static class ClusterQueryResult<T> {
        private final Sequence<T> sequence;
        private final int numQueryServers;

        private ClusterQueryResult(Sequence<T> sequence, int numQueryServers) {
            this.sequence = sequence;
            this.numQueryServers = numQueryServers;
        }
    }
}

