/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.serde.cell.BlockCompressedPayloadWriter;
import org.apache.druid.segment.serde.cell.ByteBufferProvider;
import org.apache.druid.segment.serde.cell.CellIndexWriter;
import org.apache.druid.segment.serde.cell.IntSerializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.utils.CloseableUtils;

public class CellWriter
implements Serializer,
Closeable {
    private final IntSerializer intSerializer = new IntSerializer();
    private final CellIndexWriter cellIndexWriter;
    private final BlockCompressedPayloadWriter payloadWriter;

    private CellWriter(CellIndexWriter cellIndexWriter, BlockCompressedPayloadWriter payloadWriter) {
        this.cellIndexWriter = cellIndexWriter;
        this.payloadWriter = payloadWriter;
    }

    public void write(byte[] cellBytes) throws IOException {
        if (cellBytes == null) {
            this.cellIndexWriter.persistAndIncrement(0);
        } else {
            this.cellIndexWriter.persistAndIncrement(cellBytes.length);
            this.payloadWriter.write(cellBytes);
        }
    }

    public void write(ByteBuffer cellByteBuffer) throws IOException {
        if (cellByteBuffer == null) {
            this.cellIndexWriter.persistAndIncrement(0);
        } else {
            this.cellIndexWriter.persistAndIncrement(cellByteBuffer.remaining());
            this.payloadWriter.write(cellByteBuffer);
        }
    }

    @Override
    public void writeTo(WritableByteChannel channel, @Nullable FileSmoosher smoosher) throws IOException {
        channel.write(this.intSerializer.serialize(this.cellIndexWriter.getSerializedSize()));
        this.cellIndexWriter.writeTo(channel, smoosher);
        channel.write(this.intSerializer.serialize(this.payloadWriter.getSerializedSize()));
        this.payloadWriter.writeTo(channel, smoosher);
    }

    @Override
    public void close() throws IOException {
        Closeable[] closeableArray = new Closeable[1];
        closeableArray[0] = this.payloadWriter::close;
        CloseableUtils.closeAll(this.cellIndexWriter, closeableArray);
    }

    @Override
    public long getSerializedSize() {
        return (long)this.intSerializer.getSerializedSize() + this.cellIndexWriter.getSerializedSize() + (long)this.intSerializer.getSerializedSize() + this.payloadWriter.getSerializedSize();
    }

    public static Builder builder(SegmentWriteOutMedium segmentWriteOutMedium) {
        return new Builder(segmentWriteOutMedium);
    }

    public static class Builder {
        private final BlockCompressedPayloadWriter.Builder blockCompressedPayloadWriterBuilder;

        public Builder(SegmentWriteOutMedium segmentWriteOutMedium) {
            this.blockCompressedPayloadWriterBuilder = new BlockCompressedPayloadWriter.Builder(segmentWriteOutMedium);
        }

        public Builder setCompressionStrategy(CompressionStrategy compressionStrategy) {
            this.blockCompressedPayloadWriterBuilder.setCompressionStrategy(compressionStrategy);
            return this;
        }

        public Builder setByteBufferProvider(ByteBufferProvider byteBufferProvider) {
            this.blockCompressedPayloadWriterBuilder.setByteBufferProvider(byteBufferProvider);
            return this;
        }

        public CellWriter build() throws IOException {
            BlockCompressedPayloadWriter cellIndexPayloadWriter = this.blockCompressedPayloadWriterBuilder.build();
            BlockCompressedPayloadWriter payloadWriter = this.blockCompressedPayloadWriterBuilder.build();
            CellIndexWriter cellIndexWriter = new CellIndexWriter(cellIndexPayloadWriter);
            return new CellWriter(cellIndexWriter, payloadWriter);
        }
    }
}

