/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.allocation.ArenaMemoryAllocatorFactory;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.semantic.ColumnSelectorFactoryMaker;
import org.apache.druid.query.rowsandcols.semantic.FrameMaker;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.RowSignature;

public class DefaultFrameMaker
implements FrameMaker {
    private final RowsAndColumns rac;

    public DefaultFrameMaker(RowsAndColumns rac) {
        this.rac = rac;
    }

    @Override
    public RowSignature computeSignature() {
        RowSignature.Builder signatureBuilder = RowSignature.builder();
        for (String column : this.rac.getColumnNames()) {
            Column racColumn = this.rac.findColumn(column);
            if (racColumn == null) continue;
            signatureBuilder.add(column, racColumn.toAccessor().getType());
        }
        return signatureBuilder.build();
    }

    @Override
    public Frame toColumnBasedFrame() {
        AtomicInteger rowId = new AtomicInteger(0);
        int numRows = this.rac.numRows();
        ColumnSelectorFactoryMaker csfm = ColumnSelectorFactoryMaker.fromRAC(this.rac);
        ColumnSelectorFactory selectorFactory = csfm.make(rowId);
        ArenaMemoryAllocatorFactory memFactory = new ArenaMemoryAllocatorFactory(0xC800000);
        FrameWriter frameWriter = FrameWriters.makeColumnBasedFrameWriterFactory(memFactory, this.computeSignature(), Collections.emptyList()).newFrameWriter(selectorFactory);
        rowId.set(0);
        while (rowId.get() < numRows) {
            frameWriter.addSelection();
            rowId.incrementAndGet();
        }
        return Frame.wrap(frameWriter.toByteArray());
    }
}

