/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Locale;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.query.aggregation.AbstractSerializablePairLongObjectDeltaEncodedStagedSerde;
import org.apache.druid.query.aggregation.SerializablePairLongDouble;
import org.apache.druid.query.aggregation.SerializablePairLongDoubleColumnHeader;
import org.apache.druid.query.aggregation.SerializablePairLongFloat;
import org.apache.druid.query.aggregation.SerializablePairLongFloatColumnHeader;
import org.apache.druid.query.aggregation.SerializablePairLongLong;
import org.apache.druid.query.aggregation.SerializablePairLongLongColumnHeader;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.SerializablePairLongStringColumnHeader;
import org.apache.druid.segment.serde.cell.LongSerializer;

public abstract class AbstractSerializablePairLongObjectColumnHeader<T extends SerializablePair<Long, ?>> {
    private static final int HEADER_SIZE_BYTES = 4;
    private static final int USE_INTEGER_MASK = 128;
    private static final int VERSION_INDEX = 0;
    private static final int ENCODING_INDEX = 1;
    private final byte[] bytes;
    final long minValue;

    AbstractSerializablePairLongObjectColumnHeader(byte[] bytes, long minValue) {
        this.bytes = bytes;
        this.minValue = minValue;
    }

    AbstractSerializablePairLongObjectColumnHeader(int version, boolean useIntegerDeltas, long minTimestamp) {
        this.minValue = minTimestamp;
        this.bytes = new byte[4];
        Preconditions.checkArgument((version <= 255 ? 1 : 0) != 0, (Object)"max version 255");
        this.bytes[0] = (byte)version;
        if (useIntegerDeltas) {
            this.bytes[1] = (byte)(this.bytes[1] | 0x80);
        }
    }

    static AbstractSerializablePairLongObjectColumnHeader<?> fromBuffer(ByteBuffer byteBuffer, Class<?> pairClass) {
        byte[] bytes = new byte[4];
        byteBuffer.get(bytes);
        long minTimestamp = byteBuffer.getLong();
        if (pairClass.isAssignableFrom(SerializablePairLongLong.class)) {
            return new SerializablePairLongLongColumnHeader(bytes, minTimestamp);
        }
        if (pairClass.isAssignableFrom(SerializablePairLongDouble.class)) {
            return new SerializablePairLongDoubleColumnHeader(bytes, minTimestamp);
        }
        if (pairClass.isAssignableFrom(SerializablePairLongFloat.class)) {
            return new SerializablePairLongFloatColumnHeader(bytes, minTimestamp);
        }
        if (pairClass.isAssignableFrom(SerializablePairLongString.class)) {
            return new SerializablePairLongStringColumnHeader(bytes, minTimestamp);
        }
        throw new RE(String.format(Locale.ENGLISH, "Unsupported pairClass type: %s", pairClass.getSimpleName()), new Object[0]);
    }

    public abstract AbstractSerializablePairLongObjectDeltaEncodedStagedSerde<?> createSerde();

    public void transferTo(WritableByteChannel channel) throws IOException {
        LongSerializer longSerializer = new LongSerializer();
        channel.write(ByteBuffer.wrap(this.bytes));
        channel.write(longSerializer.serialize(this.minValue));
    }

    public int getVersion() {
        return 0xFF & this.bytes[0];
    }

    public boolean isUseIntegerDeltas() {
        return (this.bytes[1] & 0x80) != 0;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public int getSerializedSize() {
        return 12;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bytes", (Object)this.bytes).add("minValue", this.minValue).toString();
    }
}

