/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.segment.column.TypeFactory;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.column.TypeStrategy;

public class ExpressionTypeFactory
implements TypeFactory<ExpressionType> {
    private static final ExpressionTypeFactory INSTANCE = new ExpressionTypeFactory();
    private static final Interner<ExpressionType> INTERNER = Interners.newWeakInterner();

    public static ExpressionTypeFactory getInstance() {
        return INSTANCE;
    }

    private ExpressionTypeFactory() {
    }

    @Override
    public ExpressionType ofString() {
        return ExpressionType.STRING;
    }

    @Override
    public ExpressionType ofFloat() {
        throw new IllegalStateException("FLOAT types are not supported natively by Druid expressions");
    }

    @Override
    public ExpressionType ofDouble() {
        return ExpressionType.DOUBLE;
    }

    @Override
    public ExpressionType ofLong() {
        return ExpressionType.LONG;
    }

    @Override
    public ExpressionType ofArray(ExpressionType elementType) {
        if (elementType.isPrimitive()) {
            switch ((ExprType)elementType.getType()) {
                case STRING: {
                    return ExpressionType.STRING_ARRAY;
                }
                case DOUBLE: {
                    return ExpressionType.DOUBLE_ARRAY;
                }
                case LONG: {
                    return ExpressionType.LONG_ARRAY;
                }
            }
        }
        return (ExpressionType)INTERNER.intern((Object)new ExpressionType(ExprType.ARRAY, null, elementType));
    }

    @Override
    public ExpressionType ofComplex(@Nullable String complexTypeName) {
        return (ExpressionType)INTERNER.intern((Object)new ExpressionType(ExprType.COMPLEX, complexTypeName, null));
    }

    @Override
    public <T> TypeStrategy<T> getTypeStrategy(ExpressionType expressionType) {
        TypeStrategy<Long> strategy;
        switch ((ExprType)expressionType.getType()) {
            case LONG: {
                strategy = TypeStrategies.LONG;
                break;
            }
            case DOUBLE: {
                strategy = TypeStrategies.DOUBLE;
                break;
            }
            case STRING: {
                strategy = TypeStrategies.STRING;
                break;
            }
            case ARRAY: {
                strategy = new TypeStrategies.ArrayTypeStrategy(expressionType);
                break;
            }
            case COMPLEX: {
                TypeStrategy<?> complexStrategy = TypeStrategies.getComplex(expressionType.getComplexTypeName());
                if (complexStrategy == null) {
                    throw new IAE("Cannot find strategy for type [%s]", expressionType.asTypeString());
                }
                strategy = complexStrategy;
                break;
            }
            default: {
                throw new ISE("Unsupported expression type[%s]", expressionType.getType());
            }
        }
        return strategy;
    }
}

