/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.DictionaryScanningBitmapIndex;
import org.apache.druid.segment.index.semantic.DictionaryEncodedValueIndex;
import org.apache.druid.segment.index.semantic.DruidPredicateIndexes;

public class ExpressionPredicateIndexSupplier
implements ColumnIndexSupplier {
    private final Expr expr;
    private final String inputColumn;
    private final ExpressionType inputType;
    private final ColumnType outputType;
    private final DictionaryEncodedValueIndex<?> inputColumnIndexes;

    public ExpressionPredicateIndexSupplier(Expr expr, String inputColumn, ExpressionType inputType, ColumnType outputType, DictionaryEncodedValueIndex<?> inputColumnValueIndexes) {
        this.expr = expr;
        this.inputColumn = inputColumn;
        this.inputType = inputType;
        this.outputType = outputType;
        this.inputColumnIndexes = inputColumnValueIndexes;
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (clazz.equals(DruidPredicateIndexes.class)) {
            return (T)new ExpressionPredicateIndexes();
        }
        return null;
    }

    private Iterable<ImmutableBitmap> computeStringBitmaps(final DruidObjectPredicate<String> predicate, final Function<Object, ExprEval<?>> evalFunction, final boolean includeUnknown) {
        return () -> new BitmapIterator(this.inputColumnIndexes){

            @Override
            boolean nextMatches(@Nullable Object nextValue) {
                return predicate.apply(((ExprEval)evalFunction.apply(nextValue)).asString()).matches(includeUnknown);
            }
        };
    }

    private Iterable<ImmutableBitmap> computeLongBitmaps(final DruidLongPredicate predicate, final Function<Object, ExprEval<?>> evalFunction, final boolean includeUnknown) {
        return () -> new BitmapIterator(this.inputColumnIndexes){

            @Override
            boolean nextMatches(@Nullable Object nextValue) {
                ExprEval result = (ExprEval)evalFunction.apply(nextValue);
                if (result.isNumericNull()) {
                    return predicate.applyNull().matches(includeUnknown);
                }
                return predicate.applyLong(result.asLong()).matches(includeUnknown);
            }
        };
    }

    private Iterable<ImmutableBitmap> computeDoubleBitmaps(final DruidDoublePredicate predicate, final Function<Object, ExprEval<?>> evalFunction, final boolean includeUnknown) {
        return () -> new BitmapIterator(this.inputColumnIndexes){

            @Override
            boolean nextMatches(@Nullable Object nextValue) {
                ExprEval result = (ExprEval)evalFunction.apply(nextValue);
                if (result.isNumericNull()) {
                    return predicate.applyNull().matches(includeUnknown);
                }
                return predicate.applyDouble(result.asDouble()).matches(includeUnknown);
            }
        };
    }

    private Iterable<ImmutableBitmap> computeFloatBitmaps(final DruidFloatPredicate predicate, final Function<Object, ExprEval<?>> evalFunction, final boolean includeUnknown) {
        return () -> new BitmapIterator(this.inputColumnIndexes){

            @Override
            boolean nextMatches(@Nullable Object nextValue) {
                ExprEval result = (ExprEval)evalFunction.apply(nextValue);
                if (result.isNumericNull()) {
                    return predicate.applyNull().matches(includeUnknown);
                }
                return predicate.applyFloat((float)result.asDouble()).matches(includeUnknown);
            }
        };
    }

    private Iterable<ImmutableBitmap> computeArrayBitmaps(final DruidObjectPredicate<Object[]> predicate, final Function<Object, ExprEval<?>> evalFunction, final boolean includeUnknown) {
        return () -> new BitmapIterator(this.inputColumnIndexes){

            @Override
            boolean nextMatches(@Nullable Object nextValue) {
                Object[] result = ((ExprEval)evalFunction.apply(nextValue)).asArray();
                return predicate.apply(result).matches(includeUnknown);
            }
        };
    }

    private Iterable<ImmutableBitmap> computeObjectBitmaps(final DruidObjectPredicate<Object> predicate, final Function<Object, ExprEval<?>> evalFunction, final boolean includeUnknown) {
        return () -> new BitmapIterator(this.inputColumnIndexes){

            @Override
            boolean nextMatches(@Nullable Object nextValue) {
                Object result = ((ExprEval)evalFunction.apply(nextValue)).valueOrDefault();
                return predicate.apply(result).matches(includeUnknown);
            }
        };
    }

    private static abstract class BitmapIterator
    implements Iterator<ImmutableBitmap> {
        private final DictionaryEncodedValueIndex<?> inputColumnIndexes;
        int next;
        int index = 0;
        boolean nextSet = false;

        private BitmapIterator(DictionaryEncodedValueIndex<?> inputColumnIndexes) {
            this.inputColumnIndexes = inputColumnIndexes;
        }

        @Override
        public boolean hasNext() {
            if (!this.nextSet) {
                this.findNext();
            }
            return this.nextSet;
        }

        @Override
        public ImmutableBitmap next() {
            if (!this.nextSet) {
                this.findNext();
                if (!this.nextSet) {
                    throw new NoSuchElementException();
                }
            }
            this.nextSet = false;
            return this.inputColumnIndexes.getBitmap(this.next);
        }

        private void findNext() {
            while (!this.nextSet && this.index < this.inputColumnIndexes.getCardinality()) {
                Object nextValue = this.inputColumnIndexes.getValue(this.index);
                this.nextSet = this.nextMatches(nextValue);
                if (this.nextSet) {
                    this.next = this.index;
                }
                ++this.index;
            }
        }

        abstract boolean nextMatches(@Nullable Object var1);
    }

    private final class ExpressionPredicateIndexes
    implements DruidPredicateIndexes {
        private ExpressionPredicateIndexes() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            final Function<Object, ExprEval> evalFunction = inputValue -> ExpressionPredicateIndexSupplier.this.expr.eval(InputBindings.forInputSupplier(ExpressionPredicateIndexSupplier.this.inputColumn, ExpressionPredicateIndexSupplier.this.inputType, () -> inputValue));
            return new DictionaryScanningBitmapIndex(ExpressionPredicateIndexSupplier.this.inputColumnIndexes.getCardinality()){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable(boolean includeUnknown) {
                    switch ((ValueType)ExpressionPredicateIndexSupplier.this.outputType.getType()) {
                        case STRING: {
                            return ExpressionPredicateIndexSupplier.this.computeStringBitmaps(matcherFactory.makeStringPredicate(), evalFunction, includeUnknown);
                        }
                        case LONG: {
                            return ExpressionPredicateIndexSupplier.this.computeLongBitmaps(matcherFactory.makeLongPredicate(), evalFunction, includeUnknown);
                        }
                        case DOUBLE: {
                            return ExpressionPredicateIndexSupplier.this.computeDoubleBitmaps(matcherFactory.makeDoublePredicate(), evalFunction, includeUnknown);
                        }
                        case FLOAT: {
                            return ExpressionPredicateIndexSupplier.this.computeFloatBitmaps(matcherFactory.makeFloatPredicate(), evalFunction, includeUnknown);
                        }
                        case ARRAY: {
                            return ExpressionPredicateIndexSupplier.this.computeArrayBitmaps(matcherFactory.makeArrayPredicate(ExpressionPredicateIndexSupplier.this.outputType), evalFunction, includeUnknown);
                        }
                    }
                    return ExpressionPredicateIndexSupplier.this.computeObjectBitmaps(matcherFactory.makeObjectPredicate(), evalFunction, includeUnknown);
                }
            };
        }
    }
}

