/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.ListBasedInputRowAdapter;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.utils.CompressionUtils;

public abstract class FlatTextInputFormat
implements InputFormat {
    private final List<String> columns;
    private final String listDelimiter;
    private final String delimiter;
    private final boolean findColumnsFromHeader;
    private final int skipHeaderRows;
    private final boolean tryParseNumbers;

    FlatTextInputFormat(@Nullable List<String> columns, @Nullable String listDelimiter, String delimiter, @Nullable Boolean hasHeaderRow, @Nullable Boolean findColumnsFromHeader, int skipHeaderRows, @Nullable Boolean tryParseNumbers) {
        this.columns = columns == null ? Collections.emptyList() : columns;
        this.listDelimiter = listDelimiter;
        this.delimiter = (String)Preconditions.checkNotNull((Object)delimiter, (Object)"delimiter");
        if (columns == null || columns.isEmpty()) {
            if (hasHeaderRow != null && findColumnsFromHeader != null) {
                throw new IAE("Cannot accept both [findColumnsFromHeader] and [hasHeaderRow]", new Object[0]);
            }
            if (hasHeaderRow == null && findColumnsFromHeader == null) {
                throw new IAE("Either [columns] or [findColumnsFromHeader] must be set", new Object[0]);
            }
            this.findColumnsFromHeader = hasHeaderRow != null ? hasHeaderRow : findColumnsFromHeader;
        } else {
            this.findColumnsFromHeader = findColumnsFromHeader == null ? false : findColumnsFromHeader;
        }
        this.skipHeaderRows = skipHeaderRows;
        Preconditions.checkArgument((!delimiter.equals(listDelimiter) ? 1 : 0) != 0, (String)"Cannot have same delimiter and list delimiter of [%s]", (Object)delimiter);
        boolean bl = this.tryParseNumbers = tryParseNumbers == null ? false : tryParseNumbers;
        if (!this.columns.isEmpty()) {
            for (String column : this.columns) {
                Preconditions.checkArgument((!column.contains(delimiter) ? 1 : 0) != 0, (String)("Column[%s] cannot have the delimiter[" + delimiter + "] in its name"), (Object)column);
            }
        } else {
            Preconditions.checkArgument((boolean)this.findColumnsFromHeader, (Object)"If [columns] is not set, the first row of your data must have your header and [findColumnsFromHeader] must be set to true.");
        }
    }

    @JsonProperty
    public String getDelimiter() {
        return this.delimiter;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getColumns() {
        return this.columns;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getListDelimiter() {
        return this.listDelimiter;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isFindColumnsFromHeader() {
        return this.findColumnsFromHeader;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int getSkipHeaderRows() {
        return this.skipHeaderRows;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean shouldTryParseNumbers() {
        return this.tryParseNumbers;
    }

    @Override
    public long getWeightedSize(String path, long size) {
        CompressionUtils.Format compressionFormat = CompressionUtils.Format.fromFileName(path);
        if (CompressionUtils.Format.GZ == compressionFormat) {
            return size * 4L;
        }
        return size;
    }

    @Override
    public RowAdapter<InputRow> createRowAdapter(InputRowSchema inputRowSchema) {
        if (this.useListBasedInputRows()) {
            RowSignature.Builder builder = RowSignature.builder();
            for (String column : this.columns) {
                builder.add(column, null);
            }
            return new ListBasedInputRowAdapter(builder.build());
        }
        return RowAdapters.standardRow();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlatTextInputFormat that = (FlatTextInputFormat)o;
        return this.findColumnsFromHeader == that.findColumnsFromHeader && this.skipHeaderRows == that.skipHeaderRows && Objects.equals(this.listDelimiter, that.listDelimiter) && Objects.equals(this.columns, that.columns) && Objects.equals(this.delimiter, that.delimiter);
    }

    public int hashCode() {
        return Objects.hash(this.listDelimiter, this.columns, this.findColumnsFromHeader, this.skipHeaderRows, this.delimiter);
    }

    protected boolean useListBasedInputRows() {
        return !this.columns.isEmpty() && !this.findColumnsFromHeader;
    }

    protected String fieldsToString() {
        return "FlatTextInputFormat{delimiter=\"" + this.delimiter + "\"listDelimiter=" + (String)(this.listDelimiter == null ? "null" : "\"" + this.listDelimiter + "\"") + ", findColumnsFromHeader=" + this.findColumnsFromHeader + ", skipHeaderRows=" + this.skipHeaderRows + ", columns=" + this.columns + "}";
    }
}

