/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.segment.column.ValueType;

public final class Rows {
    public static List<Object> toGroupKey(long timeStamp, InputRow inputRow) {
        TreeMap<String, ImmutableSortedSet> dims = new TreeMap<String, ImmutableSortedSet>();
        for (String dim : inputRow.getDimensions()) {
            ImmutableSortedSet dimValues = ImmutableSortedSet.copyOf(inputRow.getDimension(dim));
            if (dimValues.size() <= 0) continue;
            dims.put(dim, dimValues);
        }
        return ImmutableList.of((Object)timeStamp, dims);
    }

    public static List<String> objectToStrings(Object inputValue) {
        if (inputValue == null) {
            return Collections.emptyList();
        }
        if (inputValue instanceof List) {
            return ((List)inputValue).stream().map(String::valueOf).collect(Collectors.toList());
        }
        if (inputValue instanceof byte[]) {
            byte[] array = (byte[])inputValue;
            return Rows.objectToStringsByteA(array);
        }
        if (inputValue instanceof ByteBuffer) {
            byte[] array = ((ByteBuffer)inputValue).array();
            return Rows.objectToStringsByteA(array);
        }
        if (inputValue instanceof Object[]) {
            return Arrays.stream((Object[])inputValue).map(String::valueOf).collect(Collectors.toList());
        }
        return Collections.singletonList(String.valueOf(inputValue));
    }

    private static List<String> objectToStringsByteA(byte[] array) {
        return Collections.singletonList(StringUtils.encodeBase64String(array));
    }

    @Nullable
    public static Number objectToNumber(String name, Object inputValue, @Nullable ValueType outputType, boolean throwParseExceptions) {
        Number asNumber;
        if (outputType != null && !outputType.isNumeric()) {
            throw new IAE("Output type[%s] must be numeric", outputType);
        }
        if (inputValue == null) {
            asNumber = null;
        } else if (inputValue instanceof Number) {
            asNumber = (Number)inputValue;
        } else if (inputValue instanceof String) {
            try {
                String metricValueString = StringUtils.removeChar(((String)inputValue).trim(), ',');
                metricValueString = Rows.trimLeadingPlusOfLongString(metricValueString);
                Number v = null;
                if (outputType == null || outputType == ValueType.LONG) {
                    v = Longs.tryParse((String)metricValueString);
                }
                if (v == null) {
                    v = Double.valueOf(metricValueString);
                }
                asNumber = v;
            }
            catch (Exception e) {
                if (throwParseExceptions) {
                    throw new ParseException(String.valueOf(inputValue), (Throwable)e, "Unable to parse value[%s] for field[%s]", inputValue, name);
                }
                return null;
            }
        } else {
            if (throwParseExceptions) {
                throw new ParseException(String.valueOf(inputValue), "Unknown type[%s] for field[%s]", inputValue.getClass(), name);
            }
            return null;
        }
        if (outputType == null || asNumber == null) {
            return asNumber;
        }
        if (outputType == ValueType.LONG) {
            return asNumber.longValue();
        }
        if (outputType == ValueType.FLOAT) {
            return Float.valueOf(asNumber.floatValue());
        }
        if (outputType == ValueType.DOUBLE) {
            return asNumber.doubleValue();
        }
        throw new ISE("Cannot read number as type[%s]", outputType);
    }

    public static Number objectToNumber(String name, Object inputValue, boolean throwParseExceptions) {
        return Rows.objectToNumber(name, inputValue, null, throwParseExceptions);
    }

    private static String trimLeadingPlusOfLongString(String metricValueString) {
        char secondChar;
        if (metricValueString.length() > 1 && metricValueString.charAt(0) == '+' && (secondChar = metricValueString.charAt(1)) >= '0' && secondChar <= '9') {
            metricValueString = metricValueString.substring(1);
        }
        return metricValueString;
    }

    private Rows() {
    }
}

