/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="LeaseSpec is a specification of a Lease.")
public class V1LeaseSpec {
    public static final String SERIALIZED_NAME_ACQUIRE_TIME = "acquireTime";
    @SerializedName(value="acquireTime")
    private OffsetDateTime acquireTime;
    public static final String SERIALIZED_NAME_HOLDER_IDENTITY = "holderIdentity";
    @SerializedName(value="holderIdentity")
    private String holderIdentity;
    public static final String SERIALIZED_NAME_LEASE_DURATION_SECONDS = "leaseDurationSeconds";
    @SerializedName(value="leaseDurationSeconds")
    private Integer leaseDurationSeconds;
    public static final String SERIALIZED_NAME_LEASE_TRANSITIONS = "leaseTransitions";
    @SerializedName(value="leaseTransitions")
    private Integer leaseTransitions;
    public static final String SERIALIZED_NAME_RENEW_TIME = "renewTime";
    @SerializedName(value="renewTime")
    private OffsetDateTime renewTime;

    public V1LeaseSpec acquireTime(OffsetDateTime acquireTime) {
        this.acquireTime = acquireTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="acquireTime is a time when the current lease was acquired.")
    public OffsetDateTime getAcquireTime() {
        return this.acquireTime;
    }

    public void setAcquireTime(OffsetDateTime acquireTime) {
        this.acquireTime = acquireTime;
    }

    public V1LeaseSpec holderIdentity(String holderIdentity) {
        this.holderIdentity = holderIdentity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="holderIdentity contains the identity of the holder of a current lease.")
    public String getHolderIdentity() {
        return this.holderIdentity;
    }

    public void setHolderIdentity(String holderIdentity) {
        this.holderIdentity = holderIdentity;
    }

    public V1LeaseSpec leaseDurationSeconds(Integer leaseDurationSeconds) {
        this.leaseDurationSeconds = leaseDurationSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="leaseDurationSeconds is a duration that candidates for a lease need to wait to force acquire it. This is measure against time of last observed renewTime.")
    public Integer getLeaseDurationSeconds() {
        return this.leaseDurationSeconds;
    }

    public void setLeaseDurationSeconds(Integer leaseDurationSeconds) {
        this.leaseDurationSeconds = leaseDurationSeconds;
    }

    public V1LeaseSpec leaseTransitions(Integer leaseTransitions) {
        this.leaseTransitions = leaseTransitions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="leaseTransitions is the number of transitions of a lease between holders.")
    public Integer getLeaseTransitions() {
        return this.leaseTransitions;
    }

    public void setLeaseTransitions(Integer leaseTransitions) {
        this.leaseTransitions = leaseTransitions;
    }

    public V1LeaseSpec renewTime(OffsetDateTime renewTime) {
        this.renewTime = renewTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="renewTime is a time when the current holder of a lease has last updated the lease.")
    public OffsetDateTime getRenewTime() {
        return this.renewTime;
    }

    public void setRenewTime(OffsetDateTime renewTime) {
        this.renewTime = renewTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LeaseSpec v1LeaseSpec = (V1LeaseSpec)o;
        return Objects.equals(this.acquireTime, v1LeaseSpec.acquireTime) && Objects.equals(this.holderIdentity, v1LeaseSpec.holderIdentity) && Objects.equals(this.leaseDurationSeconds, v1LeaseSpec.leaseDurationSeconds) && Objects.equals(this.leaseTransitions, v1LeaseSpec.leaseTransitions) && Objects.equals(this.renewTime, v1LeaseSpec.renewTime);
    }

    public int hashCode() {
        return Objects.hash(this.acquireTime, this.holderIdentity, this.leaseDurationSeconds, this.leaseTransitions, this.renewTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LeaseSpec {\n");
        sb.append("    acquireTime: ").append(this.toIndentedString(this.acquireTime)).append("\n");
        sb.append("    holderIdentity: ").append(this.toIndentedString(this.holderIdentity)).append("\n");
        sb.append("    leaseDurationSeconds: ").append(this.toIndentedString(this.leaseDurationSeconds)).append("\n");
        sb.append("    leaseTransitions: ").append(this.toIndentedString(this.leaseTransitions)).append("\n");
        sb.append("    renewTime: ").append(this.toIndentedString(this.renewTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

