/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.rvesse.airline.annotations.Command;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.druid.cli.CliOverlord;
import org.apache.druid.cli.CoordinatorJettyServerInitializer;
import org.apache.druid.cli.CoordinatorOverlordRedirectInfo;
import org.apache.druid.cli.ServerRunnable;
import org.apache.druid.client.CoordinatorSegmentWatcherConfig;
import org.apache.druid.client.CoordinatorServerView;
import org.apache.druid.client.DirectDruidClientFactory;
import org.apache.druid.client.HttpServerInventoryViewResource;
import org.apache.druid.client.InternalQueryConfig;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.DruidBinders;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.guice.SupervisorCleanupModule;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.http.JettyHttpClientModule;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ExecutorServices;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.metadata.MetadataRuleManagerConfig;
import org.apache.druid.metadata.MetadataRuleManagerProvider;
import org.apache.druid.metadata.MetadataStorage;
import org.apache.druid.metadata.MetadataStorageProvider;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SegmentsMetadataManagerProvider;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.MapQueryToolChestWarehouse;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.RetryQueryRunnerConfig;
import org.apache.druid.query.lookup.LookupSerdeModule;
import org.apache.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.druid.query.metadata.SegmentMetadataQueryRunnerFactory;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.CoordinatorSegmentMetadataCache;
import org.apache.druid.segment.metadata.SegmentMetadataCacheConfig;
import org.apache.druid.segment.metadata.SegmentMetadataQuerySegmentWalker;
import org.apache.druid.segment.metadata.SegmentSchemaCache;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QuerySchedulerProvider;
import org.apache.druid.server.compaction.CompactionStatusTracker;
import org.apache.druid.server.coordinator.CoordinatorConfigManager;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.MetadataManager;
import org.apache.druid.server.coordinator.balancer.BalancerStrategyFactory;
import org.apache.druid.server.coordinator.config.CoordinatorKillConfigs;
import org.apache.druid.server.coordinator.config.CoordinatorPeriodConfig;
import org.apache.druid.server.coordinator.config.CoordinatorRunConfig;
import org.apache.druid.server.coordinator.config.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.config.HttpLoadQueuePeonConfig;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDuty;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDutyGroup;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDutyGroups;
import org.apache.druid.server.coordinator.loading.LoadQueueTaskMaster;
import org.apache.druid.server.http.ClusterResource;
import org.apache.druid.server.http.CoordinatorCompactionConfigsResource;
import org.apache.druid.server.http.CoordinatorCompactionResource;
import org.apache.druid.server.http.CoordinatorDynamicConfigsResource;
import org.apache.druid.server.http.CoordinatorRedirectInfo;
import org.apache.druid.server.http.CoordinatorResource;
import org.apache.druid.server.http.DataSourcesResource;
import org.apache.druid.server.http.IntervalsResource;
import org.apache.druid.server.http.LookupCoordinatorResource;
import org.apache.druid.server.http.MetadataResource;
import org.apache.druid.server.http.RedirectFilter;
import org.apache.druid.server.http.RedirectInfo;
import org.apache.druid.server.http.RulesResource;
import org.apache.druid.server.http.SelfDiscoveryResource;
import org.apache.druid.server.http.ServersResource;
import org.apache.druid.server.http.TiersResource;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.lookup.cache.LookupCoordinatorManager;
import org.apache.druid.server.lookup.cache.LookupCoordinatorManagerConfig;
import org.apache.druid.storage.local.LocalTmpStorageConfig;
import org.eclipse.jetty.server.Server;
import org.joda.time.Duration;

@Command(name="coordinator", description="Runs the Coordinator, see https://druid.apache.org/docs/latest/Coordinator.html for a description.")
public class CliCoordinator
extends ServerRunnable {
    private static final Logger log = new Logger(CliCoordinator.class);
    private static final String AS_OVERLORD_PROPERTY = "druid.coordinator.asOverlord.enabled";
    private Properties properties;
    private boolean beOverlord;
    private boolean isSegmentMetadataCacheEnabled;

    public CliCoordinator() {
        super(log);
    }

    @Inject
    public void configure(Properties properties) {
        this.properties = properties;
        this.beOverlord = CliCoordinator.isOverlord(properties);
        this.isSegmentMetadataCacheEnabled = CliCoordinator.isSegmentMetadataCacheEnabled(properties);
        if (this.beOverlord) {
            log.info("Coordinator is configured to act as Overlord as well (%s = true).", new Object[]{AS_OVERLORD_PROPERTY});
        }
    }

    @Override
    protected Set<NodeRole> getNodeRoles(Properties properties) {
        return CliCoordinator.isOverlord(properties) ? ImmutableSet.of((Object)NodeRole.COORDINATOR, (Object)NodeRole.OVERLORD) : ImmutableSet.of((Object)NodeRole.COORDINATOR);
    }

    @Override
    protected List<? extends Module> getModules() {
        ArrayList<Object> modules = new ArrayList<Object>();
        modules.add(JettyHttpClientModule.global());
        if (this.isSegmentMetadataCacheEnabled) {
            CliCoordinator.validateCentralizedDatasourceSchemaConfig(this.properties);
            modules.add(new CoordinatorSegmentMetadataCacheModule());
            modules.add(new QueryableModule());
        }
        modules.add(new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/coordinator");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8081);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(8281);
                binder.bind(MetadataStorage.class).toProvider(MetadataStorageProvider.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.manager.segments", SegmentsMetadataManagerConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.manager.rules", MetadataRuleManagerConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.manager.lookups", LookupCoordinatorManagerConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator", CoordinatorRunConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.kill", CoordinatorKillConfigs.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.period", CoordinatorPeriodConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.loadqueuepeon.http", HttpLoadQueuePeonConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.balancer", BalancerStrategyFactory.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.segment", CoordinatorSegmentWatcherConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.segmentMetadataCache", SegmentMetadataCacheConfig.class);
                binder.bind(DruidCoordinatorConfig.class);
                binder.bind(RedirectFilter.class).in(LazySingleton.class);
                if (CliCoordinator.this.beOverlord) {
                    binder.bind(RedirectInfo.class).to(CoordinatorOverlordRedirectInfo.class).in(LazySingleton.class);
                } else {
                    binder.bind(RedirectInfo.class).to(CoordinatorRedirectInfo.class).in(LazySingleton.class);
                }
                LifecycleModule.register((Binder)binder, CoordinatorServerView.class);
                if (!CliCoordinator.this.isSegmentMetadataCacheEnabled) {
                    binder.bind(CoordinatorSegmentMetadataCache.class).toProvider(Providers.of(null));
                    binder.bind(DirectDruidClientFactory.class).toProvider(Providers.of(null));
                }
                binder.bind(SegmentsMetadataManager.class).toProvider(SegmentsMetadataManagerProvider.class).in(ManageLifecycle.class);
                binder.bind(MetadataRuleManager.class).toProvider(MetadataRuleManagerProvider.class).in(ManageLifecycle.class);
                binder.bind(LookupCoordinatorManager.class).in(LazySingleton.class);
                binder.bind(CoordinatorConfigManager.class);
                binder.bind(MetadataManager.class);
                binder.bind(DruidCoordinator.class);
                binder.bind(CompactionStatusTracker.class).in(LazySingleton.class);
                LifecycleModule.register((Binder)binder, MetadataStorage.class);
                LifecycleModule.register((Binder)binder, DruidCoordinator.class);
                binder.bind(JettyServerInitializer.class).to(CoordinatorJettyServerInitializer.class);
                Jerseys.addResource((Binder)binder, CoordinatorResource.class);
                Jerseys.addResource((Binder)binder, CoordinatorCompactionResource.class);
                Jerseys.addResource((Binder)binder, CoordinatorDynamicConfigsResource.class);
                Jerseys.addResource((Binder)binder, CoordinatorCompactionConfigsResource.class);
                Jerseys.addResource((Binder)binder, TiersResource.class);
                Jerseys.addResource((Binder)binder, RulesResource.class);
                Jerseys.addResource((Binder)binder, ServersResource.class);
                Jerseys.addResource((Binder)binder, DataSourcesResource.class);
                Jerseys.addResource((Binder)binder, MetadataResource.class);
                Jerseys.addResource((Binder)binder, IntervalsResource.class);
                Jerseys.addResource((Binder)binder, LookupCoordinatorResource.class);
                Jerseys.addResource((Binder)binder, ClusterResource.class);
                Jerseys.addResource((Binder)binder, HttpServerInventoryViewResource.class);
                LifecycleModule.register((Binder)binder, Server.class);
                LifecycleModule.register((Binder)binder, DataSourcesResource.class);
                ServerRunnable.bindAnnouncer(binder, Coordinator.class, ServerRunnable.DiscoverySideEffectsProvider.create());
                Jerseys.addResource((Binder)binder, SelfDiscoveryResource.class);
                LifecycleModule.registerKey((Binder)binder, (Key)Key.get(SelfDiscoveryResource.class));
                if (!CliCoordinator.this.beOverlord) {
                    binder.bind((TypeLiteral)new TypeLiteral<Supplier<Map<String, Object>>>(){}).annotatedWith((Annotation)Names.named((String)"heartbeat")).toProvider(HeartbeatSupplier.class);
                    binder.bind(LocalTmpStorageConfig.class).toProvider((Provider)new LocalTmpStorageConfig.DefaultLocalTmpStorageConfigProvider("coordinator")).in(LazySingleton.class);
                }
                binder.bind(CoordinatorCustomDutyGroups.class).toProvider((Provider)new CoordinatorCustomDutyGroupsProvider()).in(LazySingleton.class);
            }

            @Provides
            @LazySingleton
            public LoadQueueTaskMaster getLoadQueueTaskMaster(ObjectMapper jsonMapper, ScheduledExecutorFactory factory, DruidCoordinatorConfig config, @EscalatedGlobal HttpClient httpClient, Lifecycle lifecycle) {
                ExecutorService callBackExec = Execs.singleThreaded((String)"LoadQueuePeon-callbackexec--%d");
                ExecutorServices.manageLifecycle((Lifecycle)lifecycle, (ExecutorService)callBackExec);
                return new LoadQueueTaskMaster(jsonMapper, factory.create(1, "Master-PeonExec--%d"), callBackExec, config.getHttpLoadQueuePeonConfig(), httpClient);
            }
        });
        if (this.beOverlord) {
            CliOverlord cliOverlord = new CliOverlord();
            cliOverlord.configure(this.properties);
            modules.addAll(cliOverlord.getModules(false));
        } else {
            modules.add(new LookupSerdeModule());
            modules.add(new SupervisorCleanupModule());
        }
        return modules;
    }

    public static boolean isOverlord(Properties properties) {
        return Boolean.parseBoolean(properties.getProperty(AS_OVERLORD_PROPERTY));
    }

    private static class CoordinatorSegmentMetadataCacheModule
    implements Module {
        private CoordinatorSegmentMetadataCacheModule() {
        }

        public void configure(Binder binder) {
            JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.segmentMetadata", SegmentMetadataQueryConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.query.scheduler", QuerySchedulerProvider.class, Global.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.query.default", DefaultQueryConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.query.retryPolicy", RetryQueryRunnerConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.internal.query.config", InternalQueryConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.centralizedDatasourceSchema", CentralizedDatasourceSchemaConfig.class);
            MapBinder toolChests = DruidBinders.queryToolChestBinder((Binder)binder);
            toolChests.addBinding(SegmentMetadataQuery.class).to(SegmentMetadataQueryQueryToolChest.class);
            binder.bind(SegmentMetadataQueryQueryToolChest.class).in(LazySingleton.class);
            binder.bind(QueryToolChestWarehouse.class).to(MapQueryToolChestWarehouse.class);
            MapBinder queryFactoryBinder = DruidBinders.queryRunnerFactoryBinder((Binder)binder);
            queryFactoryBinder.addBinding(SegmentMetadataQuery.class).to(SegmentMetadataQueryRunnerFactory.class);
            DruidBinders.queryBinder((Binder)binder);
            binder.bind(SegmentMetadataQueryRunnerFactory.class).in(LazySingleton.class);
            binder.bind(GenericQueryMetricsFactory.class).to(DefaultGenericQueryMetricsFactory.class);
            binder.bind(QueryScheduler.class).toProvider(Key.get(QuerySchedulerProvider.class, Global.class)).in(LazySingleton.class);
            binder.bind(QuerySchedulerProvider.class).in(LazySingleton.class);
            binder.bind(SegmentSchemaCache.class).in(LazySingleton.class);
            binder.bind(QuerySegmentWalker.class).to(SegmentMetadataQuerySegmentWalker.class).in(LazySingleton.class);
            LifecycleModule.register((Binder)binder, CoordinatorSegmentMetadataCache.class);
        }

        @LazySingleton
        @Provides
        public QueryWatcher getWatcher(QueryScheduler scheduler) {
            return scheduler;
        }
    }

    private static class HeartbeatSupplier
    implements Provider<Supplier<Map<String, Object>>> {
        private final DruidLeaderSelector leaderSelector;

        @Inject
        public HeartbeatSupplier(@Coordinator DruidLeaderSelector leaderSelector) {
            this.leaderSelector = leaderSelector;
        }

        public Supplier<Map<String, Object>> get() {
            return () -> {
                HashMap<String, Integer> heartbeatTags = new HashMap<String, Integer>();
                heartbeatTags.put("leader", this.leaderSelector.isLeader() ? 1 : 0);
                return heartbeatTags;
            };
        }
    }

    private static class CoordinatorCustomDutyGroupsProvider
    implements Provider<CoordinatorCustomDutyGroups> {
        private Properties props;
        private JsonConfigurator configurator;
        private ObjectMapper jsonMapper;

        private CoordinatorCustomDutyGroupsProvider() {
        }

        @Inject
        public void inject(Properties props, JsonConfigurator configurator, ObjectMapper jsonMapper) {
            this.props = props;
            this.configurator = configurator;
            this.jsonMapper = jsonMapper;
        }

        public CoordinatorCustomDutyGroups get() {
            try {
                HashSet<CoordinatorCustomDutyGroup> coordinatorCustomDutyGroups = new HashSet<CoordinatorCustomDutyGroup>();
                if (Strings.isNullOrEmpty((String)this.props.getProperty("druid.coordinator.dutyGroups"))) {
                    return new CoordinatorCustomDutyGroups(coordinatorCustomDutyGroups);
                }
                List coordinatorCustomDutyGroupNames = (List)this.jsonMapper.readValue(this.props.getProperty("druid.coordinator.dutyGroups"), (TypeReference)new TypeReference<List<String>>(){});
                for (String coordinatorCustomDutyGroupName : coordinatorCustomDutyGroupNames) {
                    String dutyListProperty = StringUtils.format((String)"druid.coordinator.%s.duties", (Object[])new Object[]{coordinatorCustomDutyGroupName});
                    if (Strings.isNullOrEmpty((String)this.props.getProperty(dutyListProperty))) {
                        throw new IAE("Coordinator custom duty group given without any duty for group %s", new Object[]{coordinatorCustomDutyGroupName});
                    }
                    List dutyForGroup = (List)this.jsonMapper.readValue(this.props.getProperty(dutyListProperty), (TypeReference)new TypeReference<List<String>>(){});
                    ArrayList<CoordinatorCustomDuty> coordinatorCustomDuties = new ArrayList<CoordinatorCustomDuty>();
                    for (String dutyName : dutyForGroup) {
                        String dutyPropertyBase = StringUtils.format((String)"druid.coordinator.%s.duty.%s", (Object[])new Object[]{coordinatorCustomDutyGroupName, dutyName});
                        JsonConfigProvider coordinatorCustomDutyProvider = JsonConfigProvider.of((String)dutyPropertyBase, CoordinatorCustomDuty.class);
                        Properties adjustedProps = new Properties(this.props);
                        String typeProperty = StringUtils.format((String)"%s.type", (Object[])new Object[]{dutyPropertyBase});
                        if (adjustedProps.containsKey(typeProperty)) {
                            throw new IAE("'type' property [%s] is reserved.", new Object[]{typeProperty});
                        }
                        adjustedProps.put(typeProperty, dutyName);
                        coordinatorCustomDutyProvider.inject(adjustedProps, this.configurator);
                        CoordinatorCustomDuty coordinatorCustomDuty = (CoordinatorCustomDuty)coordinatorCustomDutyProvider.get();
                        if (coordinatorCustomDuty == null) {
                            throw new ISE("Could not create CoordinatorCustomDuty with name: %s for group: %s", new Object[]{dutyName, coordinatorCustomDutyGroupName});
                        }
                        coordinatorCustomDuties.add(coordinatorCustomDuty);
                    }
                    String groupPeriodPropKey = StringUtils.format((String)"druid.coordinator.%s.period", (Object[])new Object[]{coordinatorCustomDutyGroupName});
                    if (Strings.isNullOrEmpty((String)this.props.getProperty(groupPeriodPropKey))) {
                        throw new IAE("Run period for coordinator custom duty group must be set for group %s", new Object[]{coordinatorCustomDutyGroupName});
                    }
                    Duration groupPeriod = new Duration((Object)this.props.getProperty(groupPeriodPropKey));
                    coordinatorCustomDutyGroups.add(new CoordinatorCustomDutyGroup(coordinatorCustomDutyGroupName, groupPeriod, coordinatorCustomDuties));
                }
                return new CoordinatorCustomDutyGroups(coordinatorCustomDutyGroups);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

