/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.s3;

import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterators;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.common.aws.AWSClientConfig;
import org.apache.druid.common.aws.AWSEndpointConfig;
import org.apache.druid.common.aws.AWSProxyConfig;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.impl.CloudObjectInputSource;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.data.input.impl.CloudObjectSplitWidget;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.data.input.impl.systemfield.SystemField;
import org.apache.druid.data.input.impl.systemfield.SystemFields;
import org.apache.druid.data.input.s3.S3Entity;
import org.apache.druid.data.input.s3.S3InputSourceConfig;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.s3.S3InputDataConfig;
import org.apache.druid.storage.s3.S3Utils;
import org.apache.druid.storage.s3.ServerSideEncryptingAmazonS3;

public class S3InputSource
extends CloudObjectInputSource {
    public static final String TYPE_KEY = "s3";
    private final Supplier<ServerSideEncryptingAmazonS3> s3ClientSupplier;
    @JsonProperty(value="properties")
    private final S3InputSourceConfig s3InputSourceConfig;
    private final S3InputDataConfig inputDataConfig;
    private final AWSProxyConfig awsProxyConfig;
    private final AWSClientConfig awsClientConfig;
    private final AWSEndpointConfig awsEndpointConfig;
    private int maxRetries;

    @JsonCreator
    public S3InputSource(@JacksonInject ServerSideEncryptingAmazonS3 s3Client, @JacksonInject ServerSideEncryptingAmazonS3.Builder s3ClientBuilder, @JacksonInject S3InputDataConfig inputDataConfig, @JacksonInject AWSCredentialsProvider awsCredentialsProvider, @JsonProperty(value="uris") @Nullable List<URI> uris, @JsonProperty(value="prefixes") @Nullable List<URI> prefixes, @JsonProperty(value="objects") @Nullable List<CloudObjectLocation> objects, @JsonProperty(value="objectGlob") @Nullable String objectGlob, @JsonProperty(value="systemFields") @Nullable SystemFields systemFields, @JsonProperty(value="properties") @Nullable S3InputSourceConfig s3InputSourceConfig, @JsonProperty(value="proxyConfig") @Nullable AWSProxyConfig awsProxyConfig, @JsonProperty(value="endpointConfig") @Nullable AWSEndpointConfig awsEndpointConfig, @JsonProperty(value="clientConfig") @Nullable AWSClientConfig awsClientConfig) {
        super(TYPE_KEY, uris, prefixes, objects, objectGlob, systemFields);
        this.inputDataConfig = (S3InputDataConfig)Preconditions.checkNotNull((Object)inputDataConfig, (Object)"S3DataSegmentPusherConfig");
        Preconditions.checkNotNull((Object)s3Client, (Object)"s3Client");
        this.s3InputSourceConfig = s3InputSourceConfig;
        this.awsProxyConfig = awsProxyConfig;
        this.awsClientConfig = awsClientConfig;
        this.awsEndpointConfig = awsEndpointConfig;
        this.s3ClientSupplier = Suppliers.memoize(() -> {
            if (s3ClientBuilder != null && s3InputSourceConfig != null) {
                if (awsEndpointConfig != null && awsEndpointConfig.getUrl() != null) {
                    s3ClientBuilder.getAmazonS3ClientBuilder().setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(awsEndpointConfig.getUrl(), awsEndpointConfig.getSigningRegion()));
                    if (awsClientConfig != null) {
                        ((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)s3ClientBuilder.getAmazonS3ClientBuilder().withChunkedEncodingDisabled(Boolean.valueOf(awsClientConfig.isDisableChunkedEncoding()))).withPathStyleAccessEnabled(Boolean.valueOf(awsClientConfig.isEnablePathStyleAccess()))).withForceGlobalBucketAccessEnabled(Boolean.valueOf(awsClientConfig.isForceGlobalBucketAccessEnabled()));
                        if (awsProxyConfig != null) {
                            Protocol protocol = S3Utils.determineProtocol(awsClientConfig, awsEndpointConfig);
                            s3ClientBuilder.getAmazonS3ClientBuilder().withClientConfiguration(S3Utils.setProxyConfig(s3ClientBuilder.getAmazonS3ClientBuilder().getClientConfiguration(), awsProxyConfig).withProtocol(protocol));
                        }
                    }
                }
                if (s3InputSourceConfig.isCredentialsConfigured()) {
                    if (s3InputSourceConfig.getAssumeRoleArn() == null) {
                        s3ClientBuilder.getAmazonS3ClientBuilder().withCredentials((AWSCredentialsProvider)this.createStaticCredentialsProvider(s3InputSourceConfig));
                    } else {
                        this.applyAssumeRole(s3ClientBuilder, s3InputSourceConfig, (AWSCredentialsProvider)this.createStaticCredentialsProvider(s3InputSourceConfig));
                    }
                } else {
                    this.applyAssumeRole(s3ClientBuilder, s3InputSourceConfig, awsCredentialsProvider);
                }
                return s3ClientBuilder.build();
            }
            return s3Client;
        });
        this.maxRetries = 10;
    }

    @VisibleForTesting
    S3InputSource(ServerSideEncryptingAmazonS3 s3Client, ServerSideEncryptingAmazonS3.Builder s3ClientBuilder, S3InputDataConfig inputDataConfig, List<URI> uris, List<URI> prefixes, List<CloudObjectLocation> objects, String objectGlob, S3InputSourceConfig s3InputSourceConfig, AWSProxyConfig awsProxyConfig, AWSEndpointConfig awsEndpointConfig, AWSClientConfig awsClientConfig) {
        this(s3Client, s3ClientBuilder, inputDataConfig, null, uris, prefixes, objects, objectGlob, SystemFields.none(), s3InputSourceConfig, awsProxyConfig, awsEndpointConfig, awsClientConfig);
    }

    @VisibleForTesting
    public S3InputSource(ServerSideEncryptingAmazonS3 s3Client, ServerSideEncryptingAmazonS3.Builder s3ClientBuilder, S3InputDataConfig inputDataConfig, List<URI> uris, List<URI> prefixes, List<CloudObjectLocation> objects, String objectGlob, SystemFields systemFields, S3InputSourceConfig s3InputSourceConfig, AWSProxyConfig awsProxyConfig, AWSEndpointConfig awsEndpointConfig, AWSClientConfig awsClientConfig, int maxRetries) {
        this(s3Client, s3ClientBuilder, inputDataConfig, null, uris, prefixes, objects, objectGlob, systemFields, s3InputSourceConfig, awsProxyConfig, awsEndpointConfig, awsClientConfig);
        this.maxRetries = maxRetries;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getTypes() {
        return Collections.singleton(TYPE_KEY);
    }

    private void applyAssumeRole(ServerSideEncryptingAmazonS3.Builder s3ClientBuilder, S3InputSourceConfig s3InputSourceConfig, AWSCredentialsProvider awsCredentialsProvider) {
        String assumeRoleArn = s3InputSourceConfig.getAssumeRoleArn();
        if (assumeRoleArn != null) {
            String roleSessionName = StringUtils.format((String)"druid-s3-input-source-%s", (Object[])new Object[]{UUID.randomUUID().toString()});
            AWSSecurityTokenService securityTokenService = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials(awsCredentialsProvider)).build();
            STSAssumeRoleSessionCredentialsProvider.Builder roleCredentialsProviderBuilder = new STSAssumeRoleSessionCredentialsProvider.Builder(assumeRoleArn, roleSessionName).withStsClient(securityTokenService);
            if (s3InputSourceConfig.getAssumeRoleExternalId() != null) {
                roleCredentialsProviderBuilder.withExternalId(s3InputSourceConfig.getAssumeRoleExternalId());
            }
            s3ClientBuilder.getAmazonS3ClientBuilder().withCredentials((AWSCredentialsProvider)roleCredentialsProviderBuilder.build());
        }
    }

    @Nonnull
    private AWSStaticCredentialsProvider createStaticCredentialsProvider(S3InputSourceConfig s3InputSourceConfig) {
        return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(s3InputSourceConfig.getAccessKeyId().getPassword(), s3InputSourceConfig.getSecretAccessKey().getPassword()));
    }

    @Nullable
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public S3InputSourceConfig getS3InputSourceConfig() {
        return this.s3InputSourceConfig;
    }

    @Nullable
    @JsonProperty(value="proxyConfig")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AWSProxyConfig getAwsProxyConfig() {
        return this.awsProxyConfig;
    }

    @Nullable
    @JsonProperty(value="clientConfig")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AWSClientConfig getAwsClientConfig() {
        return this.awsClientConfig;
    }

    @Nullable
    @JsonProperty(value="endpointConfig")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AWSEndpointConfig getAwsEndpointConfig() {
        return this.awsEndpointConfig;
    }

    protected InputEntity createEntity(CloudObjectLocation location) {
        return new S3Entity((ServerSideEncryptingAmazonS3)this.s3ClientSupplier.get(), location, this.maxRetries);
    }

    protected CloudObjectSplitWidget getSplitWidget() {
        class SplitWidget
        implements CloudObjectSplitWidget {
            SplitWidget() {
            }

            public Iterator<CloudObjectSplitWidget.LocationWithSize> getDescriptorIteratorForPrefixes(List<URI> prefixes) {
                return Iterators.transform(S3Utils.objectSummaryIterator((ServerSideEncryptingAmazonS3)S3InputSource.this.s3ClientSupplier.get(), prefixes, S3InputSource.this.inputDataConfig.getMaxListingLength(), S3InputSource.this.maxRetries), object -> new CloudObjectSplitWidget.LocationWithSize(object.getBucketName(), object.getKey(), object.getSize()));
            }

            public long getObjectSize(CloudObjectLocation location) {
                ObjectMetadata objectMetadata = S3Utils.getSingleObjectMetadata((ServerSideEncryptingAmazonS3)S3InputSource.this.s3ClientSupplier.get(), location.getBucket(), location.getPath());
                return objectMetadata.getContentLength();
            }
        }
        return new SplitWidget();
    }

    public SplittableInputSource<List<CloudObjectLocation>> withSplit(InputSplit<List<CloudObjectLocation>> split) {
        return new S3InputSource((ServerSideEncryptingAmazonS3)this.s3ClientSupplier.get(), null, this.inputDataConfig, null, null, null, (List)split.get(), this.getObjectGlob(), this.systemFields, this.getS3InputSourceConfig(), this.getAwsProxyConfig(), this.getAwsEndpointConfig(), this.getAwsClientConfig());
    }

    public Object getSystemFieldValue(InputEntity entity, SystemField field) {
        S3Entity s3Entity = (S3Entity)entity;
        switch (field) {
            case URI: {
                return s3Entity.getUri().toString();
            }
            case BUCKET: {
                return s3Entity.getObject().getBucket();
            }
            case PATH: {
                return s3Entity.getObject().getPath();
            }
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.s3InputSourceConfig, this.awsProxyConfig, this.awsClientConfig, this.awsEndpointConfig, this.maxRetries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        S3InputSource that = (S3InputSource)((Object)o);
        return Objects.equals(this.s3InputSourceConfig, that.s3InputSourceConfig) && Objects.equals(this.awsProxyConfig, that.awsProxyConfig) && Objects.equals(this.awsClientConfig, that.awsClientConfig) && Objects.equals(this.awsEndpointConfig, that.awsEndpointConfig) && this.maxRetries == that.maxRetries;
    }

    public String toString() {
        return "S3InputSource{uris=" + this.getUris() + ", prefixes=" + this.getPrefixes() + ", objects=" + this.getObjects() + ", objectGlob=" + this.getObjectGlob() + (String)(this.systemFields.getFields().isEmpty() ? "" : ", systemFields=" + this.systemFields) + ", s3InputSourceConfig=" + this.getS3InputSourceConfig() + ", awsProxyConfig=" + this.getAwsProxyConfig() + ", awsEndpointConfig=" + this.getAwsEndpointConfig() + ", awsClientConfig=" + this.getAwsClientConfig() + "}";
    }
}

