/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.setup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import org.apache.druid.indexing.overlord.setup.AffinityConfig;
import org.apache.druid.indexing.overlord.setup.WorkerSelectStrategy;
import org.apache.druid.indexing.overlord.setup.WorkerSelectUtils;

public class EqualDistributionWorkerSelectStrategy
implements WorkerSelectStrategy {
    private final AffinityConfig affinityConfig;

    @JsonCreator
    public EqualDistributionWorkerSelectStrategy(@JsonProperty(value="affinityConfig") AffinityConfig affinityConfig) {
        this.affinityConfig = affinityConfig;
    }

    @JsonProperty
    public AffinityConfig getAffinityConfig() {
        return this.affinityConfig;
    }

    @Override
    public ImmutableWorkerInfo findWorkerForTask(WorkerTaskRunnerConfig config, ImmutableMap<String, ImmutableWorkerInfo> zkWorkers, Task task) {
        return WorkerSelectUtils.selectWorker(task, zkWorkers, config, this.affinityConfig, EqualDistributionWorkerSelectStrategy::selectFromEligibleWorkers);
    }

    static ImmutableWorkerInfo selectFromEligibleWorkers(Map<String, ImmutableWorkerInfo> eligibleWorkers) {
        return eligibleWorkers.values().stream().max(Comparator.comparing(ImmutableWorkerInfo::getAvailableCapacity)).orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EqualDistributionWorkerSelectStrategy that = (EqualDistributionWorkerSelectStrategy)o;
        return Objects.equals(this.affinityConfig, that.affinityConfig);
    }

    public int hashCode() {
        return Objects.hash(this.affinityConfig);
    }

    public String toString() {
        return "EqualDistributionWorkerSelectStrategy{affinityConfig=" + this.affinityConfig + "}";
    }
}

