/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.compact;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.indexing.ClientCompactionRunnerInfo;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.compact.CompactionScheduler;
import org.apache.druid.indexing.compact.LocalOverlordClient;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskQueryTool;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerListener;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.server.compaction.CompactionRunSimulator;
import org.apache.druid.server.compaction.CompactionSimulateResult;
import org.apache.druid.server.compaction.CompactionStatusTracker;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.CompactionConfigValidationResult;
import org.apache.druid.server.coordinator.CompactionSupervisorConfig;
import org.apache.druid.server.coordinator.CoordinatorOverlordServiceConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.apache.druid.server.coordinator.duty.CompactSegments;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.CoordinatorStat;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.Duration;

public class OverlordCompactionScheduler
implements CompactionScheduler {
    private static final Logger log = new Logger(OverlordCompactionScheduler.class);
    private static final long SCHEDULE_PERIOD_SECONDS = 5L;
    private static final Duration METRIC_EMISSION_PERIOD = Duration.standardMinutes((long)5L);
    private final SegmentsMetadataManager segmentManager;
    private final LocalOverlordClient overlordClient;
    private final ServiceEmitter emitter;
    private final TaskMaster taskMaster;
    private final CompactionSupervisorConfig supervisorConfig;
    private final Supplier<DruidCompactionConfig> compactionConfigSupplier;
    private final ConcurrentHashMap<String, DataSourceCompactionConfig> activeDatasourceConfigs;
    private final ScheduledExecutorService executor;
    private final CompactionStatusTracker statusTracker;
    private final TaskRunnerListener taskRunnerListener;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final CompactSegments duty;
    private final boolean shouldPollSegments;
    private final Stopwatch sinceStatsEmitted = Stopwatch.createUnstarted();

    @Inject
    public OverlordCompactionScheduler(TaskMaster taskMaster, TaskQueryTool taskQueryTool, SegmentsMetadataManager segmentManager, Supplier<DruidCompactionConfig> compactionConfigSupplier, final CompactionStatusTracker statusTracker, CompactionSupervisorConfig supervisorConfig, CoordinatorOverlordServiceConfig coordinatorOverlordServiceConfig, ScheduledExecutorFactory executorFactory, ServiceEmitter emitter, ObjectMapper objectMapper) {
        this.segmentManager = segmentManager;
        this.emitter = emitter;
        this.taskMaster = taskMaster;
        this.supervisorConfig = supervisorConfig;
        this.compactionConfigSupplier = compactionConfigSupplier;
        this.executor = executorFactory.create(1, "CompactionScheduler-%s");
        this.statusTracker = statusTracker;
        this.shouldPollSegments = segmentManager != null && !coordinatorOverlordServiceConfig.isEnabled();
        this.overlordClient = new LocalOverlordClient(taskMaster, taskQueryTool, objectMapper);
        this.duty = new CompactSegments(this.statusTracker, (OverlordClient)this.overlordClient);
        this.activeDatasourceConfigs = new ConcurrentHashMap();
        this.taskRunnerListener = new TaskRunnerListener(){

            @Override
            public String getListenerId() {
                return "OverlordCompactionScheduler";
            }

            @Override
            public void locationChanged(String taskId, TaskLocation newLocation) {
            }

            @Override
            public void statusChanged(String taskId, TaskStatus status) {
                if (status.isComplete()) {
                    statusTracker.onTaskFinished(taskId, status);
                }
            }
        };
    }

    @Override
    public void start() {
        if (this.isEnabled() && this.started.compareAndSet(false, true)) {
            log.info("Starting compaction scheduler.", new Object[0]);
            this.initState();
            this.scheduleOnExecutor(this::scheduledRun);
        }
    }

    @Override
    public void stop() {
        if (this.isEnabled() && this.started.compareAndSet(true, false)) {
            log.info("Stopping compaction scheduler.", new Object[0]);
            this.cleanupState();
        }
    }

    @Override
    public boolean isRunning() {
        return this.isEnabled() && this.started.get();
    }

    @Override
    public CompactionConfigValidationResult validateCompactionConfig(DataSourceCompactionConfig compactionConfig) {
        if (compactionConfig == null) {
            return CompactionConfigValidationResult.failure((String)"Cannot be null", (Object[])new Object[0]);
        }
        return ClientCompactionRunnerInfo.validateCompactionConfig((DataSourceCompactionConfig)compactionConfig, (CompactionEngine)this.supervisorConfig.getEngine());
    }

    @Override
    public void startCompaction(String dataSourceName, DataSourceCompactionConfig config) {
        if (this.isEnabled()) {
            this.activeDatasourceConfigs.put(dataSourceName, config);
        }
    }

    @Override
    public void stopCompaction(String dataSourceName) {
        this.activeDatasourceConfigs.remove(dataSourceName);
        this.statusTracker.removeDatasource(dataSourceName);
    }

    private synchronized void initState() {
        Optional<TaskRunner> taskRunnerOptional = this.taskMaster.getTaskRunner();
        if (taskRunnerOptional.isPresent()) {
            ((TaskRunner)taskRunnerOptional.get()).registerListener(this.taskRunnerListener, (Executor)Execs.directExecutor());
        }
        if (this.shouldPollSegments) {
            this.segmentManager.startPollingDatabasePeriodically();
        }
    }

    private synchronized void cleanupState() {
        Optional<TaskRunner> taskRunnerOptional = this.taskMaster.getTaskRunner();
        if (taskRunnerOptional.isPresent()) {
            ((TaskRunner)taskRunnerOptional.get()).unregisterListener(this.taskRunnerListener.getListenerId());
        }
        this.statusTracker.stop();
        this.activeDatasourceConfigs.clear();
        if (this.shouldPollSegments) {
            this.segmentManager.stopPollingDatabasePeriodically();
        }
    }

    private boolean isEnabled() {
        return this.supervisorConfig.isEnabled();
    }

    private synchronized void scheduledRun() {
        if (this.isRunning()) {
            try {
                this.runCompactionDuty();
            }
            catch (Exception e) {
                log.error((Throwable)e, "Error processing compaction queue. Continuing schedule.", new Object[0]);
            }
            this.scheduleOnExecutor(this::scheduledRun);
        } else {
            this.cleanupState();
        }
    }

    private synchronized void runCompactionDuty() {
        CoordinatorRunStats stats = new CoordinatorRunStats();
        this.duty.run(this.getLatestConfig(), this.getDatasourceSnapshot(), this.supervisorConfig.getEngine(), stats);
        if (!this.sinceStatsEmitted.isRunning() || this.sinceStatsEmitted.hasElapsed(METRIC_EMISSION_PERIOD)) {
            stats.forEachStat((stat, dimensions, value) -> {
                if (stat.shouldEmit()) {
                    this.emitStat(stat, dimensions.getValues(), value);
                }
            });
            this.sinceStatsEmitted.restart();
        } else {
            long numSubmittedTasks = stats.get(Stats.Compaction.SUBMITTED_TASKS);
            this.emitStat(Stats.Compaction.SUBMITTED_TASKS, Collections.emptyMap(), numSubmittedTasks);
        }
    }

    @Override
    public AutoCompactionSnapshot getCompactionSnapshot(String dataSource) {
        return this.duty.getAutoCompactionSnapshot(dataSource);
    }

    @Override
    public Map<String, AutoCompactionSnapshot> getAllCompactionSnapshots() {
        return this.duty.getAutoCompactionSnapshot();
    }

    @Override
    public CompactionSimulateResult simulateRunWithConfigUpdate(ClusterCompactionConfig updateRequest) {
        if (this.isRunning()) {
            return new CompactionRunSimulator(this.statusTracker, (OverlordClient)this.overlordClient).simulateRunWithConfig(this.getLatestConfig().withClusterConfig(updateRequest), this.getDatasourceSnapshot(), this.supervisorConfig.getEngine());
        }
        return new CompactionSimulateResult(Collections.emptyMap());
    }

    private void emitStat(CoordinatorStat stat, Map<Dimension, String> dimensionValues, long value) {
        ServiceMetricEvent.Builder eventBuilder = new ServiceMetricEvent.Builder();
        dimensionValues.forEach((dim, dimValue) -> eventBuilder.setDimension(dim.reportedName(), dimValue));
        this.emitter.emit((ServiceEventBuilder)eventBuilder.setMetric(stat.getMetricName(), (Number)value));
    }

    private DruidCompactionConfig getLatestConfig() {
        return DruidCompactionConfig.empty().withClusterConfig(((DruidCompactionConfig)this.compactionConfigSupplier.get()).clusterConfig()).withDatasourceConfigs(new ArrayList<DataSourceCompactionConfig>(this.activeDatasourceConfigs.values()));
    }

    private DataSourcesSnapshot getDatasourceSnapshot() {
        return this.segmentManager.getSnapshotOfDataSourcesWithAllUsedSegments();
    }

    private void scheduleOnExecutor(Runnable runnable) {
        this.executor.schedule(() -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                log.error(t, "Error while executing runnable", new Object[0]);
            }
        }, 5L, TimeUnit.SECONDS);
    }
}

