/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.druid.client.BrokerSegmentWatcherConfig;
import org.apache.druid.client.DataSegmentInterner;
import org.apache.druid.client.JsonParserIterator;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.sql.calcite.schema.BrokerSegmentMetadataCacheConfig;
import org.apache.druid.sql.calcite.schema.SystemSchema;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentStatusInCluster;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@ManageLifecycle
public class MetadataSegmentView {
    private static final EmittingLogger log = new EmittingLogger(MetadataSegmentView.class);
    private final DruidLeaderClient coordinatorDruidLeaderClient;
    private final ObjectMapper jsonMapper;
    private final BrokerSegmentWatcherConfig segmentWatcherConfig;
    private final boolean isCacheEnabled;
    private volatile @MonotonicNonNull ImmutableSortedSet<SegmentStatusInCluster> publishedSegments = null;
    private final Cache<SegmentId, Integer> segmentIdToReplicationFactor;
    private final ScheduledExecutorService scheduledExec;
    private final long pollPeriodInMS;
    private final LifecycleLock lifecycleLock = new LifecycleLock();
    private final CountDownLatch cachePopulated = new CountDownLatch(1);

    @Inject
    public MetadataSegmentView(@Coordinator DruidLeaderClient druidLeaderClient, ObjectMapper jsonMapper, BrokerSegmentWatcherConfig segmentWatcherConfig, BrokerSegmentMetadataCacheConfig config) {
        Preconditions.checkNotNull((Object)((Object)config), (Object)"BrokerSegmentMetadataCacheConfig");
        this.coordinatorDruidLeaderClient = druidLeaderClient;
        this.jsonMapper = jsonMapper;
        this.segmentWatcherConfig = segmentWatcherConfig;
        this.isCacheEnabled = config.isMetadataSegmentCacheEnable();
        this.pollPeriodInMS = config.getMetadataSegmentPollPeriod();
        this.scheduledExec = Execs.scheduledSingleThreaded((String)"MetadataSegmentView-Cache--%d");
        this.segmentIdToReplicationFactor = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    }

    @LifecycleStart
    public void start() {
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        try {
            if (this.isCacheEnabled) {
                this.scheduledExec.schedule(new PollTask(), this.pollPeriodInMS, TimeUnit.MILLISECONDS);
            }
            this.lifecycleLock.started();
            log.info("MetadataSegmentView is started.", new Object[0]);
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            throw new ISE("can't stop.", new Object[0]);
        }
        log.info("MetadataSegmentView is stopping.", new Object[0]);
        if (this.isCacheEnabled) {
            this.scheduledExec.shutdown();
        }
        log.info("MetadataSegmentView is stopped.", new Object[0]);
    }

    private void poll() {
        log.info("Polling segments from coordinator", new Object[0]);
        JsonParserIterator<SegmentStatusInCluster> metadataSegments = this.getMetadataSegments(this.coordinatorDruidLeaderClient, this.jsonMapper, this.segmentWatcherConfig.getWatchedDataSources());
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        while (metadataSegments.hasNext()) {
            SegmentStatusInCluster segment = (SegmentStatusInCluster)metadataSegments.next();
            DataSegment interned = DataSegmentInterner.intern((DataSegment)segment.getDataSegment());
            Integer replicationFactor = segment.getReplicationFactor();
            if (replicationFactor == null) {
                replicationFactor = (Integer)this.segmentIdToReplicationFactor.getIfPresent((Object)segment.getDataSegment().getId());
            } else {
                this.segmentIdToReplicationFactor.put((Object)segment.getDataSegment().getId(), (Object)segment.getReplicationFactor());
            }
            SegmentStatusInCluster segmentStatusInCluster = new SegmentStatusInCluster(interned, segment.isOvershadowed(), replicationFactor, segment.getNumRows(), segment.isRealtime());
            builder.add((Object)segmentStatusInCluster);
        }
        this.publishedSegments = builder.build();
        this.cachePopulated.countDown();
    }

    Iterator<SegmentStatusInCluster> getSegments() {
        if (this.isCacheEnabled) {
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.cachePopulated);
            return this.publishedSegments.iterator();
        }
        return this.getMetadataSegments(this.coordinatorDruidLeaderClient, this.jsonMapper, this.segmentWatcherConfig.getWatchedDataSources());
    }

    private JsonParserIterator<SegmentStatusInCluster> getMetadataSegments(DruidLeaderClient coordinatorClient, ObjectMapper jsonMapper, Set<String> watchedDataSources) {
        StringBuilder queryBuilder = new StringBuilder("/druid/coordinator/v1/metadata/segments?includeOvershadowedStatus&includeRealtimeSegments");
        if (watchedDataSources != null && !watchedDataSources.isEmpty()) {
            log.debug("Filtering datasources in segments based on broker's watchedDataSources[%s]", new Object[]{watchedDataSources});
            StringBuilder sb = new StringBuilder();
            for (String ds : watchedDataSources) {
                sb.append("datasources=").append(ds).append("&");
            }
            sb.setLength(sb.length() - 1);
            queryBuilder.append("&");
            queryBuilder.append((CharSequence)sb);
        }
        return SystemSchema.getThingsFromLeaderNode(queryBuilder.toString(), new TypeReference<SegmentStatusInCluster>(){}, coordinatorClient, jsonMapper);
    }

    private class PollTask
    implements Runnable {
        private PollTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long delayMS = MetadataSegmentView.this.pollPeriodInMS;
            try {
                long pollStartTime = System.nanoTime();
                MetadataSegmentView.this.poll();
                long pollEndTime = System.nanoTime();
                long pollTimeNS = pollEndTime - pollStartTime;
                long pollTimeMS = TimeUnit.NANOSECONDS.toMillis(pollTimeNS);
                delayMS = Math.max(MetadataSegmentView.this.pollPeriodInMS - pollTimeMS, 0L);
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Problem polling Coordinator.", new Object[0]).emit();
            }
            finally {
                if (!Thread.currentThread().isInterrupted()) {
                    MetadataSegmentView.this.scheduledExec.schedule(new PollTask(), delayMS, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

