/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.run;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.NlsString;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class SqlResults {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object coerce(ObjectMapper jsonMapper, Context context, Object value, SqlTypeName sqlTypeName, String fieldName) {
        if (SqlTypeName.CHAR_TYPES.contains(sqlTypeName)) {
            if (value == null) return NullHandling.nullToEmptyIfNeeded((String)((String)value));
            if (value instanceof String) {
                return NullHandling.nullToEmptyIfNeeded((String)((String)value));
            }
            if (value instanceof NlsString) {
                return ((NlsString)value).getValue();
            }
            if (value instanceof Number) {
                return String.valueOf(value);
            }
            if (value instanceof Boolean) {
                return String.valueOf(value);
            }
            Object maybeList = SqlResults.coerceArrayToList(value, false);
            if (!(maybeList instanceof Collection)) throw SqlResults.cannotCoerce(value, sqlTypeName, fieldName);
            List valueStrings = ((Collection)maybeList).stream().map(v -> (String)SqlResults.coerce(jsonMapper, context, v, sqlTypeName, fieldName)).collect(Collectors.toList());
            return SqlResults.coerceUsingObjectMapper(jsonMapper, valueStrings, sqlTypeName, fieldName);
        }
        if (value == null) {
            return null;
        }
        if (sqlTypeName == SqlTypeName.DATE) {
            return Calcites.jodaToCalciteDate(SqlResults.coerceDateTime(value, sqlTypeName, fieldName), context.getTimeZone());
        }
        if (sqlTypeName == SqlTypeName.TIMESTAMP) {
            return Calcites.jodaToCalciteTimestamp(SqlResults.coerceDateTime(value, sqlTypeName, fieldName), context.getTimeZone());
        }
        if (sqlTypeName == SqlTypeName.BOOLEAN) {
            if (value instanceof Boolean) {
                return value;
            }
            if (value instanceof String) {
                return Evals.asBoolean((String)((String)value));
            }
            if (!(value instanceof Number)) throw SqlResults.cannotCoerce(value, sqlTypeName, fieldName);
            return Evals.asBoolean((long)((Number)value).longValue());
        }
        if (sqlTypeName == SqlTypeName.INTEGER) {
            if (value instanceof String) {
                return Ints.tryParse((String)((String)value));
            }
            if (!(value instanceof Number)) throw SqlResults.cannotCoerce(value, sqlTypeName, fieldName);
            return ((Number)value).intValue();
        }
        if (sqlTypeName == SqlTypeName.BIGINT) {
            try {
                return DimensionHandlerUtils.convertObjectToLong((Object)value, (String)fieldName);
            }
            catch (Exception e) {
                throw SqlResults.cannotCoerce(value, sqlTypeName, fieldName);
            }
        }
        if (sqlTypeName == SqlTypeName.FLOAT) {
            try {
                return DimensionHandlerUtils.convertObjectToFloat((Object)value, (String)fieldName);
            }
            catch (Exception e) {
                throw SqlResults.cannotCoerce(value, sqlTypeName, fieldName);
            }
        }
        if (SqlTypeName.FRACTIONAL_TYPES.contains(sqlTypeName)) {
            try {
                return DimensionHandlerUtils.convertObjectToDouble((Object)value, (String)fieldName);
            }
            catch (Exception e) {
                throw SqlResults.cannotCoerce(value, sqlTypeName, fieldName);
            }
        }
        if (sqlTypeName == SqlTypeName.OTHER) {
            if (!context.isSerializeComplexValues()) return value.getClass().getName();
            return SqlResults.coerceUsingObjectMapper(jsonMapper, value, sqlTypeName, fieldName);
        }
        if (sqlTypeName != SqlTypeName.ARRAY) throw SqlResults.cannotCoerce(value, sqlTypeName, fieldName);
        if (!context.isStringifyArrays()) return SqlResults.coerceArrayToList(value, true);
        if (value instanceof String) {
            return NullHandling.nullToEmptyIfNeeded((String)((String)value));
        }
        if (!(value instanceof NlsString)) return SqlResults.coerceUsingObjectMapper(jsonMapper, value, sqlTypeName, fieldName);
        return ((NlsString)value).getValue();
    }

    @Nullable
    @VisibleForTesting
    static Object coerceArrayToList(Object value, boolean mustCoerce) {
        if (value instanceof List) {
            return value;
        }
        if (value instanceof String[]) {
            return Arrays.asList((String[])value);
        }
        if (value instanceof Long[]) {
            return Arrays.asList((Long[])value);
        }
        if (value instanceof Double[]) {
            return Arrays.asList((Double[])value);
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            ArrayList<Object> lst = new ArrayList<Object>(array.length);
            for (Object o : array) {
                lst.add(SqlResults.coerceArrayToList(o, false));
            }
            return lst;
        }
        if (value instanceof long[]) {
            return Arrays.stream((long[])value).boxed().collect(Collectors.toList());
        }
        if (value instanceof double[]) {
            return Arrays.stream((double[])value).boxed().collect(Collectors.toList());
        }
        if (value instanceof float[]) {
            float[] array = (float[])value;
            ArrayList<Float> lst = new ArrayList<Float>(array.length);
            for (float f : array) {
                lst.add(Float.valueOf(f));
            }
            return lst;
        }
        if (mustCoerce) {
            return Collections.singletonList(value);
        }
        return value;
    }

    private static DateTime coerceDateTime(Object value, SqlTypeName sqlType, String fieldName) {
        DateTime dateTime;
        if (value instanceof Number) {
            dateTime = DateTimes.utc((long)((Number)value).longValue());
        } else if (value instanceof String) {
            dateTime = DateTimes.utc((long)Long.parseLong((String)value));
        } else if (value instanceof DateTime) {
            dateTime = (DateTime)value;
        } else {
            throw SqlResults.cannotCoerce(value, sqlType, fieldName);
        }
        return dateTime;
    }

    private static String coerceUsingObjectMapper(ObjectMapper jsonMapper, Object value, SqlTypeName sqlTypeName, String fieldName) {
        try {
            return jsonMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw SqlResults.cannotCoerce(e, value, sqlTypeName, fieldName);
        }
    }

    private static DruidException cannotCoerce(Throwable t, Object value, SqlTypeName sqlTypeName, String fieldName) {
        return DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build(t, "Cannot coerce field [%s] from type [%s] to type [%s]", new Object[]{fieldName, value == null ? "unknown" : SqlResults.mapPriveArrayClassNameToReadableStrings(value.getClass().getName()), sqlTypeName});
    }

    private static String mapPriveArrayClassNameToReadableStrings(String name) {
        switch (name) {
            case "[B": {
                return "Byte Array";
            }
            case "[Z": {
                return "Boolean Array";
            }
        }
        return name;
    }

    private static DruidException cannotCoerce(Object value, SqlTypeName sqlTypeName, String fieldName) {
        return SqlResults.cannotCoerce(null, value, sqlTypeName, fieldName);
    }

    public static class Context {
        private final DateTimeZone timeZone;
        private final boolean serializeComplexValues;
        private final boolean stringifyArrays;

        @JsonCreator
        public Context(@JsonProperty(value="timeZone") DateTimeZone timeZone, @JsonProperty(value="serializeComplexValues") boolean serializeComplexValues, @JsonProperty(value="stringifyArrays") boolean stringifyArrays) {
            this.timeZone = timeZone;
            this.serializeComplexValues = serializeComplexValues;
            this.stringifyArrays = stringifyArrays;
        }

        public static Context fromPlannerContext(PlannerContext plannerContext) {
            return new Context(plannerContext.getTimeZone(), plannerContext.getPlannerConfig().shouldSerializeComplexValues(), plannerContext.isStringifyArrays());
        }

        @JsonProperty
        public DateTimeZone getTimeZone() {
            return this.timeZone;
        }

        @JsonProperty
        public boolean isSerializeComplexValues() {
            return this.serializeComplexValues;
        }

        @JsonProperty
        public boolean isStringifyArrays() {
            return this.stringifyArrays;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Context context = (Context)o;
            return this.serializeComplexValues == context.serializeComplexValues && this.stringifyArrays == context.stringifyArrays && Objects.equals(this.timeZone, context.timeZone);
        }

        public int hashCode() {
            return Objects.hash(this.timeZone, this.serializeComplexValues, this.stringifyArrays);
        }

        public String toString() {
            return "Context{timeZone=" + this.timeZone + ", serializeComplexValues=" + this.serializeComplexValues + ", stringifyArrays=" + this.stringifyArrays + '}';
        }
    }
}

