/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import java.util.Collections;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.druid.sql.calcite.rel.DruidUnionRel;

public class DruidSortUnionRule
extends RelOptRule {
    private static final DruidSortUnionRule INSTANCE = new DruidSortUnionRule();

    private DruidSortUnionRule() {
        super(DruidSortUnionRule.operand(Sort.class, (RelOptRuleOperand)DruidSortUnionRule.operand(DruidUnionRel.class, (RelOptRuleOperandChildren)DruidSortUnionRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public static DruidSortUnionRule instance() {
        return INSTANCE;
    }

    public boolean matches(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        return sort.collation.getFieldCollations().isEmpty() && sort.fetch != null;
    }

    public void onMatch(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        DruidUnionRel unionRel = (DruidUnionRel)call.rel(1);
        int limit = RexLiteral.intValue((RexNode)sort.fetch);
        int offset = sort.offset != null ? RexLiteral.intValue((RexNode)sort.offset) : 0;
        DruidUnionRel newUnionRel = DruidUnionRel.create(unionRel.getPlannerContext(), unionRel.getRowType(), unionRel.getInputs(), unionRel.getLimit() >= 0 ? Math.min(limit + offset, unionRel.getLimit()) : limit + offset);
        if (offset == 0) {
            call.transformTo((RelNode)newUnionRel);
        } else {
            call.transformTo(call.builder().push((RelNode)newUnionRel).sortLimit(offset, -1, Collections.emptyList()).build());
        }
    }
}

