/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3.output;

import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.google.common.base.Stopwatch;
import com.google.common.io.CountingOutputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.storage.s3.S3Utils;
import org.apache.druid.storage.s3.ServerSideEncryptingAmazonS3;
import org.apache.druid.storage.s3.output.S3OutputConfig;
import org.apache.druid.storage.s3.output.S3UploadManager;

public class RetryableS3OutputStream
extends OutputStream {
    private static final String METRIC_PREFIX = "s3/upload/total/";
    private static final String METRIC_TOTAL_UPLOAD_TIME = "s3/upload/total/time";
    private static final String METRIC_TOTAL_UPLOAD_BYTES = "s3/upload/total/bytes";
    private static final Logger LOG = new Logger(RetryableS3OutputStream.class);
    private final S3OutputConfig config;
    private final ServerSideEncryptingAmazonS3 s3;
    private final String s3Key;
    private final String uploadId;
    private final File chunkStorePath;
    private final long chunkSize;
    private final byte[] singularBuffer = new byte[1];
    private final Stopwatch pushStopwatch;
    private Chunk currentChunk;
    private int nextChunkId = 1;
    private boolean error;
    private boolean closed;
    private final S3UploadManager uploadManager;
    private final List<Future<UploadPartResult>> futures = new ArrayList<Future<UploadPartResult>>();

    public RetryableS3OutputStream(S3OutputConfig config, ServerSideEncryptingAmazonS3 s3, String s3Key, S3UploadManager uploadManager) throws IOException {
        InitiateMultipartUploadResult result;
        this.config = config;
        this.s3 = s3;
        this.s3Key = s3Key;
        this.uploadManager = uploadManager;
        try {
            result = (InitiateMultipartUploadResult)S3Utils.retryS3Operation(() -> s3.initiateMultipartUpload(new InitiateMultipartUploadRequest(config.getBucket(), s3Key)), config.getMaxRetry());
        }
        catch (Exception e) {
            throw new IOException("Unable to start multipart upload", e);
        }
        this.uploadId = result.getUploadId();
        this.chunkStorePath = new File(config.getTempDir(), this.uploadId + UUID.randomUUID());
        org.apache.druid.java.util.common.FileUtils.mkdirp((File)this.chunkStorePath);
        this.chunkSize = config.getChunkSize();
        this.pushStopwatch = Stopwatch.createStarted();
        this.currentChunk = new Chunk(this.nextChunkId, new File(this.chunkStorePath, String.valueOf(this.nextChunkId++)));
    }

    @Override
    public void write(int b) throws IOException {
        this.singularBuffer[0] = (byte)b;
        this.write(this.singularBuffer, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            this.error = true;
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            this.error = true;
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        try {
            int writtenBytes;
            int offsetToWrite = off;
            for (int remainingBytesToWrite = len; remainingBytesToWrite > 0; remainingBytesToWrite -= writtenBytes) {
                writtenBytes = this.writeToCurrentChunk(b, offsetToWrite, remainingBytesToWrite);
                if (this.currentChunk.length() >= this.chunkSize) {
                    this.pushCurrentChunk();
                    this.currentChunk = new Chunk(this.nextChunkId, new File(this.chunkStorePath, String.valueOf(this.nextChunkId++)));
                }
                offsetToWrite += writtenBytes;
            }
        }
        catch (IOException | RuntimeException e) {
            this.error = true;
            throw e;
        }
    }

    private int writeToCurrentChunk(byte[] b, int off, int len) throws IOException {
        int lenToWrite = Math.min(len, Math.toIntExact(this.chunkSize - this.currentChunk.length()));
        this.currentChunk.outputStream.write(b, off, lenToWrite);
        return lenToWrite;
    }

    private void pushCurrentChunk() throws IOException {
        this.currentChunk.close();
        Chunk chunk = this.currentChunk;
        if (chunk.length() > 0L) {
            this.futures.add(this.uploadManager.queueChunkForUpload(this.s3, this.s3Key, chunk.id, chunk.file, this.uploadId, this.config));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Closer closer = Closer.create();
        closer.register(() -> {
            FileUtils.forceDelete((File)this.chunkStorePath);
            long totalBytesUploaded = (long)(this.currentChunk.id - 1) * this.chunkSize + this.currentChunk.length();
            long totalUploadTimeMillis = this.pushStopwatch.elapsed(TimeUnit.MILLISECONDS);
            LOG.debug("Pushed total [%d] parts containing [%d] bytes in [%d]ms for s3Key[%s], uploadId[%s].", new Object[]{this.futures.size(), totalBytesUploaded, totalUploadTimeMillis, this.s3Key, this.uploadId});
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("uploadId", (Object)this.uploadId);
            this.uploadManager.emitMetric(builder.setMetric(METRIC_TOTAL_UPLOAD_TIME, (Number)totalUploadTimeMillis));
            this.uploadManager.emitMetric(builder.setMetric(METRIC_TOTAL_UPLOAD_BYTES, (Number)totalBytesUploaded));
        });
        try (Closer ignored = closer;){
            if (!this.error) {
                this.pushCurrentChunk();
                this.completeMultipartUpload();
            }
        }
    }

    private void completeMultipartUpload() {
        ArrayList<PartETag> pushResults = new ArrayList<PartETag>();
        for (Future<UploadPartResult> future : this.futures) {
            if (this.error) {
                future.cancel(true);
            }
            try {
                UploadPartResult result = future.get(1L, TimeUnit.HOURS);
                pushResults.add(result.getPartETag());
            }
            catch (Exception e) {
                this.error = true;
                LOG.error((Throwable)e, "Error in uploading part for upload ID [%s]", new Object[]{this.uploadId});
            }
        }
        try {
            boolean isAllPushSucceeded;
            boolean bl = isAllPushSucceeded = !this.error && !pushResults.isEmpty() && this.futures.size() == pushResults.size();
            if (isAllPushSucceeded) {
                RetryUtils.retry(() -> this.s3.completeMultipartUpload(new CompleteMultipartUploadRequest(this.config.getBucket(), this.s3Key, this.uploadId, pushResults)), S3Utils.S3RETRY, (int)this.config.getMaxRetry());
            } else {
                RetryUtils.retry(() -> {
                    this.s3.cancelMultiPartUpload(new AbortMultipartUploadRequest(this.config.getBucket(), this.s3Key, this.uploadId));
                    return null;
                }, S3Utils.S3RETRY, (int)this.config.getMaxRetry());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class Chunk
    implements Closeable {
        private final int id;
        private final File file;
        private final CountingOutputStream outputStream;
        private boolean closed;

        private Chunk(int id, File file) throws FileNotFoundException {
            this.id = id;
            this.file = file;
            this.outputStream = new CountingOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(file)));
        }

        private long length() {
            return this.outputStream.getCount();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Chunk chunk = (Chunk)o;
            return this.id == chunk.id;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.outputStream.close();
        }

        public String toString() {
            return "Chunk{id=" + this.id + ", file=" + this.file.getAbsolutePath() + ", size=" + this.length() + '}';
        }
    }
}

