/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import com.google.common.collect.Ordering;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.Rows;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogram;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogramAggregator;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogramAggregatorFactory;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;

public class FixedBucketsHistogramSerde
extends ComplexMetricSerde {
    private static Ordering<FixedBucketsHistogram> comparator = new Ordering<FixedBucketsHistogram>(){

        public int compare(FixedBucketsHistogram arg1, FixedBucketsHistogram arg2) {
            return FixedBucketsHistogramAggregator.COMPARATOR.compare(arg1, arg2);
        }
    }.nullsFirst();

    public String getTypeName() {
        return "fixedBucketsHistogram";
    }

    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){

            public Class<FixedBucketsHistogram> extractedClass() {
                return FixedBucketsHistogram.class;
            }

            @Nullable
            public Object extractValue(InputRow inputRow, String metricName) {
                throw new UnsupportedOperationException("extractValue without an aggregator factory is not supported.");
            }

            public FixedBucketsHistogram extractValue(InputRow inputRow, String metricName, AggregatorFactory agg) {
                Object rawValue = inputRow.getRaw(metricName);
                FixedBucketsHistogramAggregatorFactory aggregatorFactory = (FixedBucketsHistogramAggregatorFactory)agg;
                if (rawValue == null) {
                    FixedBucketsHistogram fbh = new FixedBucketsHistogram(aggregatorFactory.getLowerLimit(), aggregatorFactory.getUpperLimit(), aggregatorFactory.getNumBuckets(), aggregatorFactory.getOutlierHandlingMode());
                    if (NullHandling.replaceWithDefault()) {
                        fbh.add(NullHandling.defaultDoubleValue());
                    } else {
                        fbh.incrementMissing();
                    }
                    return fbh;
                }
                if (rawValue instanceof Number) {
                    FixedBucketsHistogram fbh = new FixedBucketsHistogram(aggregatorFactory.getLowerLimit(), aggregatorFactory.getUpperLimit(), aggregatorFactory.getNumBuckets(), aggregatorFactory.getOutlierHandlingMode());
                    fbh.add(((Number)rawValue).doubleValue());
                    return fbh;
                }
                if (rawValue instanceof FixedBucketsHistogram) {
                    return (FixedBucketsHistogram)rawValue;
                }
                if (rawValue instanceof String) {
                    try {
                        Number numberAttempt = Rows.objectToNumber((String)metricName, (Object)rawValue, (boolean)true);
                        FixedBucketsHistogram fbh = new FixedBucketsHistogram(aggregatorFactory.getLowerLimit(), aggregatorFactory.getUpperLimit(), aggregatorFactory.getNumBuckets(), aggregatorFactory.getOutlierHandlingMode());
                        fbh.add(numberAttempt.doubleValue());
                        return fbh;
                    }
                    catch (ParseException pe) {
                        FixedBucketsHistogram fbh = FixedBucketsHistogram.fromBase64((String)rawValue);
                        return fbh;
                    }
                }
                throw new UnsupportedOperationException("Unknown type: " + rawValue.getClass());
            }
        };
    }

    public ObjectStrategy getObjectStrategy() {
        return new ObjectStrategy<FixedBucketsHistogram>(){

            public Class<? extends FixedBucketsHistogram> getClazz() {
                return FixedBucketsHistogram.class;
            }

            public FixedBucketsHistogram fromByteBuffer(ByteBuffer buffer, int numBytes) {
                buffer.limit(buffer.position() + numBytes);
                FixedBucketsHistogram fbh = FixedBucketsHistogram.fromByteBuffer(buffer);
                return fbh;
            }

            public byte[] toBytes(FixedBucketsHistogram h) {
                if (h == null) {
                    return new byte[0];
                }
                return h.toBytes();
            }

            public int compare(FixedBucketsHistogram o1, FixedBucketsHistogram o2) {
                return comparator.compare((Object)o1, (Object)o2);
            }

            public boolean readRetainsBufferReference() {
                return false;
            }
        };
    }
}

