/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchHolder;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class HllSketchToEstimatePostAggregator
implements PostAggregator {
    private final String name;
    private final PostAggregator field;
    private final boolean round;

    @JsonCreator
    public HllSketchToEstimatePostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field, @JsonProperty(value="round") boolean round) {
        this.name = name;
        this.field = field;
        this.round = round;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public ColumnType getType(ColumnInspector signature) {
        return this.round ? ColumnType.LONG : ColumnType.DOUBLE;
    }

    @JsonProperty
    public PostAggregator getField() {
        return this.field;
    }

    @JsonProperty
    public boolean isRound() {
        return this.round;
    }

    public Set<String> getDependentFields() {
        return this.field.getDependentFields();
    }

    public Comparator<Double> getComparator() {
        return ArithmeticPostAggregator.DEFAULT_COMPARATOR;
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        Object hllSketchHolderObject = this.field.compute(combinedAggregators);
        if (hllSketchHolderObject == null) {
            return 0.0;
        }
        HllSketchHolder holder = HllSketchHolder.fromObj(hllSketchHolderObject);
        double estimate = holder.getEstimate();
        return this.round ? (double)Math.round(estimate) : estimate;
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(32).appendCacheable((Cacheable)this.field).build();
    }

    public String toString() {
        return "HllSketchToEstimatePostAggregator{name='" + this.name + '\'' + ", field=" + this.field + ", round=" + this.round + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HllSketchToEstimatePostAggregator that = (HllSketchToEstimatePostAggregator)o;
        return this.round == that.round && this.name.equals(that.name) && this.field.equals(that.field);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.field, this.round);
    }
}

