/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.teststats;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.query.Queries;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

@JsonTypeName(value="pvalue2tailedZtest")
public class PvaluefromZscorePostAggregator
implements PostAggregator {
    private final String name;
    private final PostAggregator zScore;

    @JsonCreator
    public PvaluefromZscorePostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="zScore") PostAggregator zScore) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null post-aggregator");
        Preconditions.checkNotNull((Object)zScore, (Object)"Must have a valid, non-null post-aggregator");
        this.name = name;
        this.zScore = zScore;
    }

    public Set<String> getDependentFields() {
        HashSet<String> dependentFields = new HashSet<String>(this.zScore.getDependentFields());
        return dependentFields;
    }

    public Comparator getComparator() {
        return ArithmeticPostAggregator.DEFAULT_COMPARATOR;
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        Object result = this.zScore.compute(combinedAggregators);
        if (!(result instanceof Number)) {
            return null;
        }
        double zScoreValue = ((Number)result).doubleValue();
        zScoreValue = Math.abs(zScoreValue);
        return 2.0 * (1.0 - this.cumulativeProbability(zScoreValue));
    }

    private double cumulativeProbability(double x) {
        try {
            NormalDistribution normDist = new NormalDistribution();
            return normDist.cumulativeProbability(x);
        }
        catch (IllegalArgumentException ex) {
            return Double.NaN;
        }
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public ColumnType getType(ColumnInspector signature) {
        return ColumnType.DOUBLE;
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return new PvaluefromZscorePostAggregator(this.name, (PostAggregator)Iterables.getOnlyElement((Iterable)Queries.decoratePostAggregators(Collections.singletonList(this.zScore), aggregators)));
    }

    @JsonProperty
    public PostAggregator getzScore() {
        return this.zScore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PvaluefromZscorePostAggregator that = (PvaluefromZscorePostAggregator)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.zScore.equals(that.zScore);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.zScore.hashCode();
        return result;
    }

    public String toString() {
        return "PvaluefromZscorePostAggregator{name='" + this.name + '\'' + ", zScore=" + this.zScore + '}';
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(22).appendCacheable((Cacheable)this.zScore).build();
    }
}

