/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.log;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.IOException;
import javax.validation.constraints.NotNull;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.log.RequestLoggerProvider;

@JsonTypeName(value="switching")
public class SwitchingRequestLoggerProvider
implements RequestLoggerProvider {
    private static final Logger log = new Logger(SwitchingRequestLoggerProvider.class);
    @JsonProperty
    @NotNull
    private RequestLoggerProvider nativeQueryLogger;
    @JsonProperty
    @NotNull
    private RequestLoggerProvider sqlQueryLogger;

    public RequestLogger get() {
        SwitchingRequestLogger logger = new SwitchingRequestLogger((RequestLogger)this.nativeQueryLogger.get(), (RequestLogger)this.sqlQueryLogger.get());
        log.debug((Throwable)new Exception("Stack trace"), "Creating %s at", new Object[]{logger});
        return logger;
    }

    public static class SwitchingRequestLogger
    implements RequestLogger {
        private final RequestLogger nativeQueryLogger;
        private final RequestLogger sqlQueryLogger;

        public SwitchingRequestLogger(RequestLogger nativeQueryLogger, RequestLogger sqlQueryLogger) {
            this.nativeQueryLogger = nativeQueryLogger;
            this.sqlQueryLogger = sqlQueryLogger;
        }

        @Override
        public void logNativeQuery(RequestLogLine requestLogLine) throws IOException {
            this.nativeQueryLogger.logNativeQuery(requestLogLine);
        }

        @Override
        public void logSqlQuery(RequestLogLine requestLogLine) throws IOException {
            this.sqlQueryLogger.logSqlQuery(requestLogLine);
        }

        @Override
        @LifecycleStart
        public void start() throws Exception {
            this.nativeQueryLogger.start();
            this.sqlQueryLogger.start();
        }

        @Override
        @LifecycleStop
        public void stop() {
            this.nativeQueryLogger.stop();
            this.sqlQueryLogger.stop();
        }

        public String toString() {
            return "SwitchingRequestLogger{nativeQueryLogger=" + this.nativeQueryLogger + ", sqlQueryLogger=" + this.sqlQueryLogger + '}';
        }
    }
}

