/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.server.coordinator.duty.MetadataAction;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Partitions;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentTimeline;
import org.joda.time.ReadableInterval;

public class MarkEternityTombstonesAsUnused
implements CoordinatorDuty {
    private static final Logger log = new Logger(MarkEternityTombstonesAsUnused.class);
    private final MetadataAction.DeleteSegments deleteHandler;

    public MarkEternityTombstonesAsUnused(MetadataAction.DeleteSegments deleteHandler) {
        this.deleteHandler = deleteHandler;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        DataSourcesSnapshot dataSourcesSnapshot = params.getDataSourcesSnapshot();
        Map<String, Set<SegmentId>> datasourceToNonOvershadowedEternityTombstones = this.determineNonOvershadowedEternityTombstones(dataSourcesSnapshot);
        if (datasourceToNonOvershadowedEternityTombstones.size() == 0) {
            log.debug("No non-overshadowed eternity tombstones found.", new Object[0]);
            return params;
        }
        log.debug("Found [%d] datasource containing non-overshadowed eternity tombstones[%s]", new Object[]{datasourceToNonOvershadowedEternityTombstones.size(), datasourceToNonOvershadowedEternityTombstones});
        CoordinatorRunStats stats = params.getCoordinatorStats();
        datasourceToNonOvershadowedEternityTombstones.forEach((datasource, nonOvershadowedEternityTombstones) -> {
            RowKey datasourceKey = RowKey.of(Dimension.DATASOURCE, datasource);
            stats.add(Stats.Segments.UNNEEDED_ETERNITY_TOMBSTONE, datasourceKey, nonOvershadowedEternityTombstones.size());
            int unusedCount = this.deleteHandler.markSegmentsAsUnused((Set<SegmentId>)nonOvershadowedEternityTombstones);
            log.info("Successfully marked [%d] non-overshadowed eternity tombstones[%s] of datasource[%s] as unused.", new Object[]{unusedCount, nonOvershadowedEternityTombstones, datasource});
        });
        return params;
    }

    private Map<String, Set<SegmentId>> determineNonOvershadowedEternityTombstones(DataSourcesSnapshot dataSourcesSnapshot) {
        HashMap<String, Set<SegmentId>> datasourceToNonOvershadowedEternityTombstones = new HashMap<String, Set<SegmentId>>();
        dataSourcesSnapshot.getDataSourcesMap().keySet().forEach(datasource -> {
            SegmentTimeline usedSegmentsTimeline = dataSourcesSnapshot.getUsedSegmentsTimelinesPerDataSource().get(datasource);
            Optional usedNonOvershadowedSegments = Optional.fromNullable((Object)usedSegmentsTimeline).transform(timeline -> timeline.findNonOvershadowedObjectsInInterval(Intervals.ETERNITY, Partitions.ONLY_COMPLETE));
            if (usedNonOvershadowedSegments.isPresent()) {
                ((Set)usedNonOvershadowedSegments.get()).forEach(candidateSegment -> {
                    boolean overlaps;
                    if (this.isNewGenerationEternityTombstone((DataSegment)candidateSegment) && !(overlaps = dataSourcesSnapshot.getOvershadowedSegments().stream().filter(overshadowedSegment -> candidateSegment.getDataSource().equals(overshadowedSegment.getDataSource())).anyMatch(overshadowedSegment -> candidateSegment.getInterval().overlaps((ReadableInterval)overshadowedSegment.getInterval())))) {
                        datasourceToNonOvershadowedEternityTombstones.computeIfAbsent((String)datasource, ds -> new HashSet()).add(candidateSegment.getId());
                    }
                });
            }
        });
        return datasourceToNonOvershadowedEternityTombstones;
    }

    private boolean isNewGenerationEternityTombstone(DataSegment segment) {
        return segment.isTombstone() && segment.getShardSpec().getNumCorePartitions() == 0 && (DateTimes.MIN.equals((Object)segment.getInterval().getStart()) || DateTimes.MAX.equals((Object)segment.getInterval().getEnd()));
    }
}

