/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.apache.druid.server.coordinator.balancer.BalancerStrategy;
import org.apache.druid.server.coordinator.loading.SegmentHolder;
import org.apache.druid.server.coordinator.loading.SegmentLoadQueueManager;
import org.apache.druid.server.coordinator.loading.SegmentLoadingConfig;
import org.apache.druid.server.coordinator.loading.SegmentReplicationStatus;
import org.apache.druid.server.coordinator.loading.StrategicSegmentAssigner;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentTimeline;

public class DruidCoordinatorRuntimeParams {
    private final DruidCluster druidCluster;
    private final StrategicSegmentAssigner segmentAssigner;
    private final TreeSet<DataSegment> usedSegmentsNewestFirst;
    private final DataSourcesSnapshot dataSourcesSnapshot;
    private final CoordinatorDynamicConfig coordinatorDynamicConfig;
    private final DruidCompactionConfig compactionConfig;
    private final SegmentLoadingConfig segmentLoadingConfig;
    private final CoordinatorRunStats stats;
    private final BalancerStrategy balancerStrategy;
    private final Set<String> broadcastDatasources;

    private DruidCoordinatorRuntimeParams(DruidCluster druidCluster, StrategicSegmentAssigner segmentAssigner, TreeSet<DataSegment> usedSegmentsNewestFirst, DataSourcesSnapshot dataSourcesSnapshot, CoordinatorDynamicConfig coordinatorDynamicConfig, DruidCompactionConfig compactionConfig, SegmentLoadingConfig segmentLoadingConfig, CoordinatorRunStats stats, BalancerStrategy balancerStrategy, Set<String> broadcastDatasources) {
        this.druidCluster = druidCluster;
        this.segmentAssigner = segmentAssigner;
        this.usedSegmentsNewestFirst = usedSegmentsNewestFirst;
        this.dataSourcesSnapshot = dataSourcesSnapshot;
        this.coordinatorDynamicConfig = coordinatorDynamicConfig;
        this.compactionConfig = compactionConfig;
        this.segmentLoadingConfig = segmentLoadingConfig;
        this.stats = stats;
        this.balancerStrategy = balancerStrategy;
        this.broadcastDatasources = broadcastDatasources;
    }

    public DruidCluster getDruidCluster() {
        return this.druidCluster;
    }

    @Nullable
    public SegmentReplicationStatus getSegmentReplicationStatus() {
        return this.segmentAssigner == null ? null : this.segmentAssigner.getReplicationStatus();
    }

    @Nullable
    public Set<DataSegment> getBroadcastSegments() {
        return this.segmentAssigner == null ? null : this.segmentAssigner.getBroadcastSegments();
    }

    public StrategicSegmentAssigner getSegmentAssigner() {
        return this.segmentAssigner;
    }

    public Map<String, SegmentTimeline> getUsedSegmentsTimelinesPerDataSource() {
        Preconditions.checkState((this.dataSourcesSnapshot != null ? 1 : 0) != 0, (Object)"dataSourcesSnapshot or usedSegments must be set");
        return this.dataSourcesSnapshot.getUsedSegmentsTimelinesPerDataSource();
    }

    public TreeSet<DataSegment> getUsedSegmentsNewestFirst() {
        return this.usedSegmentsNewestFirst;
    }

    public boolean isUsedSegment(DataSegment segment) {
        return this.usedSegmentsNewestFirst.contains(segment);
    }

    public int getUsedSegmentCount() {
        return this.usedSegmentsNewestFirst.size();
    }

    public CoordinatorDynamicConfig getCoordinatorDynamicConfig() {
        return this.coordinatorDynamicConfig;
    }

    public DruidCompactionConfig getCompactionConfig() {
        return this.compactionConfig;
    }

    public SegmentLoadingConfig getSegmentLoadingConfig() {
        return this.segmentLoadingConfig;
    }

    public CoordinatorRunStats getCoordinatorStats() {
        return this.stats;
    }

    public BalancerStrategy getBalancerStrategy() {
        return this.balancerStrategy;
    }

    public Set<String> getBroadcastDatasources() {
        return this.broadcastDatasources;
    }

    public DataSourcesSnapshot getDataSourcesSnapshot() {
        Preconditions.checkState((this.dataSourcesSnapshot != null ? 1 : 0) != 0, (Object)"usedSegments or dataSourcesSnapshot must be set");
        return this.dataSourcesSnapshot;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder buildFromExisting() {
        return new Builder(this.druidCluster, this.segmentAssigner, this.usedSegmentsNewestFirst, this.dataSourcesSnapshot, this.coordinatorDynamicConfig, this.compactionConfig, this.segmentLoadingConfig, this.stats, this.balancerStrategy, this.broadcastDatasources);
    }

    public static class Builder {
        private DruidCluster druidCluster;
        private SegmentLoadQueueManager loadQueueManager;
        private StrategicSegmentAssigner segmentAssigner;
        private TreeSet<DataSegment> usedSegmentsNewestFirst;
        private DataSourcesSnapshot dataSourcesSnapshot;
        private CoordinatorDynamicConfig coordinatorDynamicConfig;
        private DruidCompactionConfig compactionConfig;
        private SegmentLoadingConfig segmentLoadingConfig;
        private CoordinatorRunStats stats;
        private BalancerStrategy balancerStrategy;
        private Set<String> broadcastDatasources;

        private Builder() {
            this.coordinatorDynamicConfig = CoordinatorDynamicConfig.builder().build();
            this.compactionConfig = DruidCompactionConfig.empty();
            this.broadcastDatasources = Collections.emptySet();
        }

        private Builder(DruidCluster cluster, StrategicSegmentAssigner segmentAssigner, TreeSet<DataSegment> usedSegmentsNewestFirst, DataSourcesSnapshot dataSourcesSnapshot, CoordinatorDynamicConfig coordinatorDynamicConfig, DruidCompactionConfig compactionConfig, SegmentLoadingConfig segmentLoadingConfig, CoordinatorRunStats stats, BalancerStrategy balancerStrategy, Set<String> broadcastDatasources) {
            this.druidCluster = cluster;
            this.segmentAssigner = segmentAssigner;
            this.usedSegmentsNewestFirst = usedSegmentsNewestFirst;
            this.dataSourcesSnapshot = dataSourcesSnapshot;
            this.coordinatorDynamicConfig = coordinatorDynamicConfig;
            this.compactionConfig = compactionConfig;
            this.segmentLoadingConfig = segmentLoadingConfig;
            this.stats = stats;
            this.balancerStrategy = balancerStrategy;
            this.broadcastDatasources = broadcastDatasources;
        }

        public DruidCoordinatorRuntimeParams build() {
            Preconditions.checkNotNull((Object)this.dataSourcesSnapshot);
            Preconditions.checkNotNull(this.usedSegmentsNewestFirst);
            this.initStatsIfRequired();
            this.initSegmentAssignerIfRequired();
            return new DruidCoordinatorRuntimeParams(this.druidCluster, this.segmentAssigner, this.usedSegmentsNewestFirst, this.dataSourcesSnapshot, this.coordinatorDynamicConfig, this.compactionConfig, this.segmentLoadingConfig, this.stats, this.balancerStrategy, this.broadcastDatasources);
        }

        private void initStatsIfRequired() {
            Map<Dimension, String> debugDimensions = this.coordinatorDynamicConfig == null ? null : this.coordinatorDynamicConfig.getValidatedDebugDimensions();
            this.stats = this.stats == null ? new CoordinatorRunStats(debugDimensions) : this.stats;
        }

        private void initSegmentAssignerIfRequired() {
            if (this.segmentAssigner != null || this.loadQueueManager == null) {
                return;
            }
            Preconditions.checkNotNull((Object)this.druidCluster);
            Preconditions.checkNotNull((Object)this.balancerStrategy);
            Preconditions.checkNotNull((Object)this.stats);
            if (this.segmentLoadingConfig == null) {
                this.segmentLoadingConfig = SegmentLoadingConfig.create(this.coordinatorDynamicConfig, this.usedSegmentsNewestFirst.size());
            }
            this.segmentAssigner = new StrategicSegmentAssigner(this.loadQueueManager, this.druidCluster, this.balancerStrategy, this.segmentLoadingConfig, this.stats);
        }

        private static TreeSet<DataSegment> createUsedSegmentsSet(Iterable<DataSegment> usedSegments) {
            TreeSet<DataSegment> segmentsSet = new TreeSet<DataSegment>((Comparator<DataSegment>)SegmentHolder.NEWEST_SEGMENT_FIRST);
            usedSegments.forEach(segmentsSet::add);
            return segmentsSet;
        }

        public Builder withDruidCluster(DruidCluster cluster) {
            this.druidCluster = cluster;
            return this;
        }

        public Builder withSegmentAssignerUsing(SegmentLoadQueueManager loadQueueManager) {
            this.loadQueueManager = loadQueueManager;
            return this;
        }

        public Builder withDataSourcesSnapshot(DataSourcesSnapshot snapshot) {
            this.usedSegmentsNewestFirst = Builder.createUsedSegmentsSet(snapshot.iterateAllUsedSegmentsInSnapshot());
            this.dataSourcesSnapshot = snapshot;
            return this;
        }

        public Builder withUsedSegments(DataSegment ... usedSegments) {
            return this.withUsedSegments(Arrays.asList(usedSegments));
        }

        public Builder withUsedSegments(Collection<DataSegment> usedSegments) {
            this.usedSegmentsNewestFirst = Builder.createUsedSegmentsSet(usedSegments);
            this.dataSourcesSnapshot = DataSourcesSnapshot.fromUsedSegments(usedSegments, (ImmutableMap<String, String>)ImmutableMap.of());
            return this;
        }

        public Builder withDynamicConfigs(CoordinatorDynamicConfig configs) {
            this.coordinatorDynamicConfig = configs;
            return this;
        }

        public Builder withSegmentLoadingConfig(SegmentLoadingConfig config) {
            this.segmentLoadingConfig = config;
            return this;
        }

        public Builder withCompactionConfig(DruidCompactionConfig config) {
            this.compactionConfig = config;
            return this;
        }

        public Builder withBalancerStrategy(BalancerStrategy balancerStrategy) {
            this.balancerStrategy = balancerStrategy;
            return this;
        }

        public Builder withBroadcastDatasources(Set<String> broadcastDatasources) {
            this.broadcastDatasources = broadcastDatasources;
            return this;
        }
    }
}

