/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Table {
    private final List<String> columnNames;
    private final List<List<Object>> rows = new ArrayList<List<Object>>();

    public static Table withColumnNames(String ... columnNames) {
        return new Table(Arrays.asList(columnNames), null);
    }

    @JsonCreator
    public Table(@JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="rows") List<List<Object>> rows) {
        this.columnNames = columnNames;
        if (rows != null) {
            this.rows.addAll(rows);
        }
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @JsonProperty
    public List<List<Object>> getRows() {
        return this.rows;
    }

    public void addRow(Object ... values) {
        this.rows.add(Arrays.asList(values));
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public String toString() {
        return "Table{columnNames=" + this.columnNames + ", rows=" + this.rows + '}';
    }
}

